/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.poloniex.dto.PoloniexException;

public class PoloniexErrorAdapter {
    private static final String INVALID_CURRENCY_MESSAGE_START = "Invalid currency pair";

    public static ExchangeException adapt(PoloniexException e) {
        switch (e.getHttpStatusCode()) {
            case 403: {
                return new ExchangeSecurityException((Throwable)((Object)e));
            }
        }
        return PoloniexErrorAdapter.adaptBasedOnErrorMessage(e);
    }

    private static ExchangeException adaptBasedOnErrorMessage(PoloniexException e) {
        String message = e.getError();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return new ExchangeException("Operation failed without any error message");
        }
        if (message.startsWith(INVALID_CURRENCY_MESSAGE_START)) {
            return new CurrencyPairNotValidException(message);
        }
        return new ExchangeException(message, (Throwable)((Object)e));
    }
}

