/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.poloniex.PoloniexAuthenticated;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.PoloniexException;
import org.knowm.xchange.poloniex.dto.trade.PoloniexAccountBalance;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMarginAccountResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMarginPostionResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMoveResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOrderFlags;
import org.knowm.xchange.poloniex.dto.trade.PoloniexTradeResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class PoloniexTradeServiceRaw
extends PoloniexBaseService {
    public PoloniexTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, PoloniexOpenOrder[]> returnOpenOrders() throws IOException {
        return this.poloniexAuthenticated.returnOpenOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexAuthenticated.AllPairs.all);
    }

    public PoloniexUserTrade[] returnOrderTrades(String orderId) throws IOException {
        return this.poloniexAuthenticated.returnOrderTrades(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
    }

    public PoloniexOpenOrder[] returnOpenOrders(CurrencyPair currencyPair) throws IOException {
        return this.poloniexAuthenticated.returnOpenOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexUtils.toPairString(currencyPair));
    }

    public PoloniexUserTrade[] returnTradeHistory(CurrencyPair currencyPair, Long startTime, Long endTime, Integer limit) throws IOException {
        return this.poloniexAuthenticated.returnTradeHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexUtils.toPairString(currencyPair), startTime, endTime, limit);
    }

    public HashMap<String, PoloniexUserTrade[]> returnTradeHistory(Long startTime, Long endTime, Integer limit) throws IOException {
        String ignore = null;
        return this.poloniexAuthenticated.returnTradeHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), "all", startTime, endTime, limit, ignore);
    }

    public PoloniexMarginAccountResponse returnMarginAccountSummary() throws IOException {
        return this.poloniexAuthenticated.returnMarginAccountSummary(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public PoloniexMarginPostionResponse returnMarginPosition(CurrencyPair currencyPair) throws IOException {
        return this.poloniexAuthenticated.getMarginPosition(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexUtils.toPairString(currencyPair));
    }

    public Map<String, PoloniexMarginPostionResponse> returnAllMarginPositions() throws IOException {
        return this.poloniexAuthenticated.getMarginPosition(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexAuthenticated.AllPairs.all);
    }

    public PoloniexAccountBalance returnAvailableAccountBalances(String account) throws IOException {
        return this.poloniexAuthenticated.returnAvailableAccountBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), account);
    }

    public Map<String, Map<String, BigDecimal>> returnTradableBalances() throws IOException {
        return this.poloniexAuthenticated.returnTradableBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public PoloniexAccountBalance[] returnAllAvailableAccountBalances() throws IOException {
        return this.poloniexAuthenticated.returnAvailableAccountBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public PoloniexTradeResponse buy(LimitOrder limitOrder) throws IOException {
        return this.orderEntry(limitOrder, false);
    }

    public PoloniexTradeResponse sell(LimitOrder limitOrder) throws IOException {
        return this.orderEntry(limitOrder, true);
    }

    private PoloniexTradeResponse orderEntry(LimitOrder limitOrder, boolean sell) throws IOException {
        Integer fillOrKill = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.FILL_OR_KILL) ? Integer.valueOf(1) : null;
        Integer immediateOrCancel = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.IMMEDIATE_OR_CANCEL) ? Integer.valueOf(1) : null;
        Integer postOnly = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.POST_ONLY) ? Integer.valueOf(1) : null;
        Double lendingRate = null;
        if (limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.MARGIN)) {
            return sell ? this.poloniexAuthenticated.marginSell(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), lendingRate) : this.poloniexAuthenticated.marginBuy(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), lendingRate);
        }
        return sell ? this.poloniexAuthenticated.sell(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), fillOrKill, immediateOrCancel, postOnly) : this.poloniexAuthenticated.buy(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), fillOrKill, immediateOrCancel, postOnly);
    }

    public PoloniexMoveResponse move(String orderId, BigDecimal originalAmount, BigDecimal limitPrice, PoloniexOrderFlags flag) throws IOException {
        Integer immediateOrCancel = flag == PoloniexOrderFlags.IMMEDIATE_OR_CANCEL ? Integer.valueOf(1) : null;
        Integer postOnly = flag == PoloniexOrderFlags.POST_ONLY ? Integer.valueOf(1) : null;
        return this.poloniexAuthenticated.moveOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId, originalAmount.toPlainString(), limitPrice.toPlainString(), immediateOrCancel, postOnly);
    }

    public PoloniexMoveResponse move(String orderId, BigDecimal originalAmount, BigDecimal limitPrice) throws IOException {
        return this.move(orderId, originalAmount, limitPrice, null);
    }

    public boolean cancel(String orderId) throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.cancelOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        if (response.containsKey("error")) {
            throw new PoloniexException(response.get("error"));
        }
        return response.get("success").equals("1");
    }

    public HashMap<String, String> getFeeInfo() throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.returnFeeInfo(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.containsKey("error")) {
            throw new PoloniexException(response.get("error"));
        }
        return response;
    }
}

