/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.simulated;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.simulated.AccountFactory;
import org.knowm.xchange.simulated.Fill;
import org.knowm.xchange.simulated.MatchingEngine;

public class MatchingEngineFactory {
    private final ConcurrentMap<CurrencyPair, MatchingEngine> engines = new ConcurrentHashMap<CurrencyPair, MatchingEngine>();
    private final AccountFactory accountFactory;

    public MatchingEngineFactory(AccountFactory accountFactory) {
        this.accountFactory = accountFactory;
    }

    MatchingEngine create(CurrencyPair currencyPair, int priceScale, BigDecimal minimumAmount, Consumer<Fill> onFill) {
        return this.engines.computeIfAbsent(currencyPair, pair -> new MatchingEngine(this.accountFactory, (CurrencyPair)pair, priceScale, minimumAmount, onFill));
    }

    MatchingEngine create(CurrencyPair currencyPair, int priceScale, BigDecimal minimumAmount) {
        return this.engines.computeIfAbsent(currencyPair, pair -> new MatchingEngine(this.accountFactory, (CurrencyPair)pair, priceScale, minimumAmount));
    }

    Collection<MatchingEngine> engines() {
        return this.engines.values();
    }
}

