/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.simulated;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Random;
import org.apache.commons.lang3.RandomUtils;
import org.knowm.xchange.exceptions.FrequencyLimitExceededException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.exceptions.SystemOverloadException;
import org.knowm.xchange.simulated.MatchingEngine;
import org.knowm.xchange.simulated.SimulatedExchangeOperationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomExceptionThrower
implements SimulatedExchangeOperationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchingEngine.class);
    private static final String GENERIC_GUIDE = "Application code should handle this gracefully.";
    private static final String RATE_LIMIT_EXCEEDED = "Rate limit exceeded. Are you gracefully backing off when this happens?";
    private final Random random;
    private final RateLimiter rateLimiter;

    public RandomExceptionThrower() {
        this(0x57421DC0AL ^ System.nanoTime());
    }

    public RandomExceptionThrower(long seed) {
        this.random = new Random(seed);
        this.rateLimiter = RateLimiter.create((double)5.2);
        LOGGER.info("Simulated exchange will fire random transient exceptions, with random seed: {}", (Object)seed);
    }

    @Override
    public void onSimulatedExchangeOperation() throws IOException {
        int val = this.random.nextInt(1000);
        if (val == 1) {
            throw new NonceException("Exchanges often complain about nonce issues. Application code should handle this gracefully.");
        }
        if (val == 2) {
            throw new SocketTimeoutException("Socket timeouts connecting to exchanges are commonplace. Application code should handle this gracefully.");
        }
        if (val == 3) {
            throw new SystemOverloadException("System overloads are a common error on some exchanges. Application code should handle this gracefully.");
        }
        if (!this.rateLimiter.tryAcquire()) {
            if (RandomUtils.nextBoolean()) {
                throw new RateLimitExceededException(RATE_LIMIT_EXCEEDED);
            }
            throw new FrequencyLimitExceededException(RATE_LIMIT_EXCEEDED);
        }
    }
}

