/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.yank;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YankPoolManager {
    private final Logger logger = LoggerFactory.getLogger(YankPoolManager.class);
    private final Properties mergedSqlProperties = new Properties();
    protected static final YankPoolManager INSTANCE = new YankPoolManager();
    protected static final String DEFAULT_POOL_NAME = "yank-default";
    private final Map<String, HikariDataSource> pools = new ConcurrentHashMap<String, HikariDataSource>(2);

    private YankPoolManager() {
    }

    protected void addDefaultConnectionPool(Properties dataSourceProperties) {
        this.createPool(DEFAULT_POOL_NAME, dataSourceProperties);
    }

    protected void addConnectionPool(String poolName, Properties connectionPoolProperties) {
        this.createPool(poolName, connectionPoolProperties);
    }

    private void createPool(String poolName, Properties connectionPoolProperties) {
        this.releaseConnectionPool(poolName);
        connectionPoolProperties.put("autoCommit", (Object)true);
        HikariConfig config = new HikariConfig(connectionPoolProperties);
        config.setPoolName(poolName);
        HikariDataSource ds = new HikariDataSource(config);
        this.pools.put(poolName, ds);
        this.logger.info("Initialized pool '{}'", (Object)poolName);
    }

    protected synchronized void releaseDefaultConnectionPool() {
        this.releaseConnectionPool(DEFAULT_POOL_NAME);
    }

    protected synchronized void releaseConnectionPool(String poolName) {
        HikariDataSource pool = this.pools.get(poolName);
        if (pool != null) {
            this.logger.info("Releasing pool: {}...", (Object)pool.getPoolName());
            pool.close();
        }
    }

    protected synchronized void releaseAllConnectionPools() {
        for (HikariDataSource pool : this.pools.values()) {
            if (pool == null) continue;
            this.logger.info("Releasing pool: {}...", (Object)pool.getPoolName());
            pool.close();
        }
    }

    protected HikariDataSource getConnectionPool(String poolName) {
        return this.pools.get(poolName);
    }

    protected HikariDataSource getDefaultConnectionPool() {
        return this.getConnectionPool(DEFAULT_POOL_NAME);
    }

    protected void addSQLStatements(Properties sqlProperties) {
        this.mergedSqlProperties.putAll((Map<?, ?>)sqlProperties);
    }

    protected Properties getMergedSqlProperties() {
        return this.mergedSqlProperties;
    }
}

