/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.yank.processors;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.BeanProcessor;
import org.knowm.yank.annotations.Column;

public class YankBeanProcessor<T>
extends BeanProcessor {
    private final Map<String, String> columnToFieldOverrides;

    public YankBeanProcessor(Class<T> type) {
        this.columnToFieldOverrides = this.getMappingFromAnnotations(type);
    }

    private Map<String, String> getMappingFromAnnotations(Class<T> type) {
        HashMap<String, String> columnToPropertyOverrides = new HashMap<String, String>();
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            columnToPropertyOverrides.put(field.getAnnotation(Column.class).value(), field.getName());
        }
        return columnToPropertyOverrides;
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String overrideName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((overrideName = this.columnToFieldOverrides.get(columnName)) == null) {
                overrideName = columnName;
            }
            String generousColumnName = columnName.replace("_", "");
            for (int i = 0; i < props.length; ++i) {
                String propName = props[i].getName();
                if (!columnName.equalsIgnoreCase(propName) && !generousColumnName.equalsIgnoreCase(propName) && !overrideName.equalsIgnoreCase(propName)) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }
}

