/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.kocakosm.pitaya.charset.Charsets;

public final class ASCII {
    public static boolean canEncode(String str) {
        return Charsets.US_ASCII.newEncoder().canEncode(str);
    }

    public static boolean canEncode(String str, int off, int len) {
        return ASCII.canEncode(str.substring(off, off + len));
    }

    public static boolean canDecode(byte ... input) {
        return ASCII.canDecode(input, 0, input.length);
    }

    public static boolean canDecode(byte[] input, int off, int len) {
        try {
            ASCII.decode(input, off, len);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    public static byte[] encode(String str) {
        CharsetEncoder encoder = Charsets.US_ASCII.newEncoder();
        try {
            ByteBuffer out = encoder.encode(CharBuffer.wrap(str));
            byte[] bytes = new byte[out.limit()];
            out.get(bytes);
            return bytes;
        }
        catch (CharacterCodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static byte[] encode(String str, int off, int len) {
        return ASCII.encode(str.substring(off, off + len));
    }

    public static String decode(byte ... input) {
        return ASCII.decode(input, 0, input.length);
    }

    public static String decode(byte[] input, int off, int len) {
        CharsetDecoder decoder = Charsets.US_ASCII.newDecoder();
        ByteBuffer buf = ByteBuffer.wrap(input, off, len);
        try {
            CharBuffer out = decoder.decode(buf);
            char[] chars = new char[out.limit()];
            out.get(chars);
            return new String(chars);
        }
        catch (CharacterCodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static boolean isPrintable(char c) {
        return c > '\u001f' && c < '\u007f';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLetter(char c) {
        return ASCII.isLowerCase(c) || ASCII.isUpperCase(c);
    }

    public static boolean isAlphabetic(String str) {
        for (char c : str.toCharArray()) {
            if (ASCII.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (ASCII.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (ASCII.isDigit(c) || ASCII.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toLowerCase(char c) {
        return ASCII.isUpperCase(c) ? (char)(c + 32) : c;
    }

    public static char toUpperCase(char c) {
        return ASCII.isLowerCase(c) ? (char)(c - 32) : c;
    }

    public static String toLowerCase(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            sb.append(ASCII.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toUpperCase(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            sb.append(ASCII.toUpperCase(c));
        }
        return sb.toString();
    }

    public static String capitalize(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            sb.append(sb.length() > 0 ? c : ASCII.toUpperCase(c));
        }
        return sb.toString();
    }

    private ASCII() {
    }
}

