/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.kocakosm.pitaya.charset.Charsets;

public final class UTF8 {
    public static boolean canEncode(String str) {
        return Charsets.UTF_8.newEncoder().canEncode(str);
    }

    public static boolean canEncode(String str, int off, int len) {
        return UTF8.canEncode(str.substring(off, off + len));
    }

    public static boolean canDecode(byte ... input) {
        return UTF8.canDecode(input, 0, input.length);
    }

    public static boolean canDecode(byte[] input, int off, int len) {
        try {
            UTF8.decode(input, off, len);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    public static byte[] encode(String str) {
        CharsetEncoder encoder = Charsets.UTF_8.newEncoder();
        try {
            ByteBuffer out = encoder.encode(CharBuffer.wrap(str));
            byte[] bytes = new byte[out.limit()];
            out.get(bytes);
            return bytes;
        }
        catch (CharacterCodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static byte[] encode(String str, int off, int len) {
        return UTF8.encode(str.substring(off, off + len));
    }

    public static String decode(byte ... input) {
        return UTF8.decode(input, 0, input.length);
    }

    public static String decode(byte[] input, int off, int len) {
        CharsetDecoder decoder = Charsets.UTF_8.newDecoder();
        ByteBuffer buf = ByteBuffer.wrap(input, off, len);
        try {
            CharBuffer out = decoder.decode(buf);
            char[] chars = new char[out.limit()];
            out.get(chars);
            return new String(chars);
        }
        catch (CharacterCodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private UTF8() {
    }
}

