/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kocakosm.pitaya.collection.ImmutableList;
import org.kocakosm.pitaya.collection.ImmutableSet;
import org.kocakosm.pitaya.util.Parameters;

public final class ChainMap<K, V>
extends AbstractMap<K, V> {
    private final List<Map<K, V>> maps;

    public ChainMap(Map<K, V> ... maps) {
        Parameters.checkCondition(maps.length > 0);
        this.maps = ImmutableList.copyOf(maps);
        for (Map<K, V> map : this.maps) {
            Parameters.checkNotNull(map);
        }
    }

    public ChainMap(Iterable<? extends Map<K, V>> maps) {
        this.maps = ImmutableList.copyOf(maps);
        for (Map<K, V> map : this.maps) {
            Parameters.checkNotNull(map);
        }
        Parameters.checkCondition(!this.maps.isEmpty());
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        for (Map<K, V> map : this.maps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<K, V> map : this.maps) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> map : this.maps) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map<K, V> map : this.maps) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.maps.get(0).put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = this.get(key);
        for (Map<K, V> map : this.maps) {
            map.remove(key);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.maps.get(0).putAll(m);
    }

    @Override
    public void clear() {
        for (Map<K, V> map : this.maps) {
            map.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        ImmutableSet.Builder<K> keys = new ImmutableSet.Builder<K>();
        for (Map<K, V> map : this.maps) {
            keys.add((Iterable<K>)map.keySet());
        }
        return keys.build();
    }

    @Override
    public Collection<V> values() {
        ImmutableList.Builder<Object> values = new ImmutableList.Builder<Object>();
        for (K key : this.keySet()) {
            values.add(this.get(key));
        }
        return values.build();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ImmutableSet.Builder<Map.Entry> entries = new ImmutableSet.Builder<Map.Entry>();
        for (K key : this.keySet()) {
            entries.add(new AbstractMap.SimpleEntry<K, V>(key, this.get(key)));
        }
        return entries.build();
    }
}

