/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kocakosm.pitaya.collection.AbstractBag;
import org.kocakosm.pitaya.collection.ConcurrentBag;
import org.kocakosm.pitaya.collection.Iterables;
import org.kocakosm.pitaya.util.Parameters;

public final class ConcurrentHashBag<E>
extends AbstractBag<E>
implements ConcurrentBag<E>,
Serializable {
    private static final long serialVersionUID = 7336345430492192446L;
    private final ConcurrentMap<E, CopyOnWriteArrayList<E>> entries;

    public ConcurrentHashBag() {
        this(10);
    }

    public ConcurrentHashBag(int initialCapacity) {
        Parameters.checkCondition(initialCapacity >= 0);
        this.entries = new ConcurrentHashMap<E, CopyOnWriteArrayList<E>>(initialCapacity);
    }

    public ConcurrentHashBag(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    public ConcurrentHashBag(Iterable<? extends E> i) {
        this();
        for (E e : i) {
            this.add(e);
        }
    }

    public ConcurrentHashBag(Iterator<? extends E> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public ConcurrentHashBag(E ... elements) {
        this(Arrays.asList(elements));
    }

    @Override
    public boolean add(E e) {
        return this.getEntry(e).add(e);
    }

    @Override
    public int addAllAbsent(Collection<? extends E> c) {
        int count = 0;
        for (E e : c) {
            if (!this.addIfAbsent(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean addIfAbsent(E e) {
        return this.getEntry(e).addIfAbsent(e);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object o) {
        List entry = (List)this.entries.get(o);
        return entry == null ? false : !entry.isEmpty();
    }

    @Override
    public int count(E e) {
        List entry = (List)this.entries.get(e);
        return entry == null ? 0 : entry.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterables.concat(this.entries.values()).iterator();
    }

    @Override
    public boolean remove(Object o) {
        List entry = (List)this.entries.get(o);
        return entry == null ? false : entry.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.entries.remove(o) != null;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean updated = false;
        for (List entry : this.entries.values()) {
            updated |= entry.retainAll(c);
        }
        return updated;
    }

    @Override
    public int size() {
        int size = 0;
        for (List value : this.entries.values()) {
            size += value.size();
        }
        return size;
    }

    private CopyOnWriteArrayList<E> getEntry(E e) {
        this.entries.putIfAbsent(e, new CopyOnWriteArrayList());
        return (CopyOnWriteArrayList)this.entries.get(e);
    }
}

