/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.kocakosm.pitaya.collection.ArrayBag;
import org.kocakosm.pitaya.collection.Bag;
import org.kocakosm.pitaya.collection.Iterators;
import org.kocakosm.pitaya.util.Parameters;

public final class Iterables {
    public static final Iterable EMPTY_ITERABLE = new EmptyIterable();

    public static <T> Iterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        return new ConcatIterable(iterables);
    }

    public static <T> Iterable<T> cycle(Iterable<? extends T> iterable) {
        return new CyclicIterable<T>(Iterables.toList(iterable));
    }

    public static <T> Iterable<T> cycle(T ... elements) {
        return new CyclicIterable<T>(new ArrayList<T>(Arrays.asList(elements)));
    }

    public static boolean equal(Iterable<?> i1, Iterable<?> i2) {
        if (i1 == i2) {
            return true;
        }
        if (i1 == null || i2 == null) {
            return false;
        }
        return Iterators.equal(i1.iterator(), i2.iterator());
    }

    public static <T> Iterable<T> limit(Iterable<? extends T> iterable, int limit) {
        return new LimitIterable<T>(iterable, limit);
    }

    public static <T> Iterable<T> skip(Iterable<T> iterable, int n) {
        return new SkipIterable<T>(iterable, n);
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T e : iterable) {
            list.add(e);
        }
        return list;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> iterable) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T e : iterable) {
            set.add(e);
        }
        return set;
    }

    public static <T> Bag<T> toBag(Iterable<? extends T> iterable) {
        return new ArrayBag<T>(iterable);
    }

    public static String toString(Iterable<?> iterable) {
        return Iterables.toList(iterable).toString();
    }

    private Iterables() {
    }

    private static final class SkipIterable<T>
    implements Iterable<T> {
        private final int n;
        private final Iterable<T> iterable;

        SkipIterable(Iterable<T> iterable, int n) {
            Parameters.checkNotNull(iterable);
            Parameters.checkCondition(n >= 0);
            this.iterable = iterable;
            this.n = n;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<T> iterator = this.iterable.iterator();
            Iterators.skip(iterator, this.n);
            return iterator;
        }
    }

    private static final class LimitIterable<T>
    implements Iterable<T> {
        private final int limit;
        private final Iterable<? extends T> iterable;

        LimitIterable(Iterable<? extends T> iterable, int limit) {
            Parameters.checkNotNull(iterable);
            Parameters.checkCondition(limit >= 0);
            this.iterable = iterable;
            this.limit = limit;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.limit(this.iterable.iterator(), this.limit);
        }
    }

    private static final class CyclicIterable<T>
    implements Iterable<T> {
        private final Iterable<? extends T> iterable;

        CyclicIterable(Iterable<? extends T> iterable) {
            Parameters.checkNotNull(iterable);
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.cycle(this.iterable.iterator());
        }
    }

    private static final class ConcatIterable<T>
    implements Iterable<T> {
        private final List<Iterable<? extends T>> iterables = new ArrayList<Iterable<? extends T>>();

        ConcatIterable(Iterable<? extends Iterable<? extends T>> iterables) {
            for (Iterable<T> iterable : iterables) {
                Parameters.checkNotNull(iterable);
                this.iterables.add(iterable);
            }
        }

        @Override
        public Iterator<T> iterator() {
            ArrayList<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>();
            for (Iterable<T> iterable : this.iterables) {
                iterators.add(iterable.iterator());
            }
            return Iterators.concat(iterators.iterator());
        }
    }

    private static final class EmptyIterable<T>
    implements Iterable<T> {
        private EmptyIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.emptyIterator();
        }
    }
}

