/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.kocakosm.pitaya.collection.ArrayBag;
import org.kocakosm.pitaya.collection.Bag;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

public final class Iterators {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <E> Iterator<E> concat(Iterator<? extends E> ... iterators) {
        return Iterators.concat(Arrays.asList(iterators).iterator());
    }

    public static <E> Iterator<E> concat(Iterator<? extends Iterator<? extends E>> iterators) {
        return new ConcatIterator(iterators);
    }

    public static <E> Iterator<E> cycle(Iterator<? extends E> iterator) {
        return new LazyCyclicIterator<E>(iterator);
    }

    public static <E> Iterator<E> cycle(E ... elements) {
        return new CyclicIterator<E>(Arrays.asList(elements));
    }

    public static boolean equal(Iterator<?> i1, Iterator<?> i2) {
        if (i1 == i2) {
            return true;
        }
        if (i1 == null || i2 == null) {
            return false;
        }
        while (i1.hasNext() && i2.hasNext()) {
            if (XObjects.equal(i1.next(), i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static <E> Iterator<E> limit(Iterator<? extends E> iterator, int limit) {
        return new LimitIterator<E>(iterator, limit);
    }

    public static int skip(Iterator<?> iterator, int n) {
        int skipped;
        Parameters.checkCondition(n >= 0);
        for (skipped = 0; skipped < n && iterator.hasNext(); ++skipped) {
            iterator.next();
        }
        return skipped;
    }

    public static <E> List<E> toList(Iterator<? extends E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> Set<E> toSet(Iterator<? extends E> iterator) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> Bag<E> toBag(Iterator<? extends E> iterator) {
        return new ArrayBag<E>(iterator);
    }

    public static String toString(Iterator<?> iterator) {
        return Iterators.toList(iterator).toString();
    }

    private Iterators() {
    }

    private static final class LimitIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iterator;
        private final int limit;
        private int index;

        LimitIterator(Iterator<? extends E> iterator, int limit) {
            Parameters.checkNotNull(iterator);
            Parameters.checkCondition(limit >= 0);
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() && this.index < this.limit;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                ++this.index;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static final class CyclicIterator<E>
    implements Iterator<E> {
        private final List<E> elements;
        private int index = -1;

        CyclicIterator(List<? extends E> elements) {
            this.elements = new ArrayList<E>(elements);
        }

        @Override
        public boolean hasNext() {
            return !this.elements.isEmpty();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.elements.get(this.nextIndex());
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index < 0) {
                throw new IllegalStateException();
            }
            this.elements.remove(this.index--);
        }

        private int nextIndex() {
            if (++this.index >= this.elements.size()) {
                this.index = 0;
            }
            return this.index;
        }
    }

    private static final class LazyCyclicIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iterator;
        private final List<E> elements;
        private int index = -1;

        LazyCyclicIterator(Iterator<? extends E> iterator) {
            Parameters.checkNotNull(iterator);
            this.elements = new ArrayList();
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || !this.elements.isEmpty();
        }

        @Override
        public E next() {
            if (this.iterator.hasNext()) {
                E element = this.iterator.next();
                this.elements.add(element);
                ++this.index;
                return element;
            }
            if (!this.elements.isEmpty()) {
                if (++this.index >= this.elements.size()) {
                    this.index = 0;
                }
                return this.elements.get(this.index);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index < 0) {
                throw new IllegalStateException();
            }
            this.elements.remove(this.index--);
        }
    }

    private static final class ConcatIterator<E>
    implements Iterator<E> {
        private final List<Iterator<? extends E>> iterators = new ArrayList<Iterator<? extends E>>();
        private int index;

        ConcatIterator(Iterator<? extends Iterator<? extends E>> iterators) {
            while (iterators.hasNext()) {
                Iterator<E> iterator = iterators.next();
                if (!iterator.hasNext()) continue;
                this.iterators.add(iterator);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.finished() && this.current().hasNext() || this.nextIterator() && this.hasNext();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.current().next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.current().remove();
        }

        private Iterator<? extends E> current() {
            return this.iterators.get(this.index);
        }

        private boolean finished() {
            return this.index >= this.iterators.size();
        }

        private boolean nextIterator() {
            ++this.index;
            return !this.finished();
        }
    }

    private static final class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

