/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kocakosm.pitaya.io.ConcatInputStream;
import org.kocakosm.pitaya.io.LimitInputStream;
import org.kocakosm.pitaya.io.TeeOutputStream;

public final class ByteStreams {
    public static InputStream concat(InputStream ... streams) {
        return new ConcatInputStream(streams);
    }

    public static InputStream concat(Iterable<? extends InputStream> streams) {
        return new ConcatInputStream(streams);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int len = in.read(buf);
        while (len >= 0) {
            out.write(buf, 0, len);
            len = in.read(buf);
        }
        out.flush();
    }

    public static boolean equal(InputStream in1, InputStream in2) throws IOException {
        if (in1 == in2) {
            return true;
        }
        if (in1 == null || in2 == null) {
            return false;
        }
        in1 = ByteStreams.buffer(in1);
        in2 = ByteStreams.buffer(in2);
        int b1 = in1.read();
        int b2 = in2.read();
        while (b1 != -1 && b2 != -1 && b1 == b2) {
            b1 = in1.read();
            b2 = in2.read();
        }
        return in1.read() == -1 && in2.read() == -1;
    }

    private static InputStream buffer(InputStream in) {
        if (in instanceof BufferedInputStream) {
            return in;
        }
        return new BufferedInputStream(in);
    }

    public static InputStream limit(InputStream in, long limit) {
        return new LimitInputStream(in, limit);
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreams.copy(in, out);
        return out.toByteArray();
    }

    public static OutputStream tee(OutputStream ... streams) {
        return new TeeOutputStream(streams);
    }

    public static OutputStream tee(Iterable<? extends OutputStream> streams) {
        return new TeeOutputStream(streams);
    }

    private ByteStreams() {
    }
}

