/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kocakosm.pitaya.charset.Charsets;
import org.kocakosm.pitaya.io.ConcatReader;
import org.kocakosm.pitaya.io.LimitReader;
import org.kocakosm.pitaya.io.TeeWriter;

public final class CharStreams {
    public static Reader concat(Reader ... streams) {
        return new ConcatReader(streams);
    }

    public static Reader concat(Iterable<? extends Reader> streams) {
        return new ConcatReader(streams);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        char[] buf = new char[4096];
        int len = in.read(buf);
        while (len >= 0) {
            out.write(buf, 0, len);
            len = in.read(buf);
        }
        out.flush();
    }

    public static void copy(InputStream in, Writer out) throws IOException {
        CharStreams.copy((Reader)new InputStreamReader(in, Charsets.DEFAULT), out);
    }

    public static void copy(InputStream in, Writer out, Charset charset) throws IOException {
        CharStreams.copy((Reader)new InputStreamReader(in, charset), out);
    }

    public static void copy(Reader in, OutputStream out) throws IOException {
        CharStreams.copy(in, (Writer)new OutputStreamWriter(out, Charsets.DEFAULT));
    }

    public static void copy(Reader in, OutputStream out, Charset charset) throws IOException {
        CharStreams.copy(in, (Writer)new OutputStreamWriter(out, charset));
    }

    public static boolean equal(Reader in1, Reader in2) throws IOException {
        if (in1 == in2) {
            return true;
        }
        if (in1 == null || in2 == null) {
            return false;
        }
        in1 = CharStreams.buffer(in1);
        in2 = CharStreams.buffer(in2);
        int c1 = in1.read();
        int c2 = in2.read();
        while (c1 != -1 && c2 != -1 && c1 == c2) {
            c1 = in1.read();
            c2 = in2.read();
        }
        return in1.read() == -1 && in2.read() == -1;
    }

    private static BufferedReader buffer(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    public static Reader limit(Reader in, long limit) {
        return new LimitReader(in, limit);
    }

    public static String read(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        CharStreams.copy(in, (Writer)out);
        return ((Object)out).toString();
    }

    public static String read(InputStream in) throws IOException {
        return CharStreams.read(new InputStreamReader(in, Charsets.DEFAULT));
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        return CharStreams.read(new InputStreamReader(in, charset));
    }

    public static List<String> readLines(Reader in) throws IOException {
        BufferedReader reader = CharStreams.buffer(in);
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return Collections.unmodifiableList(lines);
    }

    public static List<String> readLines(InputStream in) throws IOException {
        return CharStreams.readLines(in, Charsets.DEFAULT);
    }

    public static List<String> readLines(InputStream in, Charset charset) throws IOException {
        return CharStreams.readLines(new InputStreamReader(in, charset));
    }

    public static Writer tee(Writer ... streams) {
        return new TeeWriter(streams);
    }

    public static Writer tee(Iterable<? extends Writer> streams) {
        return new TeeWriter(streams);
    }

    private CharStreams() {
    }
}

