/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;

final class ConcatInputStream
extends InputStream {
    private int index;
    private final List<InputStream> streams = new ArrayList<InputStream>();

    ConcatInputStream(InputStream ... streams) {
        this(Arrays.asList(streams));
    }

    ConcatInputStream(Iterable<? extends InputStream> streams) {
        for (InputStream inputStream : streams) {
            this.streams.add(Parameters.checkNotNull(inputStream));
        }
        Parameters.checkCondition(!this.streams.isEmpty());
    }

    @Override
    public int available() throws IOException {
        return this.finished() ? 0 : this.current().available();
    }

    @Override
    public void close() {
        for (InputStream stream : this.streams) {
            IO.close(stream);
        }
    }

    @Override
    public int read() throws IOException {
        int b;
        int n = b = this.finished() ? -1 : this.current().read();
        return b != -1 ? b : (this.next() ? this.read() : -1);
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n;
        int n2 = n = this.finished() ? -1 : this.current().read(b);
        return n != -1 ? n : (this.next() ? this.read(b) : -1);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        int n2 = n = this.finished() ? -1 : this.current().read(b, off, len);
        return n != -1 ? n : (this.next() ? this.read(b, off, len) : -1);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.finished() ? 0L : this.current().skip(n);
    }

    private InputStream current() {
        return this.streams.get(this.index);
    }

    private boolean finished() {
        return this.index >= this.streams.size();
    }

    private boolean next() {
        ++this.index;
        return !this.finished();
    }
}

