/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;

final class ConcatReader
extends Reader {
    private int index;
    private final List<Reader> readers = new ArrayList<Reader>();

    ConcatReader(Reader ... readers) {
        this(Arrays.asList(readers));
    }

    ConcatReader(Iterable<? extends Reader> readers) {
        for (Reader reader : readers) {
            this.readers.add(Parameters.checkNotNull(reader));
        }
        Parameters.checkCondition(!this.readers.isEmpty());
    }

    @Override
    public boolean ready() throws IOException {
        return this.current().ready();
    }

    @Override
    public int read() throws IOException {
        int b;
        int n = b = this.finished() ? -1 : this.current().read();
        return b != -1 ? b : (this.next() ? this.read() : -1);
    }

    @Override
    public int read(char[] buf) throws IOException {
        int n;
        int n2 = n = this.finished() ? -1 : this.current().read(buf);
        return n != -1 ? n : (this.next() ? this.read(buf) : -1);
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        int n;
        int n2 = n = this.finished() ? -1 : this.current().read(buf, off, len);
        return n != -1 ? n : (this.next() ? this.read(buf, off, len) : -1);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) throws IOException {
        Parameters.checkCondition(readLimit >= 0);
        throw new IOException("Mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        Parameters.checkCondition(n >= 0L);
        return this.finished() ? 0L : (long)this.current().read(new char[(int)n]);
    }

    @Override
    public void close() {
        for (Reader reader : this.readers) {
            IO.close(reader);
        }
    }

    private Reader current() {
        return this.readers.get(this.index);
    }

    private boolean finished() {
        return this.index >= this.readers.size();
    }

    private boolean next() {
        ++this.index;
        return !this.finished();
    }
}

