/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.InputStream;
import org.kocakosm.pitaya.util.Parameters;

final class LimitInputStream
extends InputStream {
    private final InputStream in;
    private final long limit;
    private final Object lock;
    private long position;
    private long mark;
    private long markLimit;

    LimitInputStream(InputStream in, long limit) {
        Parameters.checkNotNull(in);
        Parameters.checkCondition(limit >= 0L);
        this.in = in;
        this.limit = limit;
        this.lock = new Object();
        this.position = 0L;
        this.mark = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.position >= this.limit) {
                return 0;
            }
            return this.in.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) {
        Object object = this.lock;
        synchronized (object) {
            this.in.mark(readLimit);
            this.mark = this.position;
            this.markLimit = this.position + (long)readLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        Object object = this.lock;
        synchronized (object) {
            return this.in.markSupported();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.position >= this.limit) {
                return -1;
            }
            int b = this.in.read();
            this.shiftPosition(b != -1 ? 1L : -1L);
            return b;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.position >= this.limit) {
                return -1;
            }
            int max = (int)Math.min((long)len, this.limit - this.position);
            int n = this.in.read(b, off, max);
            this.shiftPosition(n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mark == -1L || this.mark > -1L && this.position > this.markLimit) {
                throw new IOException("Missing mark");
            }
            this.in.reset();
            this.position = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long skipped = this.in.skip(Math.min(n, this.limit - this.position));
            this.shiftPosition(skipped);
            return skipped;
        }
    }

    private void shiftPosition(long n) {
        if (n != -1L) {
            this.position += n;
        }
    }
}

