/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.Reader;
import org.kocakosm.pitaya.util.Parameters;

final class LimitReader
extends Reader {
    private final Reader reader;
    private final long limit;
    private final Object innerLock;
    private long position;
    private long mark;
    private long markLimit;

    LimitReader(Reader reader, long limit) {
        Parameters.checkNotNull(reader);
        Parameters.checkCondition(limit >= 0L);
        this.reader = reader;
        this.limit = limit;
        this.innerLock = new Object();
        this.position = 0L;
        this.mark = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            return this.reader.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            if (this.position >= this.limit) {
                return -1;
            }
            int c = this.reader.read();
            this.shiftPosition(c != -1 ? 1L : -1L);
            return c;
        }
    }

    @Override
    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            if (this.position >= this.limit) {
                return -1;
            }
            int max = (int)Math.min((long)len, this.limit - this.position);
            int n = this.reader.read(buf, off, max);
            this.shiftPosition(n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        Object object = this.innerLock;
        synchronized (object) {
            return this.reader.markSupported();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            this.reader.mark(readLimit);
            this.mark = this.position;
            this.markLimit = this.position + (long)readLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            if (this.mark == -1L || this.mark > -1L && this.position > this.markLimit) {
                throw new IOException("Missing mark");
            }
            this.reader.reset();
            this.position = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            long skipped = this.reader.skip(Math.min(n, this.limit - this.position));
            this.shiftPosition(skipped);
            return skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.innerLock;
        synchronized (object) {
            this.reader.close();
        }
    }

    private void shiftPosition(long n) {
        if (n != -1L) {
            this.position += n;
        }
    }
}

