/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.kocakosm.pitaya.io.ByteStreams;
import org.kocakosm.pitaya.io.CharStreams;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

public final class Resource {
    private final URL url;

    public static Resource find(String name) {
        Parameters.checkNotNull(name);
        ClassLoader loader = XObjects.firstNonNull(Thread.currentThread().getContextClassLoader(), Resource.class.getClassLoader());
        URL url = loader.getResource(name);
        if (url != null) {
            return new Resource(url);
        }
        throw new NotFoundException(name);
    }

    public static Resource find(String name, Class<?> contextClass) {
        Parameters.checkNotNull(name);
        URL url = contextClass.getResource(name);
        if (url != null) {
            return new Resource(url);
        }
        throw new NotFoundException(name);
    }

    private Resource(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream out) throws IOException {
        InputStream in = this.url.openStream();
        try {
            ByteStreams.copy(in, out);
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Writer out, Charset charset) throws IOException {
        InputStream in = this.url.openStream();
        try {
            CharStreams.copy(in, out, charset);
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() throws IOException {
        InputStream in = this.url.openStream();
        try {
            byte[] byArray = ByteStreams.read(in);
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(Charset charset) throws IOException {
        InputStream in = this.url.openStream();
        try {
            String string = CharStreams.read(in, charset);
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readLines(Charset charset) throws IOException {
        InputStream in = this.url.openStream();
        try {
            List<String> list = CharStreams.readLines(in, charset);
            return list;
        }
        finally {
            IO.close(in);
        }
    }

    public String toString() {
        return this.url.toString();
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource r = (Resource)o;
        return this.url.equals(r.url);
    }

    public static final class NotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 75062119139042997L;

        NotFoundException(String message) {
            super(message);
        }
    }
}

