/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.kocakosm.pitaya.charset.Charsets;
import org.kocakosm.pitaya.util.Booleans;

public final class Scanf {
    public static String readString() throws IOException {
        return Scanf.readString(Charsets.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Charset charset) throws IOException {
        InputStreamReader in = new InputStreamReader(System.in, charset);
        BufferedReader reader = new BufferedReader(in);
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static boolean readBoolean() throws IOException {
        return Booleans.valueOf(Scanf.readString());
    }

    public static int readInt() throws IOException {
        return Integer.valueOf(Scanf.readString());
    }

    public static int readInt(int radix) throws IOException {
        return Integer.valueOf(Scanf.readString(), radix);
    }

    public static long readLong() throws IOException {
        return Long.valueOf(Scanf.readString());
    }

    public static long readLong(int radix) throws IOException {
        return Long.valueOf(Scanf.readString(), radix);
    }

    public static BigInteger readBigInteger() throws IOException {
        return new BigInteger(Scanf.readString());
    }

    public static BigInteger readBigInteger(int radix) throws IOException {
        return new BigInteger(Scanf.readString(), radix);
    }

    public static double readDouble() throws IOException {
        return Double.valueOf(Scanf.readString());
    }

    public static BigDecimal readBigDecimal() throws IOException {
        return new BigDecimal(Scanf.readString());
    }

    private Scanf() {
    }
}

