/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.security.Digests;
import org.kocakosm.pitaya.security.HMAC;
import org.kocakosm.pitaya.security.MAC;
import org.kocakosm.pitaya.util.Parameters;

final class Factory {
    static Digest newDigest(Algorithm<Digest> algorithm) {
        Digest digest;
        Parameters.checkNotNull(algorithm);
        if (algorithm == Algorithm.MD2) {
            digest = Digests.md2();
        } else if (algorithm == Algorithm.MD4) {
            digest = Digests.md4();
        } else if (algorithm == Algorithm.MD5) {
            digest = Digests.md5();
        } else if (algorithm == Algorithm.SHA1) {
            digest = Digests.sha1();
        } else if (algorithm == Algorithm.SHA256) {
            digest = Digests.sha256();
        } else if (algorithm == Algorithm.SHA512) {
            digest = Digests.sha512();
        } else if (algorithm == Algorithm.KECCAK224) {
            digest = Digests.keccak224();
        } else if (algorithm == Algorithm.KECCAK256) {
            digest = Digests.keccak256();
        } else if (algorithm == Algorithm.KECCAK384) {
            digest = Digests.keccak384();
        } else if (algorithm == Algorithm.KECCAK512) {
            digest = Digests.keccak512();
        } else {
            throw new IllegalArgumentException("Unknown algorithm");
        }
        return digest;
    }

    static MAC newMAC(Algorithm<MAC> algorithm, byte[] key) {
        MAC mac;
        Parameters.checkNotNull(algorithm);
        if (algorithm == Algorithm.HMAC_MD2) {
            mac = HMAC.md2(key);
        } else if (algorithm == Algorithm.HMAC_MD4) {
            mac = HMAC.md4(key);
        } else if (algorithm == Algorithm.HMAC_MD5) {
            mac = HMAC.md5(key);
        } else if (algorithm == Algorithm.HMAC_SHA1) {
            mac = HMAC.sha1(key);
        } else if (algorithm == Algorithm.HMAC_SHA256) {
            mac = HMAC.sha256(key);
        } else if (algorithm == Algorithm.HMAC_SHA512) {
            mac = HMAC.sha512(key);
        } else if (algorithm == Algorithm.HMAC_KECCAK224) {
            mac = HMAC.keccak224(key);
        } else if (algorithm == Algorithm.HMAC_KECCAK256) {
            mac = HMAC.keccak256(key);
        } else if (algorithm == Algorithm.HMAC_KECCAK384) {
            mac = HMAC.keccak384(key);
        } else if (algorithm == Algorithm.HMAC_KECCAK512) {
            mac = HMAC.keccak512(key);
        } else {
            throw new IllegalArgumentException("Unknown algorithm");
        }
        return mac;
    }

    private Factory() {
    }
}

