/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.util.Arrays;
import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.security.KDFs;
import org.kocakosm.pitaya.util.ByteBuffer;
import org.kocakosm.pitaya.util.LittleEndian;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

final class SCrypt
implements KDF {
    private final int r;
    private final int n;
    private final int p;
    private final int dkLen;

    SCrypt(int r, int n, int p, int dkLen) {
        Parameters.checkCondition(r > 0 && p > 0 && dkLen > 0);
        Parameters.checkCondition(n > 1 && (n & n - 1) == 0);
        Parameters.checkCondition(r == 1 ? n < 65536 : true);
        Parameters.checkCondition((long)p * (long)r < 0x40000000L);
        this.r = r;
        this.n = n;
        this.p = p;
        this.dkLen = dkLen;
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] salt) {
        KDF pbkdf2 = KDFs.pbkdf2(Algorithm.HMAC_SHA256, 1, this.p * 128 * this.r);
        byte[] b = pbkdf2.deriveKey(secret, salt);
        ByteBuffer buffer = new ByteBuffer(this.p * 128 * this.r);
        for (int i = 0; i < this.p; ++i) {
            buffer.append(this.roMix(this.slice(b, i * 128 * this.r, 128 * this.r)));
        }
        pbkdf2 = KDFs.pbkdf2(Algorithm.HMAC_SHA256, 1, this.dkLen);
        return pbkdf2.deriveKey(secret, buffer.toByteArray());
    }

    public String toString() {
        return XObjects.toStringBuilder("SCrypt").append("r", this.r).append("n", this.n).append("p", this.p).append("dkLen", this.dkLen).toString();
    }

    private byte[] roMix(byte[] x) {
        int len = x.length;
        ByteBuffer v = new ByteBuffer(this.n * len);
        for (int i = 0; i < this.n; ++i) {
            v.append(x);
            x = this.blockMix(x);
        }
        int offset = (2 * this.r - 1) * 64;
        for (int i = 0; i < this.n; ++i) {
            int j = LittleEndian.decodeInt(x, offset) & this.n - 1;
            x = this.blockMix(this.xor(x, v.toByteArray(j * len, len)));
        }
        return x;
    }

    private byte[] blockMix(byte[] in) {
        int i;
        byte[] x = this.slice(in, (2 * this.r - 1) * 64, 64);
        ByteBuffer buffer = new ByteBuffer(128 * this.r);
        for (int i2 = 0; i2 < 2 * this.r; ++i2) {
            x = this.salsa20(this.xor(x, this.slice(in, i2 * 64, 64)), 8);
            buffer.append(x);
        }
        byte[] y = buffer.toByteArray();
        byte[] b = new byte[in.length];
        for (i = 0; i < this.r; ++i) {
            System.arraycopy(y, i * 2 * 64, b, i * 64, 64);
        }
        for (i = 0; i < this.r; ++i) {
            System.arraycopy(y, (i * 2 + 1) * 64, b, (i + this.r) * 64, 64);
        }
        return b;
    }

    private byte[] salsa20(byte[] buf, int rounds) {
        int[] in = new int[16];
        for (int i = 0; i < 16; ++i) {
            in[i] = LittleEndian.decodeInt(buf, i * 4);
        }
        int[] x = Arrays.copyOf(in, in.length);
        for (int i = rounds; i > 0; i -= 2) {
            x[4] = x[4] ^ Integer.rotateLeft(x[0] + x[12], 7);
            x[8] = x[8] ^ Integer.rotateLeft(x[4] + x[0], 9);
            x[12] = x[12] ^ Integer.rotateLeft(x[8] + x[4], 13);
            x[0] = x[0] ^ Integer.rotateLeft(x[12] + x[8], 18);
            x[9] = x[9] ^ Integer.rotateLeft(x[5] + x[1], 7);
            x[13] = x[13] ^ Integer.rotateLeft(x[9] + x[5], 9);
            x[1] = x[1] ^ Integer.rotateLeft(x[13] + x[9], 13);
            x[5] = x[5] ^ Integer.rotateLeft(x[1] + x[13], 18);
            x[14] = x[14] ^ Integer.rotateLeft(x[10] + x[6], 7);
            x[2] = x[2] ^ Integer.rotateLeft(x[14] + x[10], 9);
            x[6] = x[6] ^ Integer.rotateLeft(x[2] + x[14], 13);
            x[10] = x[10] ^ Integer.rotateLeft(x[6] + x[2], 18);
            x[3] = x[3] ^ Integer.rotateLeft(x[15] + x[11], 7);
            x[7] = x[7] ^ Integer.rotateLeft(x[3] + x[15], 9);
            x[11] = x[11] ^ Integer.rotateLeft(x[7] + x[3], 13);
            x[15] = x[15] ^ Integer.rotateLeft(x[11] + x[7], 18);
            x[1] = x[1] ^ Integer.rotateLeft(x[0] + x[3], 7);
            x[2] = x[2] ^ Integer.rotateLeft(x[1] + x[0], 9);
            x[3] = x[3] ^ Integer.rotateLeft(x[2] + x[1], 13);
            x[0] = x[0] ^ Integer.rotateLeft(x[3] + x[2], 18);
            x[6] = x[6] ^ Integer.rotateLeft(x[5] + x[4], 7);
            x[7] = x[7] ^ Integer.rotateLeft(x[6] + x[5], 9);
            x[4] = x[4] ^ Integer.rotateLeft(x[7] + x[6], 13);
            x[5] = x[5] ^ Integer.rotateLeft(x[4] + x[7], 18);
            x[11] = x[11] ^ Integer.rotateLeft(x[10] + x[9], 7);
            x[8] = x[8] ^ Integer.rotateLeft(x[11] + x[10], 9);
            x[9] = x[9] ^ Integer.rotateLeft(x[8] + x[11], 13);
            x[10] = x[10] ^ Integer.rotateLeft(x[9] + x[8], 18);
            x[12] = x[12] ^ Integer.rotateLeft(x[15] + x[14], 7);
            x[13] = x[13] ^ Integer.rotateLeft(x[12] + x[15], 9);
            x[14] = x[14] ^ Integer.rotateLeft(x[13] + x[12], 13);
            x[15] = x[15] ^ Integer.rotateLeft(x[14] + x[13], 18);
        }
        byte[] out = new byte[64];
        for (int i = 0; i < 16; ++i) {
            LittleEndian.encode(x[i] + in[i], out, i * 4);
        }
        return out;
    }

    private byte[] slice(byte[] src, int off, int len) {
        byte[] slice = new byte[len];
        System.arraycopy(src, off, slice, 0, len);
        return slice;
    }

    private byte[] xor(byte[] x, byte[] y) {
        int len = x.length;
        byte[] z = new byte[len];
        for (int k = 0; k < len; ++k) {
            z[k] = (byte)(x[k] ^ y[k]);
        }
        return z;
    }
}

