/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import org.kocakosm.pitaya.util.Alphabet;
import org.kocakosm.pitaya.util.ByteBuffer;
import org.kocakosm.pitaya.util.Parameters;

public final class BaseEncoding {
    public static final BaseEncoding BASE_64 = new BaseEncoding(Alphabet.BASE_64);
    public static final BaseEncoding BASE_64_URL = new BaseEncoding(Alphabet.BASE_64_URL);
    public static final BaseEncoding BASE_32 = new BaseEncoding(Alphabet.BASE_32);
    public static final BaseEncoding BASE_32_HEX = new BaseEncoding(Alphabet.BASE_32_HEX);
    public static final BaseEncoding BASE_16 = new BaseEncoding(Alphabet.BASE_16);
    private static final char PADDING_CHAR = '=';
    private final int n;
    private final String separator;
    private final Alphabet alphabet;
    private final boolean omitPadding;
    private final boolean ignoreUnknownChars;

    private BaseEncoding(Alphabet alphabet) {
        this(alphabet, "", -1, !alphabet.requiresPadding(), false);
    }

    private BaseEncoding(Alphabet alphabet, String separator, int n, boolean omitPadding, boolean ignoreUnknownChars) {
        this.alphabet = alphabet;
        this.omitPadding = omitPadding;
        this.ignoreUnknownChars = ignoreUnknownChars;
        this.separator = separator;
        this.n = n;
    }

    public BaseEncoding withSeparator(String separator, int n) {
        Parameters.checkCondition(n > 0);
        for (char c : separator.toCharArray()) {
            if (!this.isPaddingChar(c) && !this.isInAlphabet(c)) continue;
            throw new IllegalArgumentException("Invalid separator character: '" + c + "'");
        }
        return new BaseEncoding(this.alphabet, separator, n, this.omitPadding, this.ignoreUnknownChars);
    }

    public BaseEncoding withoutPadding() {
        return new BaseEncoding(this.alphabet, this.separator, this.n, true, this.ignoreUnknownChars);
    }

    public BaseEncoding ignoreUnknownCharacters() {
        return new BaseEncoding(this.alphabet, this.separator, this.n, this.omitPadding, true);
    }

    public String encode(byte ... in) {
        return this.encode(in, 0, in.length);
    }

    public String encode(byte[] in, int off, int len) {
        this.checkBounds(in, off, len);
        StringBuilder sb = new StringBuilder(this.maxEncodedLength(len));
        int accu = 0;
        int count = 0;
        int b = this.alphabet.bitsPerChar();
        for (int i = off; i < off + len; ++i) {
            accu = accu << 8 | in[i] & 0xFF;
            count += 8;
            while (count >= b) {
                sb.append(this.alphabet.encode(accu >>> (count -= b)));
            }
        }
        if (count > 0) {
            accu = (accu & 255 >>> 8 - count) << b - count;
            sb.append(this.alphabet.encode(accu));
            if (!this.omitPadding) {
                int c = this.alphabet.charsPerBlock();
                int pad = c - sb.length() % c;
                for (int i = 0; i < pad; ++i) {
                    sb.append('=');
                }
            }
        }
        this.insertSeparators(sb);
        return sb.toString();
    }

    private void checkBounds(byte[] in, int off, int len) {
        if (off < 0 || len < 0 || off + len > in.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    private int maxEncodedLength(int l) {
        return this.alphabet.charsPerBlock() * (l / this.alphabet.bytesPerBlock() + 1) + this.alphabet.maxPaddingLength() + (this.n > 0 ? l / this.n * this.separator.length() : 0);
    }

    private void insertSeparators(StringBuilder sb) {
        if (this.n > 0) {
            int step = this.n + this.separator.length();
            for (int i = this.n; i < sb.length(); i += step) {
                sb.insert(i, this.separator);
            }
        }
    }

    public byte[] decode(String in) {
        char c;
        String encoded = this.n > 0 ? in.replace(this.separator, "") : in;
        ByteBuffer buf = new ByteBuffer(this.maxDecodedLength(encoded.length()));
        int accu = 0;
        int count = 0;
        int decoded = 0;
        for (int i = 0; i < encoded.length() && (!this.isPaddingChar(c = encoded.charAt(i)) || this.omitPadding); ++i) {
            int v = this.decode(c);
            if (v == -1) continue;
            ++decoded;
            accu = accu << this.alphabet.bitsPerChar() | v;
            count += this.alphabet.bitsPerChar();
            while (count >= 8) {
                buf.append((byte)(accu >>> (count -= 8)));
            }
        }
        if (!this.omitPadding || !this.alphabet.requiresPadding()) {
            int blockSize;
            Parameters.checkCondition((decoded += this.getPaddingLength(encoded)) % (blockSize = this.alphabet.charsPerBlock()) == 0);
        }
        return buf.toByteArray();
    }

    private int maxDecodedLength(int l) {
        return this.alphabet.bytesPerBlock() * (l / this.alphabet.charsPerBlock() + 1);
    }

    private boolean isPaddingChar(char c) {
        return c == '=' && this.alphabet.requiresPadding();
    }

    private boolean isInAlphabet(char c) {
        return this.alphabet.decode(c) != -1;
    }

    private int decode(char c) {
        int decoded = this.alphabet.decode(c);
        if (decoded == -1 && !this.ignoreUnknownChars) {
            throw new IllegalArgumentException("Unknown character: '" + c + "'");
        }
        return decoded;
    }

    private int getPaddingLength(String in) {
        int i = in.indexOf(61);
        if (i < 0) {
            return 0;
        }
        int count = 1;
        while (++i < in.length()) {
            char c = in.charAt(i);
            if (c == '=') {
                ++count;
                continue;
            }
            if (!this.isInAlphabet(c) && this.ignoreUnknownChars) continue;
            throw new IllegalArgumentException("Invalid padding character: '" + c + "'");
        }
        return count;
    }

    public byte[] decode(String in, int off, int len) {
        return this.decode(in.substring(off, off + len));
    }
}

