/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

public final class BigEndian {
    public static byte[] encode(int n) {
        byte[] out = new byte[4];
        BigEndian.encode(n, out, 0);
        return out;
    }

    public static void encode(int n, byte[] out, int off) {
        out[off] = (byte)(n >>> 24 & 0xFF);
        out[off + 1] = (byte)(n >>> 16 & 0xFF);
        out[off + 2] = (byte)(n >>> 8 & 0xFF);
        out[off + 3] = (byte)(n & 0xFF);
    }

    public static byte[] encode(long n) {
        byte[] out = new byte[8];
        BigEndian.encode(n, out, 0);
        return out;
    }

    public static void encode(long n, byte[] out, int off) {
        out[off] = (byte)(n >>> 56 & 0xFFL);
        out[off + 1] = (byte)(n >>> 48 & 0xFFL);
        out[off + 2] = (byte)(n >>> 40 & 0xFFL);
        out[off + 3] = (byte)(n >>> 32 & 0xFFL);
        out[off + 4] = (byte)(n >>> 24 & 0xFFL);
        out[off + 5] = (byte)(n >>> 16 & 0xFFL);
        out[off + 6] = (byte)(n >>> 8 & 0xFFL);
        out[off + 7] = (byte)(n & 0xFFL);
    }

    public static int decodeInt(byte[] in) {
        return BigEndian.decodeInt(in, 0);
    }

    public static int decodeInt(byte[] in, int off) {
        return (in[off] & 0xFF) << 24 | (in[off + 1] & 0xFF) << 16 | (in[off + 2] & 0xFF) << 8 | in[off + 3] & 0xFF;
    }

    public static long decodeLong(byte[] in) {
        return BigEndian.decodeLong(in, 0);
    }

    public static long decodeLong(byte[] in, int off) {
        return (long)(in[off] & 0xFF) << 56 | (long)(in[off + 1] & 0xFF) << 48 | (long)(in[off + 2] & 0xFF) << 40 | (long)(in[off + 3] & 0xFF) << 32 | (long)(in[off + 4] & 0xFF) << 24 | (long)(in[off + 5] & 0xFF) << 16 | (long)(in[off + 6] & 0xFF) << 8 | (long)(in[off + 7] & 0xFF);
    }

    private BigEndian() {
    }
}

