/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kocakosm.pitaya.util.Parameters;

public final class Classes {
    public static String getQualifiedName(Class<?> c) {
        if (c.isArray()) {
            StringBuilder qname = new StringBuilder();
            while (c.isArray()) {
                c = c.getComponentType();
                qname.append("[]");
            }
            qname.insert(0, c.getName());
            return qname.toString();
        }
        return c.getName();
    }

    public static String getShortName(Class<?> c) {
        String qname = Classes.getQualifiedName(c);
        int start = qname.lastIndexOf(36);
        if (start == -1) {
            start = qname.lastIndexOf(46);
        }
        return qname.substring(start + 1);
    }

    public static String getPackageName(Class<?> c) {
        String name = c.getName();
        int i = name.lastIndexOf(46);
        return i != -1 ? name.substring(0, i) : "";
    }

    public static Set<Class<?>> getSuperTypes(Class<?> c) {
        HashSet classes = new HashSet();
        for (Class<?> clazz : c.getInterfaces()) {
            classes.add(clazz);
            classes.addAll(Classes.getSuperTypes(clazz));
        }
        Class<?> sup = c.getSuperclass();
        if (sup != null) {
            classes.add(sup);
            classes.addAll(Classes.getSuperTypes(sup));
        }
        return Collections.unmodifiableSet(classes);
    }

    public static Set<Class<?>> getCommonSuperTypes(Class<?> ... classes) {
        return Classes.getCommonSuperTypes(Arrays.asList(classes));
    }

    public static Set<Class<?>> getCommonSuperTypes(Iterable<Class<?>> classes) {
        Iterator<Class<?>> i = classes.iterator();
        Parameters.checkCondition(i.hasNext());
        HashSet common = new HashSet(Classes.getSuperTypes(i.next()));
        while (i.hasNext()) {
            common.retainAll(Classes.getSuperTypes(i.next()));
        }
        return Collections.unmodifiableSet(common);
    }

    private Classes() {
    }
}

