/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.Random;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XArrays;

public final class Strings {
    private static final Random PRNG = new Random();

    public static boolean isBlank(String str) {
        for (char c : str.toCharArray()) {
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrBlank(String str) {
        return str == null || Strings.isBlank(str);
    }

    public static boolean isWhiteSpace(String str) {
        for (char c : str.toCharArray()) {
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrWhiteSpace(String str) {
        return str == null || Strings.isWhiteSpace(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String abbreviate(String str, int length) {
        return Strings.abbreviate(str, length, "...");
    }

    public static String abbreviate(String str, int length, String ellipsis) {
        Parameters.checkCondition(length > ellipsis.length());
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length - ellipsis.length()) + ellipsis;
    }

    public static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder(strings.length * 10);
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static int distance(String str1, String str2) {
        int i;
        char[] s1 = str1.toCharArray();
        char[] s2 = str2.toCharArray();
        int[][] d = new int[s1.length + 1][s2.length + 1];
        for (i = 0; i <= s1.length; ++i) {
            d[i][0] = i;
        }
        for (i = 0; i <= s2.length; ++i) {
            d[0][i] = i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int c = s1[i - 1] == s2[j - 1] ? 0 : 1;
                d[i][j] = Strings.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + c);
                if (i <= 1 || j <= 1 || s1[i - 1] != s2[j - 2] || s1[i - 2] != s2[j - 1]) continue;
                d[i][j] = Strings.min(d[i][j], d[i - 2][j - 2] + c);
            }
        }
        return d[s1.length][s2.length];
    }

    private static int min(int ... values) {
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static String emptyToNull(String str) {
        return str == null ? null : (str.isEmpty() ? null : str);
    }

    public static String nullToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String random(int length, char ... chars) {
        return Strings.random(length, PRNG, chars);
    }

    public static String random(int length, Random rnd, char ... chars) {
        Parameters.checkCondition(length >= 0);
        Parameters.checkCondition(chars.length > 0);
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(chars[rnd.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    public static String repeat(String str, int count) {
        Parameters.checkCondition(count >= 0);
        StringBuilder sb = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static String shuffle(String str) {
        return Strings.shuffle(str, PRNG);
    }

    public static String shuffle(String str, Random rnd) {
        return new String(XArrays.shuffle(str.toCharArray(), rnd));
    }

    public static String strip(String str, int n) {
        return Strings.stripRight(Strings.stripLeft(str, n), n);
    }

    public static String stripLeft(String str, int n) {
        Parameters.checkCondition(n >= 0);
        int start = Math.min(str.length(), n);
        return str.substring(start);
    }

    public static String stripRight(String str, int n) {
        Parameters.checkCondition(n >= 0);
        int end = Math.max(0, str.length() - n);
        return str.substring(0, end);
    }

    public static String trim(String str) {
        return str.trim();
    }

    public static String trimLeft(String str) {
        int start = 0;
        for (char c : str.toCharArray()) {
            if (c != ' ') break;
            ++start;
        }
        return str.substring(start);
    }

    public static String trimRight(String str) {
        int end = str.length();
        for (int i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --end;
        }
        return str.substring(0, end);
    }

    public static String padLeft(String str, int len, char padChar) {
        Parameters.checkCondition(len >= 0);
        StringBuilder sb = new StringBuilder(len);
        while (sb.length() < len - str.length()) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padRight(String str, int len, char padChar) {
        Parameters.checkNotNull(str);
        Parameters.checkCondition(len >= 0);
        StringBuilder sb = new StringBuilder(len);
        sb.append(str);
        while (sb.length() < len) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String quote(String str) {
        return new StringBuilder(str.length() + 2).append("\"").append(Strings.unquote(str)).append("\"").toString();
    }

    public static String unquote(String str) {
        String unquoted = str;
        while (unquoted.startsWith("\"")) {
            unquoted = unquoted.substring(1);
        }
        while (unquoted.endsWith("\"")) {
            unquoted = unquoted.substring(0, unquoted.length() - 1);
        }
        return unquoted;
    }

    public static int countOccurrences(String str, String sub) {
        Parameters.checkNotNull(str);
        int n = 0;
        if (!sub.isEmpty()) {
            int start = 0;
            while ((start = str.indexOf(sub, start)) != -1) {
                start += sub.length();
                ++n;
            }
        }
        return n;
    }

    private Strings() {
    }
}

