/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kocakosm.pitaya.util.Throwables;

public final class SystemProperties {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String USER_NAME = System.getProperty("user.name");
    public static final File USER_HOME = SystemProperties.toFile(System.getProperty("user.home"));
    public static final File USER_DIR = SystemProperties.toFile(System.getProperty("user.dir"));
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final File JAVA_HOME = SystemProperties.toFile(System.getProperty("java.home"));
    public static final String JAVA_COMPILER = System.getProperty("java.compiler");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final URL JAVA_VENDOR_URL = SystemProperties.toURL(System.getProperty("java.vendor.url"));
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final String JAVA_VM_VERSION = System.getProperty("java.vm.version");
    public static final String JAVA_VM_VENDOR = System.getProperty("java.vm.vendor");
    public static final String JAVA_VM_SPECIFICATION_NAME = System.getProperty("java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VERSION = System.getProperty("java.vm.specification.version");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = System.getProperty("java.vm.specification.vendor");
    public static final String JAVA_SPECIFICATION_NAME = System.getProperty("java.specification.name");
    public static final String JAVA_SPECIFICATION_VERSION = System.getProperty("java.specification.version");
    public static final String JAVA_SPECIFICATION_VENDOR = System.getProperty("java.specification.vendor");
    public static final List<File> JAVA_CLASS_PATH = SystemProperties.toFiles(System.getProperty("java.class.path"));
    public static final String JAVA_CLASS_VERSION = System.getProperty("java.class.version");
    public static final List<File> JAVA_LIBRARY_PATH = SystemProperties.toFiles(System.getProperty("java.library.path"));
    public static final File JAVA_IO_TMP_DIR = SystemProperties.toFile(System.getProperty("java.io.tmpdir"));
    public static final List<File> JAVA_EXT_DIRS = SystemProperties.toFiles(System.getProperty("java.ext.dirs"));

    private static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw Throwables.propagate(ex);
        }
    }

    private static File toFile(String path) {
        return new File(path);
    }

    private static List<File> toFiles(String paths) {
        String separator = System.getProperty("path.separator");
        ArrayList<File> files = new ArrayList<File>();
        for (String path : paths.split(separator)) {
            files.add(new File(path));
        }
        return Collections.unmodifiableList(files);
    }

    private SystemProperties() {
    }
}

