/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.BufferedMemoryReadable;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.ReadMemory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0005H \u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J[\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u0010\u0016\u001a\u00020\t2\u001d\u0010)\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H(0*\u00a2\u0006\u0002\b+2\u001e\u0010,\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c0-\u0012\u0004\u0012\u0002H(0-H\u0082\b\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\tH\u0016J\u0010\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\tH\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020\tH\u0016J]\u00105\u001a\u00020\t\"\u0004\b\u0000\u0010(2\u0006\u0010\u001e\u001a\u0002H(2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2/\u00106\u001a+\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001507\u00a2\u0006\u0002\b+H\u0082\b\u00a2\u0006\u0002\u00108J \u00105\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u0010\u001e\u001a\u000209H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010;\u001a\u00020\u001aH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006<"}, d2={"Lorg/kodein/memory/io/AbstractBufferedMemoryReadable;", "Lorg/kodein/memory/io/BufferedMemoryReadable;", "()V", "buffers", "Lkotlin/collections/ArrayDeque;", "Lorg/kodein/memory/io/ReadMemory;", "getBuffers$klio", "()Lkotlin/collections/ArrayDeque;", "buffersRemaining", "", "getBuffersRemaining$klio", "()I", "setBuffersRemaining$klio", "(I)V", "firstBufferPosition", "globalPosition", "getGlobalPosition$klio", "setGlobalPosition$klio", "position", "getPosition", "moveForward", "", "size", "nextBuffer", "nextBuffer$klio", "pullBuffer", "", "readByte", "", "readBytes", "dst", "", "dstOffset", "length", "readInt", "readLong", "", "readShort", "", "readValue", "T", "getValue", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "loadValue", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "requestCanRead", "needed", "skip", "count", "skipAtMost", "tryReadByte", "tryReadBytes", "getBytes", "Lkotlin/Function5;", "(Ljava/lang/Object;IILkotlin/jvm/functions/Function5;)I", "Lorg/kodein/memory/io/Memory;", "tryReadSlice", "valid", "klio"})
public abstract class AbstractBufferedMemoryReadable
implements BufferedMemoryReadable {
    private int globalPosition;
    @NotNull
    private final ArrayDeque<ReadMemory> buffers = new ArrayDeque();
    private int buffersRemaining;
    private int firstBufferPosition;

    public final int getGlobalPosition$klio() {
        return this.globalPosition;
    }

    public final void setGlobalPosition$klio(int n) {
        this.globalPosition = n;
    }

    @NotNull
    public final ArrayDeque<ReadMemory> getBuffers$klio() {
        return this.buffers;
    }

    public final int getBuffersRemaining$klio() {
        return this.buffersRemaining;
    }

    public final void setBuffersRemaining$klio(int n) {
        this.buffersRemaining = n;
    }

    @Override
    public int getPosition() {
        return this.globalPosition;
    }

    @Nullable
    public abstract ReadMemory nextBuffer$klio();

    private final boolean pullBuffer() {
        ReadMemory readMemory;
        block3: {
            block2: {
                ReadMemory readMemory2;
                readMemory = this.nextBuffer$klio();
                if (readMemory == null) break block2;
                ReadMemory it = readMemory2 = readMemory;
                boolean bl = false;
                readMemory = it.getSize() > 0 ? readMemory2 : null;
                if (readMemory != null) break block3;
            }
            return false;
        }
        ReadMemory buffer = readMemory;
        this.buffers.addLast((Object)buffer);
        this.buffersRemaining += buffer.getSize();
        return true;
    }

    private final void moveForward(int size) {
        this.globalPosition += size;
        this.firstBufferPosition += size;
        this.buffersRemaining -= size;
        while (this.firstBufferPosition > 0 && this.firstBufferPosition >= ((ReadMemory)this.buffers.first()).getSize()) {
            ReadMemory removed = (ReadMemory)this.buffers.removeFirst();
            this.firstBufferPosition -= removed.getSize();
        }
    }

    @Override
    public void requestCanRead(int needed) {
        while (needed > this.buffersRemaining) {
            if (this.pullBuffer()) continue;
            throw new IOException("Needed at least " + needed + " remaining bytes, but has only " + this.buffersRemaining + " bytes.");
        }
    }

    @Override
    public boolean valid() {
        if (this.buffersRemaining > 0) {
            return true;
        }
        return this.pullBuffer();
    }

    @Override
    public int tryReadByte() {
        if (!this.valid()) {
            return -1;
        }
        byte b = ((ReadMemory)this.buffers.first()).getByte(this.firstBufferPosition);
        this.moveForward(1);
        return b;
    }

    private final <T> int tryReadBytes(T dst, int dstOffset, int length, Function5<? super ReadMemory, ? super Integer, ? super T, ? super Integer, ? super Integer, Unit> getBytes) {
        boolean $i$f$tryReadBytes = false;
        if (!this.valid()) {
            return -1;
        }
        int remaining = length;
        int offset = 0;
        while (remaining > 0) {
            ReadMemory firstBuffer = (ReadMemory)this.buffers.first();
            int chunkSize = Math.min(remaining, firstBuffer.getSize() - this.firstBufferPosition);
            getBytes.invoke((Object)firstBuffer, (Object)this.firstBufferPosition, dst, (Object)(dstOffset + offset), (Object)chunkSize);
            remaining -= chunkSize;
            offset += chunkSize;
            this.moveForward(chunkSize);
            if (this.valid()) continue;
            break;
        }
        return offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int tryReadBytes(@NotNull byte[] dst, int dstOffset, int length) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        AbstractBufferedMemoryReadable this_$iv = this;
        boolean $i$f$tryReadBytes = false;
        if (!this_$iv.valid()) {
            n = -1;
        } else {
            int remaining$iv = length;
            int offset$iv = 0;
            while (remaining$iv > 0) {
                void p4;
                void p3;
                void p2;
                void p1;
                int chunkSize$iv;
                ReadMemory firstBuffer$iv = (ReadMemory)this_$iv.buffers.first();
                int n2 = chunkSize$iv = Math.min(remaining$iv, firstBuffer$iv.getSize() - this_$iv.firstBufferPosition);
                int n3 = dstOffset + offset$iv;
                byte[] byArray = dst;
                int n4 = this_$iv.firstBufferPosition;
                ReadMemory p0 = firstBuffer$iv;
                boolean bl = false;
                p0.getBytes((int)p1, (byte[])p2, (int)p3, (int)p4);
                remaining$iv -= chunkSize$iv;
                offset$iv += chunkSize$iv;
                this_$iv.moveForward(chunkSize$iv);
                if (this_$iv.valid()) continue;
            }
            n = offset$iv;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int tryReadBytes(@NotNull Memory dst) {
        int n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        AbstractBufferedMemoryReadable abstractBufferedMemoryReadable = this;
        boolean bl = false;
        int length$iv = dst.getSize();
        boolean $i$f$tryReadBytes = false;
        if (!this_$iv.valid()) {
            n = -1;
        } else {
            int remaining$iv = length$iv;
            int offset$iv = 0;
            while (remaining$iv > 0) {
                void length;
                void index;
                void dstOffset;
                void dst2;
                void dstOffset$iv;
                int chunkSize$iv;
                ReadMemory firstBuffer$iv = (ReadMemory)this_$iv.buffers.first();
                int n2 = chunkSize$iv = Math.min(remaining$iv, firstBuffer$iv.getSize() - this_$iv.firstBufferPosition);
                void var11_11 = dstOffset$iv + offset$iv;
                Memory memory = dst;
                int n3 = this_$iv.firstBufferPosition;
                ReadMemory $this$tryReadBytes_u24lambda_u2d1 = firstBuffer$iv;
                boolean bl2 = false;
                dst2.putBytes((int)dstOffset, $this$tryReadBytes_u24lambda_u2d1.slice((int)index, (int)length));
                remaining$iv -= chunkSize$iv;
                offset$iv += chunkSize$iv;
                super.moveForward(chunkSize$iv);
                if (this_$iv.valid()) continue;
            }
            n = offset$iv;
        }
        return n;
    }

    @Override
    public byte readByte() {
        this.requestCanRead(1);
        byte b = ((ReadMemory)this.buffers.first()).getByte(this.firstBufferPosition);
        this.moveForward(1);
        return b;
    }

    @Override
    public void readBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int read = this.tryReadBytes(dst, dstOffset, length);
        if (read < length) {
            throw new IOException("Needed to read " + length + " bytes, but could only read " + read + " bytes.");
        }
    }

    @Override
    @Nullable
    public ReadMemory tryReadSlice(int length) {
        ReadMemory firstBuffer = (ReadMemory)this.buffers.first();
        if (firstBuffer.getSize() - this.firstBufferPosition <= length) {
            ReadMemory slice = firstBuffer.slice(this.firstBufferPosition, length);
            this.moveForward(length);
            return slice;
        }
        return null;
    }

    private final <T> T readValue(int size, Function2<? super ReadMemory, ? super Integer, ? extends T> getValue, Function1<? super Function1<? super Integer, Byte>, ? extends T> loadValue) {
        boolean $i$f$readValue = false;
        this.requestCanRead(size);
        ReadMemory firstBuffer = (ReadMemory)this.buffers.first();
        if (firstBuffer.getSize() - this.firstBufferPosition >= size) {
            Object value = getValue.invoke((Object)firstBuffer, (Object)this.firstBufferPosition);
            this.moveForward(size);
            return (T)value;
        }
        return (T)loadValue.invoke((Object)new Function1<Integer, Byte>(this){
            final /* synthetic */ AbstractBufferedMemoryReadable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Byte invoke(int it) {
                return this.this$0.readByte();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShort() {
        short s;
        void this_$iv;
        AbstractBufferedMemoryReadable abstractBufferedMemoryReadable = this;
        int size$iv = 2;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        ReadMemory firstBuffer$iv = (ReadMemory)this_$iv.buffers.first();
        if (firstBuffer$iv.getSize() - this_$iv.firstBufferPosition >= size$iv) {
            void p1;
            int n = this_$iv.firstBufferPosition;
            ReadMemory p0 = firstBuffer$iv;
            boolean bl = false;
            short value$iv = p0.getShort((int)p1);
            super.moveForward(size$iv);
            s = value$iv;
        } else {
            Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
            boolean bl = false;
            boolean $i$f$slowLoadShort = false;
            byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
            byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
            s = (short)((b0$iv & 0xFF) << 8 | (b1$iv & 0xFF) << 0);
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        int n;
        void this_$iv;
        AbstractBufferedMemoryReadable abstractBufferedMemoryReadable = this;
        int size$iv = 4;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        ReadMemory firstBuffer$iv = (ReadMemory)this_$iv.buffers.first();
        if (firstBuffer$iv.getSize() - this_$iv.firstBufferPosition >= size$iv) {
            void p1;
            int n2 = this_$iv.firstBufferPosition;
            ReadMemory p0 = firstBuffer$iv;
            boolean bl = false;
            int value$iv = p0.getInt((int)p1);
            super.moveForward(size$iv);
            n = value$iv;
        } else {
            Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
            boolean bl = false;
            boolean $i$f$slowLoadInt = false;
            byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
            byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
            byte b2$iv = ((Number)p0.invoke((Object)2)).byteValue();
            byte b3$iv = ((Number)p0.invoke((Object)3)).byteValue();
            n = (b0$iv & 0xFF) << 24 | (b1$iv & 0xFF) << 16 | (b2$iv & 0xFF) << 8 | (b3$iv & 0xFF) << 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLong() {
        long l;
        void this_$iv;
        AbstractBufferedMemoryReadable abstractBufferedMemoryReadable = this;
        int size$iv = 8;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        ReadMemory firstBuffer$iv = (ReadMemory)this_$iv.buffers.first();
        if (firstBuffer$iv.getSize() - this_$iv.firstBufferPosition >= size$iv) {
            void p1;
            int n = this_$iv.firstBufferPosition;
            ReadMemory p0 = firstBuffer$iv;
            boolean bl = false;
            long value$iv = p0.getLong((int)p1);
            super.moveForward(size$iv);
            l = value$iv;
        } else {
            Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
            boolean bl = false;
            boolean $i$f$slowLoadLong = false;
            byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
            byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
            byte b2$iv = ((Number)p0.invoke((Object)2)).byteValue();
            byte b3$iv = ((Number)p0.invoke((Object)3)).byteValue();
            byte b4$iv = ((Number)p0.invoke((Object)4)).byteValue();
            byte b5$iv = ((Number)p0.invoke((Object)5)).byteValue();
            byte b6$iv = ((Number)p0.invoke((Object)6)).byteValue();
            byte b7$iv = ((Number)p0.invoke((Object)7)).byteValue();
            l = ((long)b0$iv & 0xFFL) << 56 | ((long)b1$iv & 0xFFL) << 48 | ((long)b2$iv & 0xFFL) << 40 | ((long)b3$iv & 0xFFL) << 32 | ((long)b4$iv & 0xFFL) << 24 | ((long)b5$iv & 0xFFL) << 16 | ((long)b6$iv & 0xFFL) << 8 | ((long)b7$iv & 0xFFL) << 0;
        }
        return l;
    }

    @Override
    public void skip(int count) {
        int skipped = this.skipAtMost(count);
        if (skipped < count) {
            throw new IOException("Needed to skip " + count + " bytes, but could only skip " + skipped + " bytes.");
        }
    }

    @Override
    public int skipAtMost(int count) {
        if (!this.valid()) {
            return 0;
        }
        int remaining = count;
        int skipped = 0;
        while (remaining > 0) {
            ReadMemory firstBuffer = (ReadMemory)this.buffers.first();
            int chunkSize = Math.min(remaining, firstBuffer.getSize() - this.firstBufferPosition);
            remaining -= chunkSize;
            skipped += chunkSize;
            this.moveForward(chunkSize);
            if (this.valid()) continue;
            break;
        }
        return skipped;
    }
}

