/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryReadable;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.text.HexKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0011\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u000bJ\u000b\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tJ&\u0010\u001c\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001fJ\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010!\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\"\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0014J\u0016\u0010#\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0016J\u001b\u0010$\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J(\u0010)\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH$J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH$J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH$J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH$J\u0018\u0010-\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tH$J(\u0010.\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH$J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH$J\u0018\u00100\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0014H$J\u0018\u00101\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0016H$J\u001d\u00102\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010%J\u001b\u00103\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0000H$\u00a2\u0006\u0002\u00104J\u001c\u00105\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0000H$J\u001c\u00106\u001a\u00020\r*\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000bH\u0004J\u001c\u00106\u001a\u00020\r*\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000bH\u0004\u00a8\u00068"}, d2={"Lorg/kodein/memory/io/AbstractMemory;", "M", "Lorg/kodein/memory/io/Memory;", "()V", "equals", "", "other", "", "getByte", "", "index", "", "getBytes", "", "dst", "", "dstOffset", "length", "getInt", "getLong", "", "getShort", "", "hashCode", "internalMemory", "()Lorg/kodein/memory/io/AbstractMemory;", "putByte", "value", "putBytes", "src", "srcOffset", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "putInt", "putLong", "putShort", "slice", "(II)Lorg/kodein/memory/io/AbstractMemory;", "toString", "", "unsafeGetByte", "unsafeGetBytes", "unsafeGetInt", "unsafeGetLong", "unsafeGetShort", "unsafePutByte", "unsafePutBytes", "unsafePutInt", "unsafePutLong", "unsafePutShort", "unsafeSlice", "unsafeTryEqualsOptimized", "(Lorg/kodein/memory/io/AbstractMemory;)Ljava/lang/Boolean;", "unsafeTryPutBytesOptimized", "requireSizeAt", "needed", "klio"})
public abstract class AbstractMemory<M extends AbstractMemory<M>>
implements Memory {
    protected final void requireSizeAt(@NotNull ReadMemory $this$requireSizeAt, int index, int needed) {
        Intrinsics.checkNotNullParameter((Object)$this$requireSizeAt, (String)"<this>");
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "index: " + index + " < 0.";
            throw new IllegalArgumentException(string.toString());
        }
        if (index + needed > $this$requireSizeAt.getSize()) {
            throw new IOException("Needed at least " + (index + needed) + " total bytes, but memory size is " + $this$requireSizeAt.getSize() + " bytes.");
        }
    }

    protected final void requireSizeAt(@NotNull byte[] $this$requireSizeAt, int index, int needed) {
        Intrinsics.checkNotNullParameter((Object)$this$requireSizeAt, (String)"<this>");
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "index: " + index + " < 0.";
            throw new IllegalArgumentException(string.toString());
        }
        if (index + needed > $this$requireSizeAt.length) {
            throw new IOException("Needed at least " + (index + needed) + " bytes, but array size is " + $this$requireSizeAt.length + " bytes.");
        }
    }

    @NotNull
    protected abstract M unsafeSlice(int var1, int var2);

    @NotNull
    public final M slice(int index, int length) {
        if (!(index >= 0)) {
            boolean $i$a$-require-AbstractMemory$slice$32 = false;
            String $i$a$-require-AbstractMemory$slice$32 = "index: " + index + " < 0";
            throw new IllegalArgumentException($i$a$-require-AbstractMemory$slice$32.toString());
        }
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "length: " + length + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.requireSizeAt(this, index, length);
        if (index == 0 && length == this.getSize()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type M of org.kodein.memory.io.AbstractMemory");
            return (M)this;
        }
        return this.unsafeSlice(index, length);
    }

    @Override
    public final void putByte(int index, byte value) {
        this.requireSizeAt(this, index, 1);
        this.unsafePutByte(index, value);
    }

    protected abstract void unsafePutByte(int var1, byte var2);

    @Override
    public final void putShort(int index, short value) {
        this.requireSizeAt(this, index, 2);
        this.unsafePutShort(index, value);
    }

    protected abstract void unsafePutShort(int var1, short var2);

    @Override
    public final void putInt(int index, int value) {
        this.requireSizeAt(this, index, 4);
        this.unsafePutInt(index, value);
    }

    protected abstract void unsafePutInt(int var1, int var2);

    @Override
    public final void putLong(int index, long value) {
        this.requireSizeAt(this, index, 8);
        this.unsafePutLong(index, value);
    }

    protected abstract void unsafePutLong(int var1, long var2);

    @Override
    public final void putBytes(int index, @NotNull byte[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!(srcOffset >= 0)) {
            boolean $i$a$-require-AbstractMemory$putBytes$32 = false;
            String $i$a$-require-AbstractMemory$putBytes$32 = "srcOffset: " + srcOffset + " < 0";
            throw new IllegalArgumentException($i$a$-require-AbstractMemory$putBytes$32.toString());
        }
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "length: " + length + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.requireSizeAt(src, srcOffset, length);
        this.requireSizeAt(this, index, length);
        if (length == 0) {
            return;
        }
        this.unsafePutBytes(index, src, srcOffset, length);
    }

    protected abstract void unsafePutBytes(int var1, @NotNull byte[] var2, int var3, int var4);

    protected abstract boolean unsafeTryPutBytesOptimized(int var1, @NotNull AbstractMemory<?> var2);

    @Override
    public final void putBytes(int index, @NotNull ReadMemory src) {
        boolean hasOptimized;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.requireSizeAt(this, index, src.getSize());
        if (src.getSize() == 0) {
            return;
        }
        ReadMemory srcMemory = src.internalMemory();
        ReadMemory readMemory = srcMemory;
        if (readMemory instanceof ByteArrayMemory) {
            this.unsafePutBytes(index, ((ByteArrayMemory)srcMemory).getArray(), ((ByteArrayMemory)srcMemory).getOffset(), src.getSize());
            bl = true;
        } else {
            bl = hasOptimized = readMemory instanceof AbstractMemory ? this.unsafeTryPutBytesOptimized(index, (AbstractMemory)srcMemory) : false;
        }
        if (!hasOptimized) {
            int n = src.getSize();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                this.unsafePutByte(index + it, srcMemory.getByte(it));
            }
        }
    }

    @Override
    public final void putBytes(int index, @NotNull Readable src, int length) {
        boolean hasOptimized;
        boolean bl;
        ReadMemory srcMemory;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!(length >= 0)) {
            boolean $i$a$-require-AbstractMemory$putBytes$52 = false;
            String $i$a$-require-AbstractMemory$putBytes$52 = "length: " + length + " < 0";
            throw new IllegalArgumentException($i$a$-require-AbstractMemory$putBytes$52.toString());
        }
        this.requireSizeAt(this, index, length);
        if (length == 0) {
            return;
        }
        src.requestCanRead(length);
        Object object = src instanceof MemoryReadable ? (MemoryReadable)src : null;
        ReadMemory readMemory = object != null && (object = ((MemoryReadable)object).getMemory()) != null ? object.internalMemory() : (srcMemory = null);
        if (srcMemory instanceof ByteArrayMemory) {
            this.unsafePutBytes(index, ((ByteArrayMemory)srcMemory).getArray(), ((ByteArrayMemory)srcMemory).getOffset() + src.getPosition(), length);
            bl = true;
        } else {
            bl = hasOptimized = srcMemory instanceof AbstractMemory ? this.unsafeTryPutBytesOptimized(index, (AbstractMemory<?>)((AbstractMemory)srcMemory).slice(src.getPosition(), length)) : false;
        }
        if (hasOptimized) {
            src.skip(length);
        } else {
            int n = 0;
            while (n < length) {
                int it = n++;
                boolean bl2 = false;
                this.unsafePutByte(index + it, src.readByte());
            }
        }
    }

    @Override
    public final byte getByte(int index) {
        this.requireSizeAt(this, index, 1);
        return this.unsafeGetByte(index);
    }

    protected abstract byte unsafeGetByte(int var1);

    @Override
    public final short getShort(int index) {
        this.requireSizeAt(this, index, 2);
        return this.unsafeGetShort(index);
    }

    protected abstract short unsafeGetShort(int var1);

    @Override
    public final int getInt(int index) {
        this.requireSizeAt(this, index, 4);
        return this.unsafeGetInt(index);
    }

    protected abstract int unsafeGetInt(int var1);

    @Override
    public final long getLong(int index) {
        this.requireSizeAt(this, index, 8);
        return this.unsafeGetLong(index);
    }

    protected abstract long unsafeGetLong(int var1);

    @Override
    public final void getBytes(int index, @NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(dstOffset >= 0)) {
            boolean $i$a$-require-AbstractMemory$getBytes$32 = false;
            String $i$a$-require-AbstractMemory$getBytes$32 = "offset: " + dstOffset + " < 0";
            throw new IllegalArgumentException($i$a$-require-AbstractMemory$getBytes$32.toString());
        }
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "length: " + length + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.requireSizeAt(dst, dstOffset, length);
        this.requireSizeAt(this, index, length);
        if (length == 0) {
            return;
        }
        this.unsafeGetBytes(index, dst, dstOffset, length);
    }

    protected abstract void unsafeGetBytes(int var1, @NotNull byte[] var2, int var3, int var4);

    @NotNull
    public final M internalMemory() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type M of org.kodein.memory.io.AbstractMemory");
        return (M)this;
    }

    public boolean equals(@Nullable Object other) {
        Boolean optimized;
        Boolean bl;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Memory)) {
            return false;
        }
        if (((Memory)other).getSize() != this.getSize()) {
            return false;
        }
        Memory otherInternalMemory = ((Memory)other).internalMemory();
        AbstractMemory abstractMemory = otherInternalMemory instanceof AbstractMemory ? (AbstractMemory)otherInternalMemory : null;
        if (abstractMemory != null) {
            AbstractMemory it = abstractMemory;
            boolean bl2 = false;
            bl = this.unsafeTryEqualsOptimized((AbstractMemory)otherInternalMemory);
        } else {
            bl = null;
        }
        Boolean bl3 = optimized = bl;
        if (bl3 != null) {
            return bl3;
        }
        return ReadMemoryKt.compareTo((ReadMemory)this, otherInternalMemory) == 0;
    }

    @Nullable
    protected abstract Boolean unsafeTryEqualsOptimized(@NotNull AbstractMemory<?> var1);

    public final int hashCode() {
        int h = 1;
        for (int i = this.getSize() - 1; -1 < i; --i) {
            h = 31 * h + this.unsafeGetByte(i);
        }
        return h;
    }

    @NotNull
    public String toString() {
        return this.getSize() <= 64 ? Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ':' + HexKt.toHex(this) : Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + '(' + this.getSize() + ')';
    }

    @Override
    public void set(int index, byte value) {
        Memory.DefaultImpls.set(this, index, value);
    }

    @Override
    public byte get(int index) {
        return Memory.DefaultImpls.get(this, index);
    }
}

