/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.AbstractMemory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0010H\u0014J(\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0014J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0019H\u0014J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001bH\u0014J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u001b\u0010%\u001a\u0004\u0018\u00010&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0014\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00052\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/kodein/memory/io/ByteArrayMemory;", "Lorg/kodein/memory/io/AbstractMemory;", "array", "", "offset", "", "size", "([BII)V", "getArray", "()[B", "getOffset", "()I", "getSize", "fill", "", "byte", "", "unsafeGetByte", "index", "unsafeGetBytes", "dst", "dstOffset", "length", "unsafeGetInt", "unsafeGetLong", "", "unsafeGetShort", "", "unsafePutByte", "value", "unsafePutBytes", "src", "srcOffset", "unsafePutInt", "unsafePutLong", "unsafePutShort", "unsafeSlice", "unsafeTryEqualsOptimized", "", "other", "(Lorg/kodein/memory/io/AbstractMemory;)Ljava/lang/Boolean;", "unsafeTryPutBytesOptimized", "klio"})
public final class ByteArrayMemory
extends AbstractMemory<ByteArrayMemory> {
    @NotNull
    private final byte[] array;
    private final int offset;
    private final int size;

    public ByteArrayMemory(@NotNull byte[] array2, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.array = array2;
        this.offset = offset;
        this.size = size;
    }

    public /* synthetic */ ByteArrayMemory(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        this(byArray, n, n2);
    }

    @NotNull
    public final byte[] getArray() {
        return this.array;
    }

    public final int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    protected ByteArrayMemory unsafeSlice(int index, int length) {
        return new ByteArrayMemory(this.array, this.offset + index, length);
    }

    @Override
    protected void unsafePutBytes(int index, @NotNull byte[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        ArraysKt.copyInto((byte[])src, (byte[])this.array, (int)(this.offset + index), (int)srcOffset, (int)(srcOffset + length));
    }

    @Override
    protected boolean unsafeTryPutBytesOptimized(int index, @NotNull AbstractMemory<?> src) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        return false;
    }

    @Override
    protected void unsafePutByte(int index, byte value) {
        this.array[this.offset + index] = value;
    }

    @Override
    protected void unsafePutShort(int index, short value) {
        byte b;
        boolean $i$f$slowStoreShort = false;
        short intValue$iv = value;
        byte by = (byte)(intValue$iv >>> 8 & 0xFF);
        int i = 0;
        boolean bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(intValue$iv >>> 0 & 0xFF);
        i = 1;
        bl = false;
        this.array[this.offset + index + i] = b;
    }

    @Override
    protected void unsafePutInt(int index, int value) {
        byte b;
        boolean $i$f$slowStoreInt = false;
        byte by = (byte)(value >>> 24 & 0xFF);
        int i = 0;
        boolean bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 16 & 0xFF);
        i = 1;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 8 & 0xFF);
        i = 2;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 0 & 0xFF);
        i = 3;
        bl = false;
        this.array[this.offset + index + i] = b;
    }

    @Override
    protected void unsafePutLong(int index, long value) {
        byte b;
        boolean $i$f$slowStoreLong = false;
        byte by = (byte)(value >>> 56 & 0xFFL);
        int i = 0;
        boolean bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 48 & 0xFFL);
        i = 1;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 40 & 0xFFL);
        i = 2;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 32 & 0xFFL);
        i = 3;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 24 & 0xFFL);
        i = 4;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 16 & 0xFFL);
        i = 5;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 8 & 0xFFL);
        i = 6;
        bl = false;
        this.array[this.offset + index + i] = b;
        b = (byte)(value >>> 0 & 0xFFL);
        i = 7;
        bl = false;
        this.array[this.offset + index + i] = b;
    }

    @Override
    protected void unsafeGetBytes(int index, @NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ArraysKt.copyInto((byte[])this.array, (byte[])dst, (int)dstOffset, (int)(this.offset + index), (int)(this.offset + index + length));
    }

    @Override
    protected byte unsafeGetByte(int index) {
        return this.array[this.offset + index];
    }

    @Override
    protected short unsafeGetShort(int index) {
        boolean $i$f$slowLoadShort = false;
        int it = 0;
        boolean bl = false;
        byte b0$iv = this.array[this.offset + index + it];
        it = 1;
        bl = false;
        byte b1$iv = this.array[this.offset + index + it];
        return (short)((b0$iv & 0xFF) << 8 | (b1$iv & 0xFF) << 0);
    }

    @Override
    protected int unsafeGetInt(int index) {
        boolean $i$f$slowLoadInt = false;
        int it = 0;
        boolean bl = false;
        byte b0$iv = this.array[this.offset + index + it];
        it = 1;
        bl = false;
        byte b1$iv = this.array[this.offset + index + it];
        it = 2;
        bl = false;
        byte b2$iv = this.array[this.offset + index + it];
        int it2 = 3;
        $i$a$-slowLoadInt-ByteArrayMemory$unsafeGetInt$1 = false;
        byte b3$iv = this.array[this.offset + index + it2];
        return (b0$iv & 0xFF) << 24 | (b1$iv & 0xFF) << 16 | (b2$iv & 0xFF) << 8 | (b3$iv & 0xFF) << 0;
    }

    @Override
    protected long unsafeGetLong(int index) {
        boolean $i$f$slowLoadLong = false;
        int it = 0;
        boolean bl = false;
        byte b0$iv = this.array[this.offset + index + it];
        it = 1;
        bl = false;
        byte b1$iv = this.array[this.offset + index + it];
        it = 2;
        bl = false;
        byte b2$iv = this.array[this.offset + index + it];
        int it2 = 3;
        $i$a$-slowLoadLong-ByteArrayMemory$unsafeGetLong$1 = false;
        byte b3$iv = this.array[this.offset + index + it2];
        int it3 = 4;
        $i$a$-slowLoadLong-ByteArrayMemory$unsafeGetLong$1 = false;
        byte b4$iv = this.array[this.offset + index + it3];
        int it4 = 5;
        $i$a$-slowLoadLong-ByteArrayMemory$unsafeGetLong$1 = false;
        byte b5$iv = this.array[this.offset + index + it4];
        int it5 = 6;
        $i$a$-slowLoadLong-ByteArrayMemory$unsafeGetLong$1 = false;
        byte b6$iv = this.array[this.offset + index + it5];
        int it6 = 7;
        $i$a$-slowLoadLong-ByteArrayMemory$unsafeGetLong$1 = false;
        byte b7$iv = this.array[this.offset + index + it6];
        return ((long)b0$iv & 0xFFL) << 56 | ((long)b1$iv & 0xFFL) << 48 | ((long)b2$iv & 0xFFL) << 40 | ((long)b3$iv & 0xFFL) << 32 | ((long)b4$iv & 0xFFL) << 24 | ((long)b5$iv & 0xFFL) << 16 | ((long)b6$iv & 0xFFL) << 8 | ((long)b7$iv & 0xFFL) << 0;
    }

    @Override
    @Nullable
    protected Boolean unsafeTryEqualsOptimized(@NotNull AbstractMemory<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.offset == 0 && this.getSize() == this.array.length && other instanceof ByteArrayMemory && ((ByteArrayMemory)other).offset == 0 && this.getSize() == ((ByteArrayMemory)other).array.length) {
            return Arrays.equals(this.array, ((ByteArrayMemory)other).array);
        }
        return null;
    }

    @Override
    public void fill(byte by) {
        ArraysKt.fill((byte[])this.array, (byte)by, (int)this.offset, (int)(this.offset + this.getSize()));
    }
}

