/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.CursorWriteable;
import org.kodein.memory.io.ExpandableMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.Readable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001bB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u0007\u00a2\u0006\u0002\b\u001aR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/kodein/memory/io/ExpandableMemoryImpl;", "M", "Lorg/kodein/memory/io/Memory;", "Lorg/kodein/memory/io/ExpandableMemory;", "initialCapacity", "", "alloc", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)V", "bytesCopied", "getBytesCopied", "()I", "setBytesCopied", "(I)V", "memory", "getMemory", "()Lorg/kodein/memory/io/Memory;", "setMemory", "(Lorg/kodein/memory/io/Memory;)V", "Lorg/kodein/memory/io/Memory;", "close", "", "slice", "Lorg/kodein/memory/io/ReadMemory;", "write", "Lorg/kodein/memory/io/CursorWriteable;", "Lkotlin/ExtensionFunctionType;", "W", "klio"})
class ExpandableMemoryImpl<M extends Memory>
implements ExpandableMemory {
    private final int initialCapacity;
    @NotNull
    private final Function1<Integer, M> alloc;
    @NotNull
    private M memory;
    private int bytesCopied;

    public ExpandableMemoryImpl(int initialCapacity, @NotNull Function1<? super Integer, ? extends M> alloc2) {
        Intrinsics.checkNotNullParameter(alloc2, (String)"alloc");
        this.initialCapacity = initialCapacity;
        this.alloc = alloc2;
        this.memory = (Memory)this.alloc.invoke((Object)this.initialCapacity);
    }

    @NotNull
    public final M getMemory() {
        return this.memory;
    }

    public final void setMemory(@NotNull M m) {
        Intrinsics.checkNotNullParameter(m, (String)"<set-?>");
        this.memory = m;
    }

    @Override
    public int getBytesCopied() {
        return this.bytesCopied;
    }

    public void setBytesCopied(int n) {
        this.bytesCopied = n;
    }

    @Override
    @NotNull
    public final ReadMemory slice(@NotNull Function1<? super CursorWriteable, Unit> write) {
        Intrinsics.checkNotNullParameter(write, (String)"write");
        W w = new W();
        write.invoke((Object)w);
        return this.memory.slice(0, w.getPosition());
    }

    public void close(@NotNull M memory) {
        Intrinsics.checkNotNullParameter(memory, (String)"memory");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u001fH\u0016JI\u0010 \u001a\u00020\f\"\u0004\b\u0001\u0010!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u0002H!2#\u0010#\u001a\u001f\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020\f0$\u00a2\u0006\u0002\b&H\u0082\b\u00a2\u0006\u0002\u0010'R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006("}, d2={"Lorg/kodein/memory/io/ExpandableMemoryImpl$W;", "Lorg/kodein/memory/io/CursorWriteable;", "(Lorg/kodein/memory/io/ExpandableMemoryImpl;)V", "position", "", "getPosition", "()I", "setPosition", "(I)V", "remaining", "getRemaining", "flush", "", "requestCanWrite", "needed", "skip", "count", "writeByte", "value", "", "writeBytes", "src", "", "srcOffset", "length", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "writeInt", "writeLong", "", "writeShort", "", "writeValue", "T", "size", "putValue", "Lkotlin/Function3;", "Lorg/kodein/memory/io/Memory;", "Lkotlin/ExtensionFunctionType;", "(ILjava/lang/Object;Lkotlin/jvm/functions/Function3;)V", "klio"})
    public final class W
    implements CursorWriteable {
        private int position;
        private final int remaining = Integer.MAX_VALUE;

        @Override
        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        @Override
        public int getRemaining() {
            return this.remaining;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestCanWrite(int needed) {
            int totalNeeded = this.getPosition() + needed;
            if (totalNeeded <= ExpandableMemoryImpl.this.getMemory().getSize()) {
                return;
            }
            int factor = (int)Math.ceil((double)totalNeeded / (double)ExpandableMemoryImpl.this.initialCapacity);
            Object previousMemory = ExpandableMemoryImpl.this.getMemory();
            ExpandableMemoryImpl.this.setMemory((Memory)ExpandableMemoryImpl.this.alloc.invoke((Object)(factor * ExpandableMemoryImpl.this.initialCapacity)));
            try {
                if (this.getPosition() > 0) {
                    ExpandableMemoryImpl.this.getMemory().putBytes(0, previousMemory.slice(0, this.getPosition()));
                    ExpandableMemoryImpl expandableMemoryImpl = ExpandableMemoryImpl.this;
                    expandableMemoryImpl.setBytesCopied(expandableMemoryImpl.getBytesCopied() + this.getPosition());
                }
            }
            finally {
                ExpandableMemoryImpl.this.close(previousMemory);
            }
        }

        private final <T> void writeValue(int size, T value, Function3<? super Memory, ? super Integer, ? super T, Unit> putValue) {
            boolean $i$f$writeValue = false;
            this.requestCanWrite(size);
            putValue.invoke(ExpandableMemoryImpl.this.getMemory(), (Object)this.getPosition(), value);
            this.setPosition(this.getPosition() + size);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeByte(byte value) {
            void p2;
            void p1;
            void size$iv;
            void this_$iv;
            W w = this;
            boolean bl = true;
            byte value$iv = value;
            boolean $i$f$writeValue = false;
            this_$iv.requestCanWrite((int)size$iv);
            byte by = value$iv;
            int n = this_$iv.getPosition();
            Object p0 = this_$iv.ExpandableMemoryImpl.this.getMemory();
            boolean bl2 = false;
            p0.putByte((int)p1, (byte)p2);
            this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeShort(short value) {
            void p2;
            void p1;
            void size$iv;
            void this_$iv;
            W w = this;
            int n = 2;
            short value$iv = value;
            boolean $i$f$writeValue = false;
            this_$iv.requestCanWrite((int)size$iv);
            short s = value$iv;
            int n2 = this_$iv.getPosition();
            Object p0 = this_$iv.ExpandableMemoryImpl.this.getMemory();
            boolean bl = false;
            p0.putShort((int)p1, (short)p2);
            this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeInt(int value) {
            void p2;
            void p1;
            void size$iv;
            void this_$iv;
            W w = this;
            int n = 4;
            int value$iv = value;
            boolean $i$f$writeValue = false;
            this_$iv.requestCanWrite((int)size$iv);
            int n2 = value$iv;
            int n3 = this_$iv.getPosition();
            Object p0 = this_$iv.ExpandableMemoryImpl.this.getMemory();
            boolean bl = false;
            p0.putInt((int)p1, (int)p2);
            this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeLong(long value) {
            void p2;
            void p1;
            void size$iv;
            void this_$iv;
            W w = this;
            int n = 8;
            long value$iv = value;
            boolean $i$f$writeValue = false;
            this_$iv.requestCanWrite((int)size$iv);
            long l = value$iv;
            int n2 = this_$iv.getPosition();
            Object p0 = this_$iv.ExpandableMemoryImpl.this.getMemory();
            boolean bl = false;
            p0.putLong((int)p1, (long)p2);
            this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        }

        @Override
        public void writeBytes(@NotNull byte[] src, int srcOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.requestCanWrite(length);
            ExpandableMemoryImpl.this.getMemory().putBytes(this.getPosition(), src, srcOffset, length);
            this.setPosition(this.getPosition() + length);
        }

        @Override
        public void writeBytes(@NotNull ReadMemory src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.requestCanWrite(src.getSize());
            ExpandableMemoryImpl.this.getMemory().putBytes(this.getPosition(), src);
            this.setPosition(this.getPosition() + src.getSize());
        }

        @Override
        public void writeBytes(@NotNull Readable src, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.requestCanWrite(length);
            ExpandableMemoryImpl.this.getMemory().putBytes(this.getPosition(), src, length);
            this.setPosition(this.getPosition() + length);
        }

        @Override
        public void flush() {
        }

        @Override
        public void skip(int count) {
            if (!(count >= 0)) {
                boolean bl = false;
                String string = "count: " + count + " < 0";
                throw new IllegalArgumentException(string.toString());
            }
            this.requestCanWrite(count);
            this.setPosition(this.getPosition() + count);
        }
    }
}

