/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.ReadableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J<\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u001e\u0010 \u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130!\u0012\u0004\u0012\u0002H\u001e0!H\u0082\b\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\nH\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\nH\u0016J \u0010)\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020*H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/kodein/memory/io/InputStreamReadable;", "Lorg/kodein/memory/io/Readable;", "Ljava/io/Closeable;", "Lorg/kodein/memory/Closeable;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "buffer", "", "<set-?>", "", "position", "getPosition", "()I", "valid", "", "close", "", "readByte", "", "readBytes", "dst", "dstOffset", "length", "readInt", "readLong", "", "readShort", "", "readValue", "T", "size", "loadValue", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "requestCanRead", "needed", "skip", "count", "skipAtMost", "tryReadByte", "tryReadBytes", "Lorg/kodein/memory/io/Memory;", "klio"})
public final class InputStreamReadable
implements Readable,
Closeable {
    @NotNull
    private final InputStream stream;
    private boolean valid;
    @NotNull
    private byte[] buffer;
    private int position;

    public InputStreamReadable(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.valid = true;
        this.buffer = new byte[8];
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void requestCanRead(int needed) {
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    @Override
    public int tryReadByte() {
        int r = this.stream.read();
        if (r == -1) {
            this.valid = false;
        } else {
            this.position = this.getPosition() + 1;
        }
        return r;
    }

    @Override
    public int tryReadBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(dstOffset >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dstOffset + length <= dst.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int r = this.stream.read(dst, dstOffset, length);
        if (r == -1) {
            this.valid = false;
        } else {
            this.position = this.getPosition() + r;
        }
        return r;
    }

    @Override
    public int tryReadBytes(@NotNull Memory dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Memory dstMemory = dst.internalMemory();
        if (dstMemory instanceof ByteArrayMemory) {
            int r = this.stream.read(((ByteArrayMemory)dstMemory).getArray(), ((ByteArrayMemory)dstMemory).getOffset(), dstMemory.getSize());
            if (r == -1) {
                this.valid = false;
            } else {
                this.position = this.getPosition() + r;
            }
            return r;
        }
        byte[] buffer = new byte[dst.getSize()];
        int r = ReadableKt.tryReadBytes(this, buffer);
        if (r == -1) {
            dst.putBytes(0, buffer, 0, r);
        }
        return r;
    }

    @Override
    public byte readByte() {
        int b = this.tryReadByte();
        if (b == -1) {
            throw new IOException("Stream is over.");
        }
        return (byte)b;
    }

    private final <T> T readValue(int size, Function1<? super Function1<? super Integer, Byte>, ? extends T> loadValue) {
        boolean $i$f$readValue = false;
        int n = this.stream.readNBytes(this.buffer, 0, size);
        this.position = this.getPosition() + n;
        if (n != size) {
            throw new IOException("Stream is over. Needed " + size + " bytes, but only got " + n + '.');
        }
        return (T)loadValue.invoke((Object)new Function1<Integer, Byte>(this){
            final /* synthetic */ InputStreamReadable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Byte invoke(int it) {
                return InputStreamReadable.access$getBuffer$p(this.this$0)[it];
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShort() {
        void this_$iv;
        InputStreamReadable inputStreamReadable = this;
        int size$iv = 2;
        boolean $i$f$readValue = false;
        int n$iv = this_$iv.stream.readNBytes(this_$iv.buffer, 0, size$iv);
        this_$iv.position = this_$iv.getPosition() + n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Stream is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
        boolean bl = false;
        boolean $i$f$slowLoadShort = false;
        byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
        byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
        return (short)((b0$iv & 0xFF) << 8 | (b1$iv & 0xFF) << 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        void this_$iv;
        InputStreamReadable inputStreamReadable = this;
        int size$iv = 4;
        boolean $i$f$readValue = false;
        int n$iv = this_$iv.stream.readNBytes(this_$iv.buffer, 0, size$iv);
        this_$iv.position = this_$iv.getPosition() + n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Stream is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
        boolean bl = false;
        boolean $i$f$slowLoadInt = false;
        byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
        byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
        byte b2$iv = ((Number)p0.invoke((Object)2)).byteValue();
        byte b3$iv = ((Number)p0.invoke((Object)3)).byteValue();
        return (b0$iv & 0xFF) << 24 | (b1$iv & 0xFF) << 16 | (b2$iv & 0xFF) << 8 | (b3$iv & 0xFF) << 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLong() {
        void this_$iv;
        InputStreamReadable inputStreamReadable = this;
        int size$iv = 8;
        boolean $i$f$readValue = false;
        int n$iv = this_$iv.stream.readNBytes(this_$iv.buffer, 0, size$iv);
        this_$iv.position = this_$iv.getPosition() + n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Stream is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        Function1 p0 = (Function1)new /* invalid duplicate definition of identical inner class */;
        boolean bl = false;
        boolean $i$f$slowLoadLong = false;
        byte b0$iv = ((Number)p0.invoke((Object)0)).byteValue();
        byte b1$iv = ((Number)p0.invoke((Object)1)).byteValue();
        byte b2$iv = ((Number)p0.invoke((Object)2)).byteValue();
        byte b3$iv = ((Number)p0.invoke((Object)3)).byteValue();
        byte b4$iv = ((Number)p0.invoke((Object)4)).byteValue();
        byte b5$iv = ((Number)p0.invoke((Object)5)).byteValue();
        byte b6$iv = ((Number)p0.invoke((Object)6)).byteValue();
        byte b7$iv = ((Number)p0.invoke((Object)7)).byteValue();
        return ((long)b0$iv & 0xFFL) << 56 | ((long)b1$iv & 0xFFL) << 48 | ((long)b2$iv & 0xFFL) << 40 | ((long)b3$iv & 0xFFL) << 32 | ((long)b4$iv & 0xFFL) << 24 | ((long)b5$iv & 0xFFL) << 16 | ((long)b6$iv & 0xFFL) << 8 | ((long)b7$iv & 0xFFL) << 0;
    }

    @Override
    public void readBytes(@NotNull byte[] dst, int dstOffset, int length) {
        int r;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(dstOffset >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dstOffset + length <= dst.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int read = 0; read < length; read += r) {
            r = this.stream.read(dst, dstOffset + read, length - read);
            if (r == -1) {
                throw new IOException("Stream is over. Needed " + length + " bytes, but only got " + read + '.');
            }
            this.position = this.getPosition() + r;
        }
    }

    @Override
    public void skip(int count) {
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = (int)this.stream.skip(count);
        this.position = this.getPosition() + n;
        if (n != count) {
            throw new IOException("Could not skip " + count + " bytes, skipped only " + n + '.');
        }
    }

    @Override
    public int skipAtMost(int count) {
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)this.stream.skip(count);
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public static final /* synthetic */ byte[] access$getBuffer$p(InputStreamReadable $this) {
        return $this.buffer;
    }
}

