/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.SeekableCursorReadable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\bJ;\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u0010\u001a\u00020\b2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H!0#\u00a2\u0006\u0002\b$H\u0082\b\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\bH\u0016J \u0010,\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u00060"}, d2={"Lorg/kodein/memory/io/MemoryReadable;", "Lorg/kodein/memory/io/SeekableCursorReadable;", "memory", "Lorg/kodein/memory/io/ReadMemory;", "(Lorg/kodein/memory/io/ReadMemory;)V", "getMemory", "()Lorg/kodein/memory/io/ReadMemory;", "value", "", "position", "getPosition", "()I", "setPosition", "(I)V", "remaining", "getRemaining", "size", "getSize", "readByte", "", "readBytes", "", "dst", "", "dstOffset", "length", "readInt", "readLong", "", "readShort", "", "readSlice", "readValue", "T", "getValue", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "requestCanRead", "needed", "skip", "count", "skipAtMost", "tryReadByte", "tryReadBytes", "Lorg/kodein/memory/io/Memory;", "valid", "", "klio"})
public final class MemoryReadable
implements SeekableCursorReadable {
    @NotNull
    private final ReadMemory memory;
    private int position;

    public MemoryReadable(@NotNull ReadMemory memory) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        this.memory = memory;
    }

    @NotNull
    public final ReadMemory getMemory() {
        return this.memory;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int value) {
        if (!(value >= 0)) {
            boolean $i$a$-require-MemoryReadable$position$32 = false;
            String $i$a$-require-MemoryReadable$position$32 = value + " < 0.";
            throw new IllegalArgumentException($i$a$-require-MemoryReadable$position$32.toString());
        }
        if (!(value <= this.memory.getSize())) {
            boolean bl = false;
            String string = "position: " + value + " > memory.size: " + this.memory.getSize() + '.';
            throw new IllegalArgumentException(string.toString());
        }
        this.position = value;
    }

    @NotNull
    public final ReadMemory readSlice(int length) {
        ReadMemory slice = this.memory.slice(this.getPosition(), length);
        this.setPosition(this.getPosition() + length);
        return slice;
    }

    @Override
    public int getRemaining() {
        return this.memory.getSize() - this.getPosition();
    }

    @Override
    public int getSize() {
        return this.memory.getSize();
    }

    @Override
    public boolean valid() {
        return this.getRemaining() != 0;
    }

    @Override
    public void requestCanRead(int needed) {
        if (needed > this.getRemaining()) {
            throw new IOException("Needed at least " + needed + " remaining bytes, but has only " + this.getRemaining() + " bytes.");
        }
    }

    @Override
    public int tryReadByte() {
        if (!this.valid()) {
            return -1;
        }
        byte b = this.memory.getByte(this.getPosition());
        this.setPosition(this.getPosition() + 1);
        return b;
    }

    @Override
    public int tryReadBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!this.valid()) {
            return -1;
        }
        int readLength = Math.min(length, this.getRemaining());
        this.memory.getBytes(this.getPosition(), dst, dstOffset, readLength);
        this.setPosition(this.getPosition() + readLength);
        return readLength;
    }

    @Override
    public int tryReadBytes(@NotNull Memory dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!this.valid()) {
            return -1;
        }
        int readLength = Math.min(dst.getSize(), this.getRemaining());
        dst.putBytes(0, this.memory.slice(this.getPosition(), readLength));
        this.setPosition(this.getPosition() + readLength);
        return readLength;
    }

    private final <T> T readValue(int size, Function2<? super ReadMemory, ? super Integer, ? extends T> getValue) {
        boolean $i$f$readValue = false;
        this.requestCanRead(size);
        Object value = getValue.invoke((Object)this.memory, (Object)this.getPosition());
        this.setPosition(this.getPosition() + size);
        return (T)value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte readByte() {
        void p1;
        void this_$iv;
        MemoryReadable memoryReadable = this;
        int size$iv = 1;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        int n = this_$iv.getPosition();
        ReadMemory p0 = this_$iv.memory;
        boolean bl = false;
        byte value$iv = p0.getByte((int)p1);
        this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        return value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShort() {
        void p1;
        void this_$iv;
        MemoryReadable memoryReadable = this;
        int size$iv = 2;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        int n = this_$iv.getPosition();
        ReadMemory p0 = this_$iv.memory;
        boolean bl = false;
        short value$iv = p0.getShort((int)p1);
        this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        return value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        void p1;
        void this_$iv;
        MemoryReadable memoryReadable = this;
        int size$iv = 4;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        int n = this_$iv.getPosition();
        ReadMemory p0 = this_$iv.memory;
        boolean bl = false;
        int value$iv = p0.getInt((int)p1);
        this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        return value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLong() {
        void p1;
        void this_$iv;
        MemoryReadable memoryReadable = this;
        int size$iv = 8;
        boolean $i$f$readValue = false;
        this_$iv.requestCanRead(size$iv);
        int n = this_$iv.getPosition();
        ReadMemory p0 = this_$iv.memory;
        boolean bl = false;
        long value$iv = p0.getLong((int)p1);
        this_$iv.setPosition(this_$iv.getPosition() + size$iv);
        return value$iv;
    }

    @Override
    public void readBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.requestCanRead(length);
        this.memory.getBytes(this.getPosition(), dst, dstOffset, length);
        this.setPosition(this.getPosition() + length);
    }

    @Override
    public void skip(int count) {
        this.requestCanRead(count);
        this.setPosition(this.getPosition() + count);
    }

    @Override
    public int skipAtMost(int count) {
        if (!this.valid()) {
            return 0;
        }
        int skipCount = Math.min(count, this.getRemaining());
        this.setPosition(this.getPosition() + skipCount);
        return skipCount;
    }
}

