/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.CursorWriteable;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.Readable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"H\u0016J\"\u0010#\u001a\u00020\b2\u0014\b\u0004\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0%H\u0086\b\u00f8\u0001\u0000J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020'H\u0016JI\u0010(\u001a\u00020\u000f\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010\u0017\u001a\u0002H)2#\u0010+\u001a\u001f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u000f0,\u00a2\u0006\u0002\b-H\u0082\b\u00a2\u0006\u0002\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Lorg/kodein/memory/io/MemoryWriteable;", "Lorg/kodein/memory/io/CursorWriteable;", "memory", "Lorg/kodein/memory/io/Memory;", "(Lorg/kodein/memory/io/Memory;)V", "getMemory", "()Lorg/kodein/memory/io/Memory;", "<set-?>", "", "position", "getPosition", "()I", "remaining", "getRemaining", "flush", "", "requestCanWrite", "needed", "skip", "count", "toString", "", "writeByte", "value", "", "writeBytes", "src", "", "srcOffset", "length", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "writeInt", "writeLong", "", "writeMemory", "block", "Lkotlin/Function1;", "writeShort", "", "writeValue", "T", "size", "putValue", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "(ILjava/lang/Object;Lkotlin/jvm/functions/Function3;)V", "klio"})
public final class MemoryWriteable
implements CursorWriteable {
    @NotNull
    private final Memory memory;
    private int position;

    public MemoryWriteable(@NotNull Memory memory) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        this.memory = memory;
    }

    @NotNull
    public final Memory getMemory() {
        return this.memory;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getRemaining() {
        return this.memory.getSize() - this.getPosition();
    }

    public final int writeMemory(@NotNull Function1<? super Memory, Integer> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$writeMemory = false;
        Memory slice = MemoryKt.sliceAt(this.getMemory(), this.getPosition());
        int count = ((Number)block.invoke((Object)slice)).intValue();
        if (count > 0) {
            this.skip(count);
        }
        return count;
    }

    @Override
    public void requestCanWrite(int needed) {
        if (needed > this.getRemaining()) {
            throw new IOException("Needed at least " + needed + " remaining bytes, but has only " + this.getRemaining() + " bytes.");
        }
    }

    private final <T> void writeValue(int size, T value, Function3<? super Memory, ? super Integer, ? super T, Unit> putValue) {
        boolean $i$f$writeValue = false;
        putValue.invoke((Object)this.memory, (Object)this.getPosition(), value);
        this.position = this.getPosition() + size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeByte(byte value) {
        void size$iv;
        void p2;
        void p1;
        void this_$iv;
        MemoryWriteable memoryWriteable = this;
        boolean bl = true;
        byte value$iv = value;
        boolean $i$f$writeValue = false;
        byte by = value$iv;
        int n = this_$iv.getPosition();
        Memory p0 = this_$iv.memory;
        boolean bl2 = false;
        p0.putByte((int)p1, (byte)p2);
        this_$iv.position = this_$iv.getPosition() + size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeShort(short value) {
        void size$iv;
        void p2;
        void p1;
        void this_$iv;
        MemoryWriteable memoryWriteable = this;
        int n = 2;
        short value$iv = value;
        boolean $i$f$writeValue = false;
        short s = value$iv;
        int n2 = this_$iv.getPosition();
        Memory p0 = this_$iv.memory;
        boolean bl = false;
        p0.putShort((int)p1, (short)p2);
        this_$iv.position = this_$iv.getPosition() + size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeInt(int value) {
        void size$iv;
        void p2;
        void p1;
        void this_$iv;
        MemoryWriteable memoryWriteable = this;
        int n = 4;
        int value$iv = value;
        boolean $i$f$writeValue = false;
        int n2 = value$iv;
        int n3 = this_$iv.getPosition();
        Memory p0 = this_$iv.memory;
        boolean bl = false;
        p0.putInt((int)p1, (int)p2);
        this_$iv.position = this_$iv.getPosition() + size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLong(long value) {
        void size$iv;
        void p2;
        void p1;
        void this_$iv;
        MemoryWriteable memoryWriteable = this;
        int n = 8;
        long value$iv = value;
        boolean $i$f$writeValue = false;
        long l = value$iv;
        int n2 = this_$iv.getPosition();
        Memory p0 = this_$iv.memory;
        boolean bl = false;
        p0.putLong((int)p1, (long)p2);
        this_$iv.position = this_$iv.getPosition() + size$iv;
    }

    @Override
    public void writeBytes(@NotNull byte[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.memory.putBytes(this.getPosition(), src, srcOffset, length);
        this.position = this.getPosition() + length;
    }

    @Override
    public void writeBytes(@NotNull ReadMemory src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.memory.putBytes(this.getPosition(), src);
        this.position = this.getPosition() + src.getSize();
    }

    @Override
    public void writeBytes(@NotNull Readable src, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.memory.putBytes(this.getPosition(), src, length);
        this.position = this.getPosition() + length;
    }

    @Override
    public void flush() {
    }

    @Override
    public void skip(int count) {
        if (!(count >= 0)) {
            boolean bl = false;
            String string = "count: " + count + " < 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.requestCanWrite(count);
        this.position = this.getPosition() + count;
    }

    @NotNull
    public String toString() {
        return "MemoryWriteable(memory=" + this.memory + ", position=" + this.getPosition() + ')';
    }
}

