/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.ByteBuffersKt;
import org.kodein.memory.io.DirectByteBufferMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.ReadableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J;\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\u000b2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H 0#\u00a2\u0006\u0002\b$H\u0082\b\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0016J\b\u0010+\u001a\u00020\u000bH\u0016J \u0010,\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020-H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/kodein/memory/io/NioByteChannelReadable;", "Lorg/kodein/memory/io/Readable;", "Ljava/io/Closeable;", "Lorg/kodein/memory/Closeable;", "channel", "Ljava/nio/channels/ReadableByteChannel;", "(Ljava/nio/channels/ReadableByteChannel;)V", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "bytesRead", "", "position", "getPosition", "()I", "valid", "", "close", "", "readByte", "", "readBytes", "dst", "", "dstOffset", "length", "readInt", "readLong", "", "readShort", "", "readValue", "T", "size", "getValue", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "requestCanRead", "needed", "skip", "count", "skipAtMost", "tryReadByte", "tryReadBytes", "Lorg/kodein/memory/io/Memory;", "klio"})
public class NioByteChannelReadable
implements Readable,
Closeable {
    @NotNull
    private final ReadableByteChannel channel;
    private boolean valid;
    private ByteBuffer buffer;
    private int bytesRead;
    private final int position;

    public NioByteChannelReadable(@NotNull ReadableByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.valid = true;
        this.buffer = ByteBuffer.allocate(8);
        this.position = this.bytesRead;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void requestCanRead(int needed) {
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    @Override
    public int tryReadByte() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        ByteBuffersKt.setJPosition(byteBuffer, 0);
        ByteBuffer byteBuffer2 = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
        ByteBuffersKt.setJLimit(byteBuffer2, 1);
        int r = this.channel.read(this.buffer);
        if (r == -1) {
            this.valid = false;
            return -1;
        }
        ++this.bytesRead;
        return this.buffer.get(0);
    }

    @Override
    public int tryReadBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(dstOffset >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dstOffset + length <= dst.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer arrayBuffer = ByteBuffer.wrap(dst, dstOffset, length);
        int r = this.channel.read(arrayBuffer);
        if (r == -1) {
            this.valid = false;
            return -1;
        }
        this.bytesRead += r;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public int tryReadBytes(@NotNull Memory dst) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Object dstMemory = dst.internalMemory();
        ByteBuffer byteBuffer2 = dstMemory instanceof ByteArrayMemory ? ByteBuffer.wrap(((ByteArrayMemory)dstMemory).getArray(), ((ByteArrayMemory)dstMemory).getOffset(), dstMemory.getSize()) : (byteBuffer = dstMemory instanceof DirectByteBufferMemory ? ((DirectByteBufferMemory)dstMemory).getByteBuffer() : null);
        if (byteBuffer != null) {
            int n;
            int p1$iv;
            void $this$tmp$iv$iv;
            void $this$withPosition$iv;
            dstMemory = byteBuffer;
            boolean newPosition$iv = false;
            boolean $i$f$withPosition = false;
            void var6_7 = $this$withPosition$iv;
            KMutableProperty1 kMutableProperty1 = (KMutableProperty1)ByteBuffersKt.withPosition.2.INSTANCE;
            KMutableProperty1 kMutableProperty12 = (KMutableProperty1)ByteBuffersKt.withPosition.4.INSTANCE;
            boolean $i$f$tmp = false;
            Buffer p0$iv = (Buffer)$this$tmp$iv$iv;
            boolean bl = false;
            int old$iv$iv = ((Number)kMutableProperty1.get((Object)p0$iv)).intValue();
            if (old$iv$iv == 0) {
                boolean bl2 = false;
                int r = this.channel.read(byteBuffer);
                if (r == -1) {
                    this.valid = false;
                } else {
                    this.bytesRead += r;
                }
                return r;
            }
            bl = newPosition$iv;
            p0$iv = (Buffer)$this$tmp$iv$iv;
            boolean bl3 = false;
            kMutableProperty12.set((Object)p0$iv, (Object)p1$iv);
            try {
                boolean bl4 = false;
                int r = this.channel.read(byteBuffer);
                if (r == -1) {
                    this.valid = false;
                } else {
                    this.bytesRead += r;
                }
                n = r;
                p1$iv = old$iv$iv;
            }
            catch (Throwable throwable) {
                p1$iv = old$iv$iv;
                p0$iv = (Buffer)$this$tmp$iv$iv;
                bl3 = false;
                kMutableProperty12.set((Object)p0$iv, (Object)p1$iv);
                throw throwable;
            }
            p0$iv = (Buffer)$this$tmp$iv$iv;
            kMutableProperty12.set((Object)p0$iv, (Object)p1$iv);
            return n;
        }
        byte[] buffer = new byte[dst.getSize()];
        int r = ReadableKt.tryReadBytes(this, buffer);
        if (r == -1) {
            dst.putBytes(0, buffer, 0, r);
        }
        return r;
    }

    @Override
    public byte readByte() {
        int b = this.tryReadByte();
        if (b == -1) {
            throw new IOException("Channel is over.");
        }
        return (byte)b;
    }

    private final <T> T readValue(int size, Function2<? super ByteBuffer, ? super Integer, ? extends T> getValue) {
        boolean $i$f$readValue = false;
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        ByteBuffersKt.setJPosition(byteBuffer, 0);
        ByteBuffer byteBuffer2 = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
        ByteBuffersKt.setJLimit(byteBuffer2, size);
        int n = this.channel.read(this.buffer);
        this.bytesRead += n;
        if (n != size) {
            throw new IOException("Channel is over. Needed " + size + " bytes, but only got " + n + '.');
        }
        ByteBuffer byteBuffer3 = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"buffer");
        return (T)getValue.invoke((Object)byteBuffer3, (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short readShort() {
        void p1;
        void this_$iv;
        NioByteChannelReadable nioByteChannelReadable = this;
        int size$iv = 2;
        boolean $i$f$readValue = false;
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        ByteBuffersKt.setJPosition(byteBuffer, 0);
        ByteBuffer byteBuffer2 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
        ByteBuffersKt.setJLimit(byteBuffer2, size$iv);
        int n$iv = this_$iv.channel.read(this_$iv.buffer);
        this_$iv.bytesRead += n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Channel is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        ByteBuffer byteBuffer3 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"buffer");
        boolean bl = false;
        ByteBuffer p0 = byteBuffer3;
        boolean bl2 = false;
        return p0.getShort((int)p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        void p1;
        void this_$iv;
        NioByteChannelReadable nioByteChannelReadable = this;
        int size$iv = 4;
        boolean $i$f$readValue = false;
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        ByteBuffersKt.setJPosition(byteBuffer, 0);
        ByteBuffer byteBuffer2 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
        ByteBuffersKt.setJLimit(byteBuffer2, size$iv);
        int n$iv = this_$iv.channel.read(this_$iv.buffer);
        this_$iv.bytesRead += n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Channel is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        ByteBuffer byteBuffer3 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"buffer");
        boolean bl = false;
        ByteBuffer p0 = byteBuffer3;
        boolean bl2 = false;
        return p0.getInt((int)p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLong() {
        void p1;
        void this_$iv;
        NioByteChannelReadable nioByteChannelReadable = this;
        int size$iv = 8;
        boolean $i$f$readValue = false;
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        ByteBuffersKt.setJPosition(byteBuffer, 0);
        ByteBuffer byteBuffer2 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
        ByteBuffersKt.setJLimit(byteBuffer2, size$iv);
        int n$iv = this_$iv.channel.read(this_$iv.buffer);
        this_$iv.bytesRead += n$iv;
        if (n$iv != size$iv) {
            throw new IOException("Channel is over. Needed " + size$iv + " bytes, but only got " + n$iv + '.');
        }
        ByteBuffer byteBuffer3 = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"buffer");
        boolean bl = false;
        ByteBuffer p0 = byteBuffer3;
        boolean bl2 = false;
        return p0.getLong((int)p1);
    }

    @Override
    public void readBytes(@NotNull byte[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(dstOffset >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dstOffset + length <= dst.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(dst, dstOffset, length);
        int read = 0;
        while (byteBuffer.hasRemaining()) {
            int r = this.channel.read(byteBuffer);
            if (r == -1) {
                throw new IOException("Stream is over. Needed " + length + " bytes, but only got " + read + '.');
            }
            read += r;
            this.bytesRead += r;
        }
    }

    @Override
    public void skip(int count) {
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int skipped = this.skipAtMost(count);
        if (skipped != count) {
            throw new IOException("Could not skip " + count + " bytes, only " + skipped + " bytes.");
        }
    }

    @Override
    public int skipAtMost(int count) {
        int skipped;
        int r;
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, count));
        for (skipped = 0; skipped < count; skipped += r) {
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            ByteBuffersKt.setJPosition(buffer, 0);
            ByteBuffersKt.setJLimit(buffer, Math.min(buffer.capacity(), count - skipped));
            r = this.channel.read(buffer);
            if (r == -1) break;
            this.bytesRead += r;
        }
        return skipped;
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

