/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.ByteBuffersKt;
import org.kodein.memory.io.DirectByteBufferMemory;
import org.kodein.memory.io.MemoryReadable;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.io.WriteableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\"H\u0016JC\u0010#\u001a\u00020\u0010\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u0002H$2\u001d\u0010&\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\u00100'\u00a2\u0006\u0002\b(H\u0082\b\u00a2\u0006\u0002\u0010)R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/kodein/memory/io/NioByteChannelWriteable;", "Lorg/kodein/memory/io/Writeable;", "Ljava/io/Closeable;", "Lorg/kodein/memory/Closeable;", "channel", "Ljava/nio/channels/WritableByteChannel;", "(Ljava/nio/channels/WritableByteChannel;)V", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "bytesWritten", "", "position", "getPosition", "()I", "close", "", "flush", "requestCanWrite", "needed", "writeByte", "value", "", "writeBytes", "src", "", "srcOffset", "length", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "writeInt", "writeLong", "", "writeShort", "", "writeValue", "T", "size", "putValue", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(ILjava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "klio"})
public class NioByteChannelWriteable
implements Writeable,
Closeable {
    @NotNull
    private final WritableByteChannel channel;
    private ByteBuffer buffer;
    private int bytesWritten;
    private final int position;

    public NioByteChannelWriteable(@NotNull WritableByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(8);
        this.position = this.bytesWritten;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void requestCanWrite(int needed) {
    }

    private final <T> void writeValue(int size, T value, Function2<? super ByteBuffer, ? super T, Unit> putValue) {
        boolean $i$f$writeValue = false;
        this.buffer.clear();
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        putValue.invoke((Object)byteBuffer, value);
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.bytesWritten += size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeByte(byte value) {
        void size$iv;
        void p1;
        void this_$iv;
        NioByteChannelWriteable nioByteChannelWriteable = this;
        boolean bl = true;
        byte value$iv = value;
        boolean $i$f$writeValue = false;
        this_$iv.buffer.clear();
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        byte by = value$iv;
        ByteBuffer p0 = byteBuffer;
        boolean bl2 = false;
        p0.put((byte)p1);
        this_$iv.buffer.flip();
        this_$iv.channel.write(this_$iv.buffer);
        this_$iv.bytesWritten += size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeShort(short value) {
        void size$iv;
        void p1;
        void this_$iv;
        NioByteChannelWriteable nioByteChannelWriteable = this;
        int n = 2;
        short value$iv = value;
        boolean $i$f$writeValue = false;
        this_$iv.buffer.clear();
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        short s = value$iv;
        ByteBuffer p0 = byteBuffer;
        boolean bl = false;
        p0.putShort((short)p1);
        this_$iv.buffer.flip();
        this_$iv.channel.write(this_$iv.buffer);
        this_$iv.bytesWritten += size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeInt(int value) {
        void size$iv;
        void p1;
        void this_$iv;
        NioByteChannelWriteable nioByteChannelWriteable = this;
        int n = 4;
        int value$iv = value;
        boolean $i$f$writeValue = false;
        this_$iv.buffer.clear();
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        int n2 = value$iv;
        ByteBuffer p0 = byteBuffer;
        boolean bl = false;
        p0.putInt((int)p1);
        this_$iv.buffer.flip();
        this_$iv.channel.write(this_$iv.buffer);
        this_$iv.bytesWritten += size$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeLong(long value) {
        void size$iv;
        void p1;
        void this_$iv;
        NioByteChannelWriteable nioByteChannelWriteable = this;
        int n = 8;
        long value$iv = value;
        boolean $i$f$writeValue = false;
        this_$iv.buffer.clear();
        ByteBuffer byteBuffer = this_$iv.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        long l = value$iv;
        ByteBuffer p0 = byteBuffer;
        boolean bl = false;
        p0.putLong((long)p1);
        this_$iv.buffer.flip();
        this_$iv.channel.write(this_$iv.buffer);
        this_$iv.bytesWritten += size$iv;
    }

    @Override
    public void writeBytes(@NotNull byte[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.channel.write(ByteBuffer.wrap(src, srcOffset, length));
        this.bytesWritten += src.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void writeBytes(@NotNull ReadMemory src) {
        void $this$tmp$iv$iv;
        void $this$withPosition$iv;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Object srcMemory = src.internalMemory();
        ByteBuffer byteBuffer = srcMemory instanceof ByteArrayMemory ? ByteBuffer.wrap(((ByteArrayMemory)srcMemory).getArray(), ((ByteArrayMemory)srcMemory).getOffset(), srcMemory.getSize()) : (srcMemory instanceof DirectByteBufferMemory ? ((DirectByteBufferMemory)srcMemory).getByteBuffer() : ByteBuffer.wrap(ReadMemoryKt.getBytes(src)));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        srcMemory = byteBuffer;
        boolean newPosition$iv = false;
        boolean $i$f$withPosition = false;
        void var6_6 = $this$withPosition$iv;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)ByteBuffersKt.withPosition.2.INSTANCE;
        KMutableProperty1 kMutableProperty12 = (KMutableProperty1)ByteBuffersKt.withPosition.4.INSTANCE;
        boolean $i$f$tmp = false;
        Buffer p0$iv = (Buffer)$this$tmp$iv$iv;
        boolean bl = false;
        int old$iv$iv = ((Number)kMutableProperty1.get((Object)p0$iv)).intValue();
        if (old$iv$iv == 0) {
            boolean bl2 = false;
            this.channel.write(byteBuffer);
        } else {
            int p1$iv;
            bl = newPosition$iv;
            p0$iv = (Buffer)$this$tmp$iv$iv;
            boolean bl3 = false;
            kMutableProperty12.set((Object)p0$iv, (Object)p1$iv);
            try {
                boolean bl4 = false;
                int n = this.channel.write(byteBuffer);
            }
            finally {
                p1$iv = old$iv$iv;
                p0$iv = (Buffer)$this$tmp$iv$iv;
                bl3 = false;
                kMutableProperty12.set((Object)p0$iv, (Object)p1$iv);
            }
        }
    }

    @Override
    public void writeBytes(@NotNull Readable src, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (src instanceof MemoryReadable) {
            this.writeBytes(((MemoryReadable)src).readSlice(length));
        } else {
            WriteableKt.writeBytesBuffered$default(this, src, length, 0, 4, null);
        }
    }

    @Override
    public void flush() {
        if (this.channel instanceof FileChannel) {
            ((FileChannel)this.channel).force(true);
        }
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

