/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.NioByteChannelReadable;
import org.kodein.memory.io.SeekableCursorReadable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/kodein/memory/io/NioSeekableByteChannelReadable;", "Lorg/kodein/memory/io/NioByteChannelReadable;", "Lorg/kodein/memory/io/SeekableCursorReadable;", "channel", "Ljava/nio/channels/SeekableByteChannel;", "(Ljava/nio/channels/SeekableByteChannel;)V", "value", "", "position", "getPosition", "()I", "setPosition", "(I)V", "remaining", "getRemaining", "size", "getSize", "requestCanRead", "", "needed", "klio"})
public final class NioSeekableByteChannelReadable
extends NioByteChannelReadable
implements SeekableCursorReadable {
    @NotNull
    private final SeekableByteChannel channel;
    private final int remaining;

    public NioSeekableByteChannelReadable(@NotNull SeekableByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(channel);
        this.channel = channel;
        this.remaining = (int)this.channel.size() - this.getPosition();
    }

    @Override
    public int getPosition() {
        return (int)this.channel.position();
    }

    @Override
    public void setPosition(int value) {
        if (!((long)value <= this.channel.size())) {
            boolean bl = false;
            String string = "Position " + value + " is out of file (size: " + this.channel.size() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        this.channel.position(value);
    }

    @Override
    public int getSize() {
        return (int)this.channel.size();
    }

    @Override
    public int getRemaining() {
        return this.remaining;
    }

    @Override
    public void requestCanRead(int needed) {
        if (needed > this.getRemaining()) {
            throw new IOException("End of channel reached: needed " + needed + " bytes, but has only " + this.getRemaining() + " remaining bytes.");
        }
    }
}

