/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.MemoryReadable;
import org.kodein.memory.io.OutputStreamWriteable;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.io.WriteableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001fH\u0016JO\u0010 \u001a\u00020\r\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0012\u001a\u0002H!2*\u0010#\u001a&\u0012\u0004\u0012\u0002H!\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0$\u0012\u0004\u0012\u00020\r0$H\u0002\u00a2\u0006\u0002\u0010%R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/kodein/memory/io/OutputStreamWriteable;", "Lorg/kodein/memory/io/Writeable;", "Ljava/io/Closeable;", "Lorg/kodein/memory/Closeable;", "stream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "<set-?>", "", "position", "getPosition", "()I", "close", "", "flush", "requestCanWrite", "needed", "writeByte", "value", "", "writeBytes", "src", "", "srcOffset", "length", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "writeInt", "writeLong", "", "writeShort", "", "writeValue", "T", "size", "store", "Lkotlin/Function2;", "(ILjava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "klio"})
public final class OutputStreamWriteable
implements Writeable,
Closeable {
    @NotNull
    private final OutputStream stream;
    private int position;

    public OutputStreamWriteable(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void requestCanWrite(int needed) {
    }

    @Override
    public void writeByte(byte value) {
        this.stream.write(value);
        this.position = this.getPosition() + 1;
    }

    private final <T> void writeValue(int size, T value, Function2<? super T, ? super Function2<? super Integer, ? super Byte, Unit>, Unit> store) {
        store.invoke(value, (Object)new Function2<Integer, Byte, Unit>(this){
            final /* synthetic */ OutputStreamWriteable this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(int n, byte b) {
                OutputStreamWriteable.access$getStream$p(this.this$0).write(b);
            }
        });
        this.position = this.getPosition() + size;
    }

    @Override
    public void writeShort(short value) {
        this.writeValue(2, value, writeShort.1.INSTANCE);
    }

    @Override
    public void writeInt(int value) {
        this.writeValue(4, value, writeInt.1.INSTANCE);
    }

    @Override
    public void writeLong(long value) {
        this.writeValue(8, value, writeLong.1.INSTANCE);
    }

    @Override
    public void writeBytes(@NotNull byte[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.stream.write(src, srcOffset, length);
        this.position = this.getPosition() + length;
    }

    @Override
    public void writeBytes(@NotNull ReadMemory src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        ReadMemory srcMemory = src.internalMemory();
        if (srcMemory instanceof ByteArrayMemory) {
            this.stream.write(((ByteArrayMemory)srcMemory).getArray(), ((ByteArrayMemory)srcMemory).getOffset(), srcMemory.getSize());
        } else {
            byte[] buffer = ReadMemoryKt.getBytes(src);
            this.stream.write(buffer);
        }
        this.position = this.getPosition() + src.getSize();
    }

    @Override
    public void writeBytes(@NotNull Readable src, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (src instanceof MemoryReadable) {
            this.writeBytes(((MemoryReadable)src).readSlice(length));
        } else {
            WriteableKt.writeBytesBuffered$default(this, src, length, 0, 4, null);
        }
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public static final /* synthetic */ OutputStream access$getStream$p(OutputStreamWriteable $this) {
        return $this.stream;
    }
}

