/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.CursorReadable;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.ReadableKt;
import org.kodein.memory.io.SeekableCursorReadable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kodein/memory/io/ReadableInputStream;", "Ljava/io/InputStream;", "readable", "Lorg/kodein/memory/io/Readable;", "(Lorg/kodein/memory/io/Readable;)V", "mark", "", "available", "close", "", "readlimit", "markSupported", "", "read", "b", "", "off", "len", "reset", "skip", "", "n", "klio"})
public final class ReadableInputStream
extends InputStream {
    @NotNull
    private final Readable readable;
    private int mark;

    public ReadableInputStream(@NotNull Readable readable) {
        Intrinsics.checkNotNullParameter((Object)readable, (String)"readable");
        this.readable = readable;
        this.mark = -1;
    }

    @Override
    public int available() {
        return this.readable.valid() ? 1 : 0;
    }

    @Override
    public int read() {
        return this.readable.valid() ? (int)this.readable.readByte() : -1;
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return ReadableKt.tryReadBytes(this.readable, b);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.readable.tryReadBytes(b, off, len);
    }

    @Override
    public long skip(long n) {
        return this.readable.skipAtMost((int)n);
    }

    @Override
    public boolean markSupported() {
        return this.readable instanceof CursorReadable;
    }

    @Override
    public void mark(int readlimit) {
        if (!(this.readable instanceof SeekableCursorReadable)) {
            throw new IOException("Mark is not supported on " + Reflection.getOrCreateKotlinClass(this.readable.getClass()).getSimpleName() + '.');
        }
        this.mark = ((SeekableCursorReadable)this.readable).getPosition();
    }

    @Override
    public void reset() {
        if (!(this.readable instanceof SeekableCursorReadable)) {
            throw new IOException("Mark is not supported on " + Reflection.getOrCreateKotlinClass(this.readable.getClass()).getSimpleName() + '.');
        }
        if (this.mark == -1) {
            throw new IOException("Mark has not been set");
        }
        ((SeekableCursorReadable)this.readable).setPosition(this.mark);
    }

    @Override
    public void close() {
        if (this.readable instanceof Closeable) {
            ((Closeable)((Object)this.readable)).close();
        }
    }
}

