/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteBuffersKt;
import org.kodein.memory.io.Readable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kodein/memory/io/ReadableNioByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "readable", "Lorg/kodein/memory/io/Readable;", "transientClose", "", "(Lorg/kodein/memory/io/Readable;Z)V", "isOpen", "close", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "klio"})
public final class ReadableNioByteChannel
implements ReadableByteChannel {
    @NotNull
    private final Readable readable;
    private final boolean transientClose;
    private boolean isOpen;

    public ReadableNioByteChannel(@NotNull Readable readable, boolean transientClose) {
        Intrinsics.checkNotNullParameter((Object)readable, (String)"readable");
        this.readable = readable;
        this.transientClose = transientClose;
        this.isOpen = true;
    }

    public /* synthetic */ ReadableNioByteChannel(Readable readable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(readable, bl);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ByteBuffer byteBuffer = dst.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"dst.slice()");
        int read = this.readable.tryReadBytes(ByteBuffersKt.ByteBufferMemory(byteBuffer));
        ByteBuffersKt.setJPosition(dst, ByteBuffersKt.getJPosition(dst) + read);
        return read;
    }

    @Override
    public void close() {
        if (this.transientClose && this.readable instanceof Closeable && this.isOpen) {
            this.isOpen = false;
            ((Closeable)((Object)this.readable)).close();
        }
    }
}

