/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteBuffersKt;
import org.kodein.memory.io.Writeable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kodein/memory/io/WriteableNioByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "writeable", "Lorg/kodein/memory/io/Writeable;", "transientClose", "", "(Lorg/kodein/memory/io/Writeable;Z)V", "isOpen", "close", "", "write", "", "src", "Ljava/nio/ByteBuffer;", "klio"})
public final class WriteableNioByteChannel
implements WritableByteChannel {
    @NotNull
    private final Writeable writeable;
    private final boolean transientClose;
    private boolean isOpen;

    public WriteableNioByteChannel(@NotNull Writeable writeable, boolean transientClose) {
        Intrinsics.checkNotNullParameter((Object)writeable, (String)"writeable");
        this.writeable = writeable;
        this.transientClose = transientClose;
        this.isOpen = true;
    }

    public /* synthetic */ WriteableNioByteChannel(Writeable writeable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(writeable, bl);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public int write(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        ByteBuffer slice = src.slice();
        int count = slice.remaining();
        ByteBuffer byteBuffer = src.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"src.slice()");
        this.writeable.writeBytes(ByteBuffersKt.ByteBufferMemory(byteBuffer));
        ByteBuffersKt.setJPosition(src, ByteBuffersKt.getJPosition(src) + count);
        return count;
    }

    @Override
    public void close() {
        if (this.transientClose && this.writeable instanceof Closeable && this.isOpen) {
            this.isOpen = false;
            ((Closeable)((Object)this.writeable)).close();
        }
    }
}

