/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.io;

import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.io.WriteableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kodein/memory/io/WriteableOutputStream;", "Ljava/io/OutputStream;", "writeable", "Lorg/kodein/memory/io/Writeable;", "(Lorg/kodein/memory/io/Writeable;)V", "close", "", "write", "b", "", "off", "", "len", "klio"})
public final class WriteableOutputStream
extends OutputStream {
    @NotNull
    private final Writeable writeable;

    public WriteableOutputStream(@NotNull Writeable writeable) {
        Intrinsics.checkNotNullParameter((Object)writeable, (String)"writeable");
        this.writeable = writeable;
    }

    @Override
    public void write(int b) {
        this.writeable.writeByte((byte)b);
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        WriteableKt.writeBytes(this.writeable, b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.writeable.writeBytes(b, off, len);
    }

    @Override
    public void close() {
        if (this.writeable instanceof Closeable) {
            ((Closeable)((Object)this.writeable)).close();
        }
    }
}

