/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.system;

import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/kodein/memory/system/Environment;", "", "()V", "allVariables", "", "", "findVariable", "name", "getVariable", "klio"})
public final class Environment {
    @NotNull
    public static final Environment INSTANCE = new Environment();

    private Environment() {
    }

    @NotNull
    public final String getVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = System.getenv(name);
        if (string == null) {
            throw new NoSuchElementException("No environment variable " + name);
        }
        return string;
    }

    @Nullable
    public final String findVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return System.getenv(name);
    }

    @NotNull
    public final Map<String, String> allVariables() {
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        return map;
    }
}

