/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.text;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.CursorReadable;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.MemoryReadable;
import org.kodein.memory.io.MemoryReadableKt;
import org.kodein.memory.io.MemoryWriteableKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.io.WriteableKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R\u0014\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0002R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\n\u00a8\u0006!"}, d2={"Lorg/kodein/memory/text/Base64;", "", "()V", "decoder", "Lorg/kodein/memory/text/Base64$Decoder;", "getDecoder", "()Lorg/kodein/memory/text/Base64$Decoder;", "encoder", "Lorg/kodein/memory/text/Base64$Encoder;", "getEncoder", "()Lorg/kodein/memory/text/Base64$Encoder;", "fromBase64", "", "fromBase64URL", "mimeDecoder", "getMimeDecoder", "mimeEncoder", "getMimeEncoder", "toBase64", "", "getToBase64$annotations", "toBase64URL", "getToBase64URL$annotations", "urlDecoder", "getUrlDecoder", "urlEncoder", "getUrlEncoder", "lineLength", "", "lineSeparator", "", "Decoder", "Encoder", "klio"})
public final class Base64 {
    @NotNull
    public static final Base64 INSTANCE;
    @NotNull
    private static final char[] toBase64;
    @NotNull
    private static final char[] toBase64URL;
    @NotNull
    private static final int[] fromBase64;
    @NotNull
    private static final int[] fromBase64URL;

    private Base64() {
    }

    private static /* synthetic */ void getToBase64$annotations() {
    }

    private static /* synthetic */ void getToBase64URL$annotations() {
    }

    @NotNull
    public final Encoder getEncoder() {
        return Encoder.Companion.getRFC4648$klio();
    }

    @NotNull
    public final Encoder getUrlEncoder() {
        return Encoder.Companion.getRFC4648_URLSAFE$klio();
    }

    @NotNull
    public final Encoder getMimeEncoder() {
        return Encoder.Companion.getRFC2045$klio();
    }

    @NotNull
    public final Encoder mimeEncoder(int lineLength, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        int n = lineSeparator.length();
        for (int i = 0; i < n; ++i) {
            char b = lineSeparator.charAt(i);
            if (fromBase64[b & 0xFF] == -1) continue;
            StringBuilder stringBuilder = new StringBuilder().append("Illegal base64 line separator character 0x");
            String string = Integer.toString(b, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            throw new IllegalArgumentException(stringBuilder.append(string).toString());
        }
        return lineLength <= 0 ? Encoder.Companion.getRFC4648$klio() : new Encoder(false, lineSeparator, lineLength >> 2 << 2, true);
    }

    @NotNull
    public final Decoder getDecoder() {
        return Decoder.Companion.getRFC4648$klio();
    }

    @NotNull
    public final Decoder getUrlDecoder() {
        return Decoder.Companion.getRFC4648_URLSAFE$klio();
    }

    @NotNull
    public final Decoder getMimeDecoder() {
        return Decoder.Companion.getRFC2045$klio();
    }

    static {
        int i;
        int n;
        INSTANCE = new Base64();
        char[] cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        toBase64 = cArray;
        cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        toBase64URL = cArray;
        int n2 = 0;
        int[] nArray = new int[256];
        while (n2 < 256) {
            n = n2++;
            nArray[n] = -1;
        }
        fromBase64 = nArray;
        n2 = 0;
        nArray = new int[256];
        while (n2 < 256) {
            n = n2++;
            nArray[n] = -1;
        }
        fromBase64URL = nArray;
        int n3 = toBase64.length;
        for (i = 0; i < n3; ++i) {
            Base64.fromBase64[Base64.toBase64[i]] = i;
        }
        Base64.fromBase64[61] = -2;
        n3 = toBase64URL.length;
        for (i = 0; i < n3; ++i) {
            Base64.fromBase64URL[Base64.toBase64URL[i]] = i;
        }
        Base64.fromBase64URL[61] = -2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kodein/memory/text/Base64$Encoder;", "", "isURL", "", "newline", "", "linemax", "", "doPadding", "(ZLjava/lang/String;IZ)V", "encode", "src", "Lorg/kodein/memory/io/CursorReadable;", "Lorg/kodein/memory/io/Readable;", "length", "encodeInto", "dst", "Lorg/kodein/memory/io/Writeable;", "outLength", "srclen", "withoutPadding", "Companion", "klio"})
    public static final class Encoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isURL;
        @Nullable
        private final String newline;
        private final int linemax;
        private final boolean doPadding;
        private static final int MIMELINEMAX = 76;
        @NotNull
        private static final String CRLF = "\r\n";
        @NotNull
        private static final Encoder RFC4648 = new Encoder(false, null, -1, true);
        @NotNull
        private static final Encoder RFC4648_URLSAFE = new Encoder(true, null, -1, true);
        @NotNull
        private static final Encoder RFC2045 = new Encoder(false, CRLF, MIMELINEMAX, true);

        public Encoder(boolean isURL, @Nullable String newline, int linemax, boolean doPadding) {
            this.isURL = isURL;
            this.newline = newline;
            this.linemax = linemax;
            this.doPadding = doPadding;
        }

        public final int outLength(int srclen) {
            int len;
            int n;
            if (this.doPadding) {
                n = 4 * ((srclen + 2) / 3);
            } else {
                int n2 = srclen % 3;
                n = len = 4 * (srclen / 3) + (n2 == 0 ? 0 : n2 + 1);
            }
            if (this.linemax > 0 && this.newline != null) {
                return len + (len - 1) / this.linemax * this.newline.length();
            }
            return len;
        }

        @NotNull
        public final Encoder withoutPadding() {
            return !this.doPadding ? this : new Encoder(this.isURL, this.newline, this.linemax, false);
        }

        @NotNull
        public final String encode(@NotNull CursorReadable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return this.encode(src, src.getRemaining());
        }

        @NotNull
        public final String encode(@NotNull Readable src, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            byte[] dst = new byte[this.outLength(length)];
            int realLength = this.encodeInto(WriteableKt.asWriteable(dst), src, length);
            int n = 0;
            char[] cArray = new char[realLength];
            while (n < realLength) {
                int n2 = n++;
                cArray[n2] = (char)dst[n2];
            }
            return StringsKt.concatToString((char[])cArray);
        }

        public final int encodeInto(@NotNull Writeable dst, @NotNull CursorReadable src) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return this.encodeInto(dst, src, src.getRemaining());
        }

        public final int encodeInto(@NotNull Writeable dst, @NotNull Readable src, int length) {
            int sp0;
            int slen;
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            char[] base64 = this.isURL ? toBase64URL : toBase64;
            int sp = 0;
            int sl = slen = length / 3 * 3;
            if (this.linemax > 0 && slen > this.linemax / 4 * 3) {
                slen = this.linemax / 4 * 3;
            }
            int dp = 0;
            while (sp < sl) {
                int sl0 = Math.min(sp + slen, sl);
                for (sp0 = sp; sp0 < sl0; sp0 += 3) {
                    int bits = (src.readByte() & 0xFF) << 16 | (src.readByte() & 0xFF) << 8 | src.readByte() & 0xFF;
                    dst.writeByte((byte)base64[bits >>> 18 & 0x3F]);
                    dst.writeByte((byte)base64[bits >>> 12 & 0x3F]);
                    dst.writeByte((byte)base64[bits >>> 6 & 0x3F]);
                    dst.writeByte((byte)base64[bits & 0x3F]);
                }
                int dlen = (sl0 - sp) / 3 * 4;
                dp += dlen;
                sp = sl0;
                if (dlen != this.linemax || sp >= length || this.newline == null) continue;
                String string = this.newline;
                for (int i = 0; i < string.length(); ++i) {
                    char b = string.charAt(i);
                    dst.writeByte((byte)b);
                    ++dp;
                }
            }
            if (sp < length) {
                int b0 = src.readByte() & 0xFF;
                dst.writeByte((byte)base64[b0 >> 2]);
                ++dp;
                if (++sp == length) {
                    dst.writeByte((byte)base64[b0 << 4 & 0x3F]);
                    ++dp;
                    if (this.doPadding) {
                        sp0 = 2;
                        int n = 0;
                        while (n < sp0) {
                            int it = n++;
                            boolean bl = false;
                            dst.writeByte((byte)61);
                        }
                        dp += 2;
                    }
                } else {
                    int b1 = src.readByte() & 0xFF;
                    dst.writeByte((byte)base64[b0 << 4 & 0x3F | b1 >> 4]);
                    dst.writeByte((byte)base64[b1 << 2 & 0x3F]);
                    dp += 2;
                    if (this.doPadding) {
                        dst.writeByte((byte)61);
                        ++dp;
                    }
                }
            }
            return dp;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/kodein/memory/text/Base64$Encoder$Companion;", "", "()V", "CRLF", "", "MIMELINEMAX", "", "RFC2045", "Lorg/kodein/memory/text/Base64$Encoder;", "getRFC2045$klio", "()Lorg/kodein/memory/text/Base64$Encoder;", "RFC4648", "getRFC4648$klio", "RFC4648_URLSAFE", "getRFC4648_URLSAFE$klio", "klio"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Encoder getRFC4648$klio() {
                return RFC4648;
            }

            @NotNull
            public final Encoder getRFC4648_URLSAFE$klio() {
                return RFC4648_URLSAFE;
            }

            @NotNull
            public final Encoder getRFC2045$klio() {
                return RFC2045;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\nJ\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kodein/memory/text/Base64$Decoder;", "", "isURL", "", "isMIME", "(ZZ)V", "decode", "", "src", "", "Lorg/kodein/memory/io/CursorReadable;", "Lorg/kodein/memory/io/Readable;", "length", "", "decodeInto", "dst", "Lorg/kodein/memory/io/Writeable;", "outLength", "len", "Companion", "klio"})
    public static final class Decoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isURL;
        private final boolean isMIME;
        @NotNull
        private static final Decoder RFC4648 = new Decoder(false, false);
        @NotNull
        private static final Decoder RFC4648_URLSAFE = new Decoder(true, false);
        @NotNull
        private static final Decoder RFC2045 = new Decoder(false, true);

        public Decoder(boolean isURL, boolean isMIME) {
            this.isURL = isURL;
            this.isMIME = isMIME;
        }

        public final int outLength(@NotNull Readable src, int len) {
            int[] base64;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (len == 0) {
                return 0;
            }
            int[] nArray = base64 = this.isURL ? fromBase64URL : fromBase64;
            if (len < 2) {
                if (this.isMIME && base64[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            int slen = len;
            int paddings = 0;
            if (this.isMIME) {
                int n = 0;
                for (int sp = 0; sp < slen; ++sp) {
                    int b = src.readByte() & 0xFF;
                    if (b != 61) continue;
                    slen -= slen - sp + 1;
                    break;
                }
                slen -= n;
            } else {
                src.skip(len - 2);
                if (src.readByte() == (byte)61) {
                    ++paddings;
                }
                if (src.readByte() == (byte)61) {
                    ++paddings;
                }
            }
            if (paddings == 0 && (slen & 3) != 0) {
                paddings = 4 - (slen & 3);
            }
            return 3 * ((slen + 3) / 4) - paddings;
        }

        @NotNull
        public final byte[] decode(@NotNull String src) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            byte[] dst = new byte[src.length()];
            int len = this.decodeInto(WriteableKt.asWriteable(dst), src);
            if (len != dst.length) {
                byte[] byArray2 = Arrays.copyOf(dst, len);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                byArray = dst;
            }
            return byArray;
        }

        @NotNull
        public final byte[] decode(@NotNull CursorReadable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return this.decode(src, src.getRemaining());
        }

        @NotNull
        public final byte[] decode(@NotNull Readable src, int length) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            byte[] dst = new byte[length];
            int realLength = this.decodeInto(MemoryWriteableKt.asWriteable(MemoryKt.wrap(Memory.Companion, dst)), src, length);
            if (realLength != dst.length) {
                byte[] byArray2 = Arrays.copyOf(dst, realLength);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                byArray = dst;
            }
            return byArray;
        }

        public final int decodeInto(@NotNull Writeable dst, @NotNull String src) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            int n = 0;
            int n2 = src.length();
            byte[] byArray = new byte[n2];
            Memory.Companion companion = Memory.Companion;
            while (n < n2) {
                int n3 = n++;
                byArray[n3] = (byte)src.charAt(n3);
            }
            MemoryReadable input = MemoryReadableKt.asReadable(MemoryKt.wrap(companion, byArray));
            return this.decodeInto(dst, input, src.length());
        }

        public final int decodeInto(@NotNull Writeable dst, @NotNull CursorReadable src) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return this.decodeInto(dst, src, src.getRemaining());
        }

        public final int decodeInto(@NotNull Writeable dst, @NotNull Readable src, int length) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            int sp = 0;
            int[] base64 = this.isURL ? fromBase64URL : fromBase64;
            int dp = 0;
            int bits = 0;
            int shiftto = 18;
            while (sp < length) {
                int c = src.readByte() & 0xFF;
                ++sp;
                int b = base64[c];
                if (b < 0) {
                    if (b == -2) {
                        if (shiftto == 6 && (sp == length || src.readByte() != (byte)61) || shiftto == 18) {
                            throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                        }
                        ++sp;
                        break;
                    }
                    if (this.isMIME) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Illegal base64 character ");
                    String string = Integer.toString(c, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                    throw new IllegalArgumentException(stringBuilder.append(string).toString());
                }
                bits |= b << shiftto;
                if ((shiftto -= 6) >= 0) continue;
                dst.writeByte((byte)(bits >> 16));
                dst.writeByte((byte)(bits >> 8));
                dst.writeByte((byte)bits);
                dp += 3;
                shiftto = 18;
                bits = 0;
            }
            switch (shiftto) {
                case 6: {
                    dst.writeByte((byte)(bits >> 16));
                    ++dp;
                    break;
                }
                case 0: {
                    dst.writeByte((byte)(bits >> 16));
                    dst.writeByte((byte)(bits >> 8));
                    dp += 2;
                    break;
                }
                case 12: {
                    throw new IllegalArgumentException("Last unit does not have enough valid bits");
                }
            }
            while (sp < length) {
                if (this.isMIME && base64[src.readByte()] < 0) {
                    ++sp;
                    continue;
                }
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + ++sp);
            }
            return dp;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/kodein/memory/text/Base64$Decoder$Companion;", "", "()V", "RFC2045", "Lorg/kodein/memory/text/Base64$Decoder;", "getRFC2045$klio", "()Lorg/kodein/memory/text/Base64$Decoder;", "RFC4648", "getRFC4648$klio", "RFC4648_URLSAFE", "getRFC4648_URLSAFE$klio", "klio"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Decoder getRFC4648$klio() {
                return RFC4648;
            }

            @NotNull
            public final Decoder getRFC4648_URLSAFE$klio() {
                return RFC4648_URLSAFE;
            }

            @NotNull
            public final Decoder getRFC2045$klio() {
                return RFC2045;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

