/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.text;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.Writeable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\b&\u0018\u0000 !2\u00020\u0001:\t !\"#$%&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH&J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0018\u001a\u00020\nH&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH&J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH&J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lorg/kodein/memory/text/Charset;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "charOf", "", "codePoint", "", "checkCodePoint", "", "checkCodePoint$klio", "codePointOf", "char", "decode", "src", "Lorg/kodein/memory/io/Readable;", "decodeCodePoint", "encode", "dst", "Lorg/kodein/memory/io/Writeable;", "encodeCodePoint", "headerSize", "isCodePointValid", "", "isValid", "sizeOf", "sizeOfCodePoint", "tryDecode", "tryDecodeCodePoint", "ASCII", "Companion", "ISO8859_1", "ISO8859_15", "Type", "UTF16", "UTF16BE", "UTF16LE", "UTF8", "klio"})
public abstract class Charset {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;

    public Charset(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public abstract int codePointOf(char var1);

    public abstract char charOf(int var1);

    public abstract boolean isCodePointValid(int var1);

    public final boolean isValid(char c) {
        return this.isCodePointValid(this.codePointOf(c));
    }

    public final void checkCodePoint$klio(int codePoint) {
        if (!this.isCodePointValid(codePoint)) {
            StringBuilder stringBuilder = new StringBuilder().append("Code point 0x");
            String string = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            throw new IllegalStateException(stringBuilder.append(string).append(" is not valid in ").append(this.name).toString().toString());
        }
    }

    public abstract int sizeOfCodePoint(int var1);

    public final int sizeOf(char c) {
        return this.sizeOfCodePoint(this.codePointOf(c));
    }

    public abstract int headerSize();

    public abstract int encodeCodePoint(int var1, @NotNull Writeable var2);

    public final int encode(char c, @NotNull Writeable dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return this.encodeCodePoint(this.codePointOf(c), dst);
    }

    public abstract int decodeCodePoint(@NotNull Readable var1);

    public final char decode(@NotNull Readable src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.charOf(this.decodeCodePoint(src));
    }

    public abstract int tryDecodeCodePoint(@NotNull Readable var1);

    public final int tryDecode(@NotNull Readable src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int codePoint = this.tryDecodeCodePoint(src);
        if (codePoint == -1) {
            return -1;
        }
        return this.charOf(codePoint);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/kodein/memory/text/Charset$Type;", "", "()V", "AbstractUTF16Charset", "ByteCharset", "UTF16Charset", "klio"})
    public static final class Type {
        @NotNull
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kodein/memory/text/Charset$Type$ByteCharset;", "Lorg/kodein/memory/text/Charset;", "name", "", "max", "", "(Ljava/lang/String;I)V", "charOf", "", "codePoint", "codePointOf", "char", "decodeCodePoint", "src", "Lorg/kodein/memory/io/Readable;", "encodeCodePoint", "dst", "Lorg/kodein/memory/io/Writeable;", "headerSize", "isCodePointValid", "", "sizeOfCodePoint", "tryDecodeCodePoint", "klio"})
        public static abstract class ByteCharset
        extends Charset {
            private final int max;

            public ByteCharset(@NotNull String name, int max) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name);
                this.max = max;
            }

            @Override
            public int codePointOf(char c) {
                return c;
            }

            @Override
            public char charOf(int codePoint) {
                return (char)codePoint;
            }

            @Override
            public boolean isCodePointValid(int codePoint) {
                return 0 <= codePoint ? codePoint <= this.max : false;
            }

            @Override
            public int sizeOfCodePoint(int codePoint) {
                this.checkCodePoint$klio(codePoint);
                return 1;
            }

            @Override
            public int headerSize() {
                return 0;
            }

            @Override
            public int encodeCodePoint(int codePoint, @NotNull Writeable dst) {
                Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                this.checkCodePoint$klio(codePoint);
                dst.writeByte((byte)codePoint);
                return 1;
            }

            @Override
            public int decodeCodePoint(@NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                return src.readByte();
            }

            @Override
            public int tryDecodeCodePoint(@NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                return src.tryReadByte();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kodein/memory/text/Charset$Type$AbstractUTF16Charset;", "Lorg/kodein/memory/text/Charset;", "name", "", "(Ljava/lang/String;)V", "charOf", "", "codePoint", "", "codePointOf", "char", "isCodePointValid", "", "sizeOfCodePoint", "klio"})
        public static abstract class AbstractUTF16Charset
        extends Charset {
            public AbstractUTF16Charset(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name);
            }

            @Override
            public int codePointOf(char c) {
                return c;
            }

            @Override
            public char charOf(int codePoint) {
                return (char)codePoint;
            }

            @Override
            public boolean isCodePointValid(int codePoint) {
                return 0 <= codePoint ? codePoint < 0x110000 : false;
            }

            @Override
            public int sizeOfCodePoint(int codePoint) {
                int n;
                if (codePoint <= 65535) {
                    n = 2;
                } else if (codePoint <= 0x10FFFF) {
                    n = 4;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Code point 0x");
                    String string = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                    throw new IllegalStateException(stringBuilder.append(string).append(" is not valid in Unicode.").toString().toString());
                }
                return n;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH \u00a2\u0006\u0002\b\fJ\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u001d\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u001cJ%\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lorg/kodein/memory/text/Charset$Type$UTF16Charset;", "Lorg/kodein/memory/text/Charset$Type$AbstractUTF16Charset;", "name", "", "(Ljava/lang/String;)V", "byteOrderMark", "", "getByteOrderMark", "()S", "codeUnitToShort", "codeUnit", "", "codeUnitToShort$klio", "decodeCodePoint", "readShort", "Lkotlin/Function0;", "firstShort", "nextShort", "src", "Lorg/kodein/memory/io/Readable;", "decodeCodePoint$klio", "encodeCodePoint", "codePoint", "dst", "Lorg/kodein/memory/io/Writeable;", "headerSize", "shortToCodeUnit", "short", "shortToCodeUnit$klio", "tryDecodeCodePoint", "buffer", "Lorg/kodein/memory/io/Memory;", "tryDecodeCodePoint$klio", "klio"})
        public static abstract class UTF16Charset
        extends AbstractUTF16Charset {
            public UTF16Charset(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(name);
            }

            public abstract short getByteOrderMark();

            @Override
            public int headerSize() {
                return 0;
            }

            public abstract short codeUnitToShort$klio(int var1);

            public abstract int shortToCodeUnit$klio(short var1);

            @Override
            public int encodeCodePoint(int codePoint, @NotNull Writeable dst) {
                Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                this.checkCodePoint$klio(codePoint);
                if (codePoint <= 65535) {
                    dst.writeShort(this.codeUnitToShort$klio(codePoint));
                    return 2;
                }
                int code = codePoint - 65536;
                dst.writeShort(this.codeUnitToShort$klio(code >> 10 & 0x3FF | 0xD800));
                dst.writeShort(this.codeUnitToShort$klio(code & 0x3FF | 0xDC00));
                return 4;
            }

            private final int decodeCodePoint(short firstShort, Function0<Short> nextShort) {
                int n;
                int c1 = this.shortToCodeUnit$klio(firstShort);
                switch (c1 >> 10 & 0x3F) {
                    case 54: {
                        int c2 = this.shortToCodeUnit$klio(((Number)nextShort.invoke()).shortValue());
                        int code = (c1 & 0x3FF) << 10 | c2 & 0x3FF;
                        n = code + 65536;
                        break;
                    }
                    case 55: {
                        throw new IllegalStateException("Invalid UTF-16 code unit (expecting a first unit but got a second unit)".toString());
                    }
                    default: {
                        n = c1;
                    }
                }
                return n;
            }

            private final int decodeCodePoint(Function0<Short> readShort) {
                return this.decodeCodePoint(((Number)readShort.invoke()).shortValue(), readShort);
            }

            @Override
            public int decodeCodePoint(@NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                return this.decodeCodePoint((Function0<Short>)((Function0)new Function0<Short>((Object)src){

                    @NotNull
                    public final Short invoke() {
                        return ((Readable)this.receiver).readShort();
                    }
                }));
            }

            public final int decodeCodePoint$klio(short firstShort, @NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                return this.decodeCodePoint(firstShort, (Function0<Short>)((Function0)new Function0<Short>((Object)src){

                    @NotNull
                    public final Short invoke() {
                        return ((Readable)this.receiver).readShort();
                    }
                }));
            }

            @Override
            public int tryDecodeCodePoint(@NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                ByteArrayMemory buffer = MemoryKt.array(Memory.Companion, 2);
                int read = src.tryReadBytes(buffer);
                if (read == -1) {
                    return -1;
                }
                if (read != 2) {
                    throw new IllegalStateException("Invalid end of stream.".toString());
                }
                return this.tryDecodeCodePoint$klio(buffer, buffer.getShort(0), src);
            }

            public final int tryDecodeCodePoint$klio(@NotNull Memory buffer, short firstShort, @NotNull Readable src) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                return this.decodeCodePoint(firstShort, (Function0<Short>)((Function0)new Function0<Short>(src, buffer){
                    final /* synthetic */ Readable $src;
                    final /* synthetic */ Memory $buffer;
                    {
                        this.$src = $src;
                        this.$buffer = $buffer;
                        super(0);
                    }

                    @NotNull
                    public final Short invoke() {
                        int read = this.$src.tryReadBytes(this.$buffer);
                        if (read != 2) {
                            throw new IllegalStateException("Invalid end of stream.".toString());
                        }
                        return this.$buffer.getShort(0);
                    }
                }));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/kodein/memory/text/Charset$ASCII;", "Lorg/kodein/memory/text/Charset$Type$ByteCharset;", "()V", "klio"})
    public static final class ASCII
    extends Type.ByteCharset {
        @NotNull
        public static final ASCII INSTANCE = new ASCII();

        private ASCII() {
            super("ASCII", 127);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/kodein/memory/text/Charset$ISO8859_1;", "Lorg/kodein/memory/text/Charset$Type$ByteCharset;", "()V", "klio"})
    public static final class ISO8859_1
    extends Type.ByteCharset {
        @NotNull
        public static final ISO8859_1 INSTANCE = new ISO8859_1();

        private ISO8859_1() {
            super("ISO-8859-1", 255);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/kodein/memory/text/Charset$ISO8859_15;", "Lorg/kodein/memory/text/Charset$Type$ByteCharset;", "()V", "charOf", "", "codePoint", "", "codePointOf", "char", "klio"})
    public static final class ISO8859_15
    extends Type.ByteCharset {
        @NotNull
        public static final ISO8859_15 INSTANCE = new ISO8859_15();

        private ISO8859_15() {
            super("ISO-8859-15", 255);
        }

        @Override
        public int codePointOf(char c) {
            char c2 = c;
            return c2 == '\u20ac' ? 164 : (c2 == '\u0160' ? 166 : (c2 == '\u0161' ? 168 : (c2 == '\u017d' ? 180 : (c2 == '\u017e' ? 184 : (c2 == '\u0152' ? 188 : (c2 == '\u0153' ? 189 : (c2 == '\u0178' ? 190 : (int)c)))))));
        }

        @Override
        public char charOf(int codePoint) {
            char c;
            switch (codePoint) {
                case 164: {
                    c = 8364;
                    break;
                }
                case 166: {
                    c = 352;
                    break;
                }
                case 168: {
                    c = 353;
                    break;
                }
                case 180: {
                    c = 381;
                    break;
                }
                case 184: {
                    c = 382;
                    break;
                }
                case 188: {
                    c = 338;
                    break;
                }
                case 189: {
                    c = 339;
                    break;
                }
                case 190: {
                    c = 376;
                    break;
                }
                default: {
                    c = (char)codePoint;
                }
            }
            return c;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\rR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/kodein/memory/text/Charset$UTF16BE;", "Lorg/kodein/memory/text/Charset$Type$UTF16Charset;", "()V", "byteOrderMark", "", "getByteOrderMark", "()S", "codeUnitToShort", "codeUnit", "", "codeUnitToShort$klio", "shortToCodeUnit", "short", "shortToCodeUnit$klio", "klio"})
    public static final class UTF16BE
    extends Type.UTF16Charset {
        @NotNull
        public static final UTF16BE INSTANCE = new UTF16BE();

        private UTF16BE() {
            super("UTF-16BE");
        }

        @Override
        public short getByteOrderMark() {
            return -257;
        }

        @Override
        public short codeUnitToShort$klio(int codeUnit) {
            return (short)codeUnit;
        }

        @Override
        public int shortToCodeUnit$klio(short s) {
            return s;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\rR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/kodein/memory/text/Charset$UTF16LE;", "Lorg/kodein/memory/text/Charset$Type$UTF16Charset;", "()V", "byteOrderMark", "", "getByteOrderMark", "()S", "codeUnitToShort", "codeUnit", "", "codeUnitToShort$klio", "shortToCodeUnit", "short", "shortToCodeUnit$klio", "klio"})
    public static final class UTF16LE
    extends Type.UTF16Charset {
        @NotNull
        public static final UTF16LE INSTANCE = new UTF16LE();

        private UTF16LE() {
            super("UTF-16LE");
        }

        @Override
        public short getByteOrderMark() {
            return -2;
        }

        @Override
        public short codeUnitToShort$klio(int codeUnit) {
            short s$iv = (short)codeUnit;
            boolean $i$f$swapEndian = false;
            return (short)((s$iv & 0xFF) << 8 | (s$iv & 0xFFFF) >>> 8);
        }

        @Override
        public int shortToCodeUnit$klio(short s) {
            boolean $i$f$swapEndian = false;
            return (short)((s & 0xFF) << 8 | (s & 0xFFFF) >>> 8);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kodein/memory/text/Charset$UTF16;", "Lorg/kodein/memory/text/Charset$Type$AbstractUTF16Charset;", "encoder", "Lorg/kodein/memory/text/Charset$Type$UTF16Charset;", "(Lorg/kodein/memory/text/Charset$Type$UTF16Charset;)V", "buffer", "Lorg/kodein/memory/io/ByteArrayMemory;", "decoder", "getEncoder", "()Lorg/kodein/memory/text/Charset$Type$UTF16Charset;", "hasWrittenMark", "", "decodeCodePoint", "", "src", "Lorg/kodein/memory/io/Readable;", "encodeCodePoint", "codePoint", "dst", "Lorg/kodein/memory/io/Writeable;", "headerSize", "tryDecodeCodePoint", "Companion", "klio"})
    public static final class UTF16
    extends Type.AbstractUTF16Charset {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Type.UTF16Charset encoder;
        private boolean hasWrittenMark;
        @NotNull
        private final ByteArrayMemory buffer;
        @Nullable
        private Type.UTF16Charset decoder;
        @NotNull
        private static final String name = "UTF-16";

        public UTF16(@NotNull Type.UTF16Charset encoder) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            super(name);
            this.encoder = encoder;
            this.buffer = MemoryKt.array(Memory.Companion, 2);
        }

        public /* synthetic */ UTF16(Type.UTF16Charset uTF16Charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                uTF16Charset = UTF16BE.INSTANCE;
            }
            this(uTF16Charset);
        }

        @NotNull
        public final Type.UTF16Charset getEncoder() {
            return this.encoder;
        }

        @Override
        public int headerSize() {
            return 2;
        }

        @Override
        public int encodeCodePoint(int codePoint, @NotNull Writeable dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int count = 0;
            if (!this.hasWrittenMark) {
                dst.writeShort(this.encoder.getByteOrderMark());
                this.hasWrittenMark = true;
                count += 2;
            }
            return count += this.encoder.encodeCodePoint(codePoint, dst);
        }

        @Override
        public int decodeCodePoint(@NotNull Readable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (this.decoder == null) {
                short mark = src.readShort();
                if (mark == UTF16BE.INSTANCE.getByteOrderMark()) {
                    this.decoder = UTF16BE.INSTANCE;
                } else if (mark == UTF16LE.INSTANCE.getByteOrderMark()) {
                    this.decoder = UTF16LE.INSTANCE;
                } else {
                    Type.UTF16Charset uTF16Charset = this.decoder = (Type.UTF16Charset)UTF16BE.INSTANCE;
                    Intrinsics.checkNotNull((Object)uTF16Charset);
                    return uTF16Charset.decodeCodePoint$klio(mark, src);
                }
            }
            Type.UTF16Charset uTF16Charset = this.decoder;
            Intrinsics.checkNotNull((Object)uTF16Charset);
            return uTF16Charset.decodeCodePoint(src);
        }

        @Override
        public int tryDecodeCodePoint(@NotNull Readable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (this.decoder == null) {
                int read = src.tryReadBytes(this.buffer);
                if (read == -1) {
                    return -1;
                }
                if (read != 2) {
                    throw new IllegalStateException("Invalid end of stream.".toString());
                }
                short mark = this.buffer.getShort(0);
                if (mark == UTF16BE.INSTANCE.getByteOrderMark()) {
                    this.decoder = UTF16BE.INSTANCE;
                } else if (mark == UTF16LE.INSTANCE.getByteOrderMark()) {
                    this.decoder = UTF16LE.INSTANCE;
                } else {
                    Type.UTF16Charset uTF16Charset = this.decoder = (Type.UTF16Charset)UTF16BE.INSTANCE;
                    Intrinsics.checkNotNull((Object)uTF16Charset);
                    return uTF16Charset.tryDecodeCodePoint$klio(this.buffer, mark, src);
                }
            }
            Type.UTF16Charset uTF16Charset = this.decoder;
            Intrinsics.checkNotNull((Object)uTF16Charset);
            return uTF16Charset.tryDecodeCodePoint(src);
        }

        public UTF16() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kodein/memory/text/Charset$UTF16$Companion;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "klio"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getName() {
                return name;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/kodein/memory/text/Charset$UTF8;", "Lorg/kodein/memory/text/Charset;", "()V", "charOf", "", "codePoint", "", "codePointOf", "char", "decodeCodePoint", "firstByte", "", "readByte", "Lkotlin/Function0;", "src", "Lorg/kodein/memory/io/Readable;", "encodeCodePoint", "dst", "Lorg/kodein/memory/io/Writeable;", "headerSize", "isCodePointValid", "", "sizeOfCodePoint", "tryDecodeCodePoint", "klio"})
    public static final class UTF8
    extends Charset {
        @NotNull
        public static final UTF8 INSTANCE = new UTF8();

        private UTF8() {
            super("UTF-8");
        }

        @Override
        public int codePointOf(char c) {
            return c;
        }

        @Override
        public char charOf(int codePoint) {
            if (codePoint > 65535) {
                StringBuilder stringBuilder = new StringBuilder().append("Code point 0x");
                String string = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                throw new IllegalStateException(stringBuilder.append(string).append(" cannot be represented as a 2 bytes Char.").toString().toString());
            }
            return (char)codePoint;
        }

        @Override
        public boolean isCodePointValid(int codePoint) {
            return codePoint <= 0x10FFFF;
        }

        @Override
        public int sizeOfCodePoint(int codePoint) {
            int n;
            if (codePoint <= 127) {
                n = 1;
            } else if (codePoint <= 2047) {
                n = 2;
            } else if (codePoint <= 65535) {
                n = 3;
            } else if (codePoint <= 0x10FFFF) {
                n = 4;
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Code point 0x");
                String string = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                throw new IllegalStateException(stringBuilder.append(string).append(" is not valid in Unicode.").toString().toString());
            }
            return n;
        }

        @Override
        public int headerSize() {
            return 0;
        }

        @Override
        public int encodeCodePoint(int codePoint, @NotNull Writeable dst) {
            int n;
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            this.checkCodePoint$klio(codePoint);
            if (codePoint <= 127) {
                dst.writeByte((byte)codePoint);
                return 1;
            }
            if (codePoint <= 2047) {
                dst.writeByte((byte)(codePoint >> 6 & 0x1F | 0xC0));
                n = 2;
            } else if (codePoint <= 65535) {
                dst.writeByte((byte)(codePoint >> 12 & 0xF | 0xE0));
                dst.writeByte((byte)(codePoint >> 6 & 0x3F | 0x80));
                n = 3;
            } else if (codePoint <= 0x10FFFF) {
                dst.writeByte((byte)(codePoint >> 18 & 7 | 0xF0));
                dst.writeByte((byte)(codePoint >> 12 & 0x3F | 0x80));
                dst.writeByte((byte)(codePoint >> 6 & 0x3F | 0x80));
                n = 4;
            } else {
                throw new IllegalStateException("Illegal code point");
            }
            int count = n;
            dst.writeByte((byte)(codePoint & 0x3F | 0x80));
            return count;
        }

        private final int decodeCodePoint(byte firstByte, Function0<Byte> readByte) {
            int c0 = firstByte & 0xFF;
            int n = c0;
            boolean bl = 0 <= n ? n < 128 : false;
            if (bl) {
                return c0;
            }
            boolean bl2 = 128 <= n ? n < 192 : false;
            if (bl2) {
                throw new IllegalStateException("Invalid UTF-8 code unit (expecting a first unit but got a continuation unit)".toString());
            }
            boolean bl3 = 192 <= n ? n < 224 : false;
            if (bl3) {
                byte c1 = ((Number)readByte.invoke()).byteValue();
                return (c0 & 0x1F) << 6 | c1 & 0x3F;
            }
            boolean bl4 = 224 <= n ? n < 240 : false;
            if (bl4) {
                byte c1 = ((Number)readByte.invoke()).byteValue();
                byte c2 = ((Number)readByte.invoke()).byteValue();
                return (c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F;
            }
            boolean bl5 = 240 <= n ? n < 248 : false;
            if (bl5) {
                byte c1 = ((Number)readByte.invoke()).byteValue();
                byte c2 = ((Number)readByte.invoke()).byteValue();
                byte c3 = ((Number)readByte.invoke()).byteValue();
                return (c0 & 7) << 18 | (c1 & 0x3F) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
            }
            throw new IllegalStateException("Illegal UTF-8 code unit.");
        }

        @Override
        public int decodeCodePoint(@NotNull Readable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return this.decodeCodePoint(src.readByte(), (Function0<Byte>)((Function0)new Function0<Byte>(src){
                final /* synthetic */ Readable $src;
                {
                    this.$src = $src;
                    super(0);
                }

                @NotNull
                public final Byte invoke() {
                    return this.$src.readByte();
                }
            }));
        }

        @Override
        public int tryDecodeCodePoint(@NotNull Readable src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            int firstByte = src.tryReadByte();
            if (firstByte == -1) {
                return -1;
            }
            return this.decodeCodePoint((byte)firstByte, (Function0<Byte>)((Function0)new Function0<Byte>(src){
                final /* synthetic */ Readable $src;
                {
                    this.$src = $src;
                    super(0);
                }

                @NotNull
                public final Byte invoke() {
                    int b = this.$src.tryReadByte();
                    if (b == -1) {
                        throw new IllegalStateException("Invalid end of stream.".toString());
                    }
                    return (byte)b;
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kodein/memory/text/Charset$Companion;", "", "()V", "named", "Lorg/kodein/memory/text/Charset;", "name", "", "klio"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Charset named(@NotNull String name) {
            Charset charset;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = name;
            if (Intrinsics.areEqual((Object)string, (Object)UTF8.INSTANCE.getName())) {
                charset = UTF8.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)UTF16.Companion.getName())) {
                charset = new UTF16(UTF16BE.INSTANCE);
            } else if (Intrinsics.areEqual((Object)string, (Object)UTF16BE.INSTANCE.getName())) {
                charset = UTF16BE.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)UTF16LE.INSTANCE.getName())) {
                charset = UTF16LE.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ASCII.INSTANCE.getName())) {
                charset = ASCII.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ISO8859_1.INSTANCE.getName())) {
                charset = ISO8859_1.INSTANCE;
            } else {
                throw new NoSuchElementException("Unknown charset " + name);
            }
            return charset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

