/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.text;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.memory.io.Allocation;
import org.kodein.memory.io.AllocationJvmKt;
import org.kodein.memory.io.AllocationKt;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.CursorReadable;
import org.kodein.memory.io.CursorWriteable;
import org.kodein.memory.io.DirectByteBufferMemory;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryAllocation;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.MemoryReadableKt;
import org.kodein.memory.io.MemoryWriteable;
import org.kodein.memory.io.MemoryWriteableKt;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.ReadableKt;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.text.Charset;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a*\u0010\u0007\u001a\u0010\u0012\b\u0012\u00060\tj\u0002`\n0\bj\u0002`\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0012\u001a\u00020\u0011*\u00020\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0013\u001a\u00020\u0011*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u00142\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0013\u001a\u00020\u0011*\u00020\u00182\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u0016\u001a\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u001a2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0013\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u0016\u001a\u0012\u0010\u001c\u001a\u00020\u0016*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u001d\u001a\u00020\u0016*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010 \u001a\u00020\u0016*\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010!\u001a\u00020\u0016*\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\""}, d2={"array", "Lorg/kodein/memory/io/ByteArrayMemory;", "Lorg/kodein/memory/io/Memory$Companion;", "str", "", "charset", "Lorg/kodein/memory/text/Charset;", "native", "Lorg/kodein/memory/io/MemoryAllocation;", "Lorg/kodein/memory/io/DirectByteBufferMemory;", "Lorg/kodein/memory/io/PlatformNativeMemory;", "Lorg/kodein/memory/io/PlatformNativeAllocation;", "Lorg/kodein/memory/io/Allocation$Companion;", "readChar", "", "Lorg/kodein/memory/io/Readable;", "readLine", "", "readNullTerminatedString", "readString", "", "offset", "", "size", "Lorg/kodein/memory/io/CursorReadable;", "maxChars", "Lorg/kodein/memory/io/ReadMemory;", "sizeBytes", "sizeOf", "writeChar", "Lorg/kodein/memory/io/Writeable;", "char", "writeNullTerminatedString", "writeString", "klio"})
public final class StringsKt {
    /*
     * WARNING - void declaration
     */
    public static final int sizeOf(@NotNull Charset $this$sizeOf, @NotNull CharSequence str) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sizeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        int initial$iv = $this$sizeOf.headerSize();
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (int i = 0; i < $this$fold$iv.length(); ++i) {
            void char_;
            char element$iv;
            char c = element$iv = $this$fold$iv.charAt(i);
            int count = accumulator$iv;
            boolean bl = false;
            accumulator$iv = count + $this$sizeOf.sizeOf((char)char_);
        }
        return accumulator$iv;
    }

    public static final int writeChar(@NotNull Writeable $this$writeChar, char c, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$writeChar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return charset.encode(c, $this$writeChar);
    }

    public static /* synthetic */ int writeChar$default(Writeable writeable, char c, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.writeChar(writeable, c, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final int writeString(@NotNull Writeable $this$writeString, @NotNull CharSequence str, @NotNull Charset charset) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        $this$writeString.requestCanWrite(StringsKt.sizeOf(charset, str));
        CharSequence charSequence = str;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (int i = 0; i < $this$fold$iv.length(); ++i) {
            void char_;
            char element$iv;
            char c = element$iv = $this$fold$iv.charAt(i);
            int count = accumulator$iv;
            boolean bl = false;
            accumulator$iv = count + charset.encode((char)char_, $this$writeString);
        }
        return accumulator$iv;
    }

    public static /* synthetic */ int writeString$default(Writeable writeable, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.writeString(writeable, charSequence, charset);
    }

    public static final char readChar(@NotNull Readable $this$readChar, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readChar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return charset.decode($this$readChar);
    }

    public static /* synthetic */ char readChar$default(Readable readable, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readChar(readable, charset);
    }

    @NotNull
    public static final String readString(@NotNull Readable $this$readString, int sizeBytes, @NotNull Charset charset, int maxChars) {
        int start;
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        char[] array2 = new char[Math.min(sizeBytes, maxChars)];
        int pos = 0;
        for (int readSize = 0; readSize < sizeBytes && pos < maxChars; readSize += $this$readString.getPosition() - start) {
            start = $this$readString.getPosition();
            char c = charset.decode($this$readString);
            array2[pos++] = c;
        }
        return kotlin.text.StringsKt.concatToString((char[])array2, (int)0, (int)(0 + pos));
    }

    public static /* synthetic */ String readString$default(Readable readable, int n, Charset charset, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return StringsKt.readString(readable, n, charset, n2);
    }

    @NotNull
    public static final String readString(@NotNull CursorReadable $this$readString, @NotNull Charset charset, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringsKt.readString($this$readString, $this$readString.getRemaining(), charset, maxChars);
    }

    public static /* synthetic */ String readString$default(CursorReadable cursorReadable, Charset charset, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return StringsKt.readString(cursorReadable, charset, n);
    }

    @NotNull
    public static final String readString(@NotNull ReadMemory $this$readString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringsKt.readString$default(MemoryReadableKt.asReadable($this$readString), charset, 0, 2, null);
    }

    public static /* synthetic */ String readString$default(ReadMemory readMemory, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readString(readMemory, charset);
    }

    @NotNull
    public static final String readString(@NotNull byte[] $this$readString, int offset, int size, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringsKt.readString$default(ReadableKt.asReadable($this$readString, offset, size), charset, 0, 2, null);
    }

    public static /* synthetic */ String readString$default(byte[] byArray, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 4) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readString(byArray, n, n2, charset);
    }

    @NotNull
    public static final String readString(@NotNull byte[] $this$readString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringsKt.readString$default(ReadableKt.asReadable($this$readString), charset, 0, 2, null);
    }

    public static /* synthetic */ String readString$default(byte[] byArray, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readString(byArray, charset);
    }

    public static final int writeNullTerminatedString(@NotNull Writeable $this$writeNullTerminatedString, @NotNull CharSequence str, @NotNull Charset charset) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$writeNullTerminatedString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            CharSequence $this$none$iv = str;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                boolean bl3 = it == '\u0000';
                if (!bl3) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "Char sequence must not have a null char ('\\0').";
            throw new IllegalArgumentException(string.toString());
        }
        int size = StringsKt.writeString($this$writeNullTerminatedString, str, charset);
        $this$writeNullTerminatedString.writeByte((byte)0);
        return size + 1;
    }

    public static /* synthetic */ int writeNullTerminatedString$default(Writeable writeable, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.writeNullTerminatedString(writeable, charSequence, charset);
    }

    @NotNull
    public static final String readNullTerminatedString(@NotNull Readable $this$readNullTerminatedString, @NotNull Charset charset) {
        char c;
        Intrinsics.checkNotNullParameter((Object)$this$readNullTerminatedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuilder sb = new StringBuilder();
        while ((c = charset.decode($this$readNullTerminatedString)) != '\u0000') {
            sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String readNullTerminatedString$default(Readable readable, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readNullTerminatedString(readable, charset);
    }

    @NotNull
    public static final ByteArrayMemory array(@NotNull Memory.Companion $this$array, @NotNull CharSequence str, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$array, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Memory.Companion companion = Memory.Companion;
        int size$iv = StringsKt.sizeOf(charset, str);
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$array_u24lambda_u2d4 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        StringsKt.writeString($this$array_u24lambda_u2d4, str, charset);
        int length$iv = w$iv$iv.getPosition();
        return size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv);
    }

    public static /* synthetic */ ByteArrayMemory array$default(Memory.Companion companion, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.array(companion, charSequence, charset);
    }

    @NotNull
    public static final MemoryAllocation<DirectByteBufferMemory> native(@NotNull Allocation.Companion $this$native, @NotNull CharSequence str, @NotNull Charset charset) {
        MemoryAllocation<DirectByteBufferMemory> memoryAllocation;
        Intrinsics.checkNotNullParameter((Object)$this$native, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Allocation.Companion companion = Allocation.Companion;
        int size$iv = StringsKt.sizeOf(charset, str);
        boolean $i$f$native = false;
        MemoryAllocation<DirectByteBufferMemory> alloc$iv = AllocationJvmKt.native(Allocation.Companion, size$iv);
        try {
            Memory $this$write$iv$iv = alloc$iv;
            boolean $i$f$write = false;
            MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
            CursorWriteable $this$native_u24lambda_u2d0$iv = w$iv$iv;
            boolean bl = false;
            Writeable $this$native_u24lambda_u2d5 = $this$native_u24lambda_u2d0$iv;
            boolean bl2 = false;
            StringsKt.writeString($this$native_u24lambda_u2d5, str, charset);
            int length$iv = w$iv$iv.getPosition();
            memoryAllocation = size$iv == length$iv ? alloc$iv : AllocationKt.reduced(alloc$iv, length$iv);
        }
        catch (Throwable t$iv) {
            alloc$iv.close();
            throw t$iv;
        }
        return memoryAllocation;
    }

    public static /* synthetic */ MemoryAllocation native$default(Allocation.Companion companion, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.native(companion, charSequence, charset);
    }

    @Nullable
    public static final String readLine(@NotNull Readable $this$readLine, @NotNull Charset charset) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$readLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuilder $this$readLine_u24lambda_u2d6 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int count = 0;
        while (true) {
            int next;
            if ((next = charset.tryDecode($this$readLine)) < 0) {
                if (count != 0) break;
                return null;
            }
            char nextChar = (char)next;
            if (nextChar == '\n') break;
            if (nextChar == '\r') {
                int after = charset.tryDecode($this$readLine);
                if (after == -1) {
                    $this$readLine_u24lambda_u2d6.append(nextChar);
                    break;
                }
                char afterChar = (char)after;
                if (afterChar == '\n') break;
                $this$readLine_u24lambda_u2d6.append(nextChar);
                $this$readLine_u24lambda_u2d6.append(afterChar);
                continue;
            }
            $this$readLine_u24lambda_u2d6.append(nextChar);
            ++count;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String readLine$default(Readable readable, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charset.UTF8.INSTANCE;
        }
        return StringsKt.readLine(readable, charset);
    }
}

