/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.util;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kodein/memory/util/TimeUUIDs;", "", "()V", "MAX_CLOCK_SEQ_AND_NODE", "", "MAX_UNIX_TIMESTAMP", "getMAX_UNIX_TIMESTAMP", "()J", "MIN_CLOCK_SEQ_AND_NODE", "MIN_UNIX_TIMESTAMP", "getMIN_UNIX_TIMESTAMP", "START_EPOCH", "makeLsb", "clockSequence", "node", "makeMsb", "timestamp", "timestampGregorianToUnix", "gregorianTimestampNano", "timestampUnixToGregorian", "unixTimestampMillis", "klio"})
final class TimeUUIDs {
    @NotNull
    public static final TimeUUIDs INSTANCE = new TimeUUIDs();
    public static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    public static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    public static final long START_EPOCH = -12219292800000L;
    private static final long MIN_UNIX_TIMESTAMP = INSTANCE.timestampGregorianToUnix(0L);
    private static final long MAX_UNIX_TIMESTAMP = INSTANCE.timestampGregorianToUnix(0xFFFFFFFFFFFFFFFL);

    private TimeUUIDs() {
    }

    public final long getMIN_UNIX_TIMESTAMP() {
        return MIN_UNIX_TIMESTAMP;
    }

    public final long getMAX_UNIX_TIMESTAMP() {
        return MAX_UNIX_TIMESTAMP;
    }

    public final long timestampGregorianToUnix(long gregorianTimestampNano) {
        return gregorianTimestampNano / (long)10000 + -12219292800000L;
    }

    public final long timestampUnixToGregorian(long unixTimestampMillis) {
        return (unixTimestampMillis - -12219292800000L) * (long)10000;
    }

    public final long makeMsb(long timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp) << 32;
        msb |= (0xFFFF00000000L & timestamp) >>> 16;
        msb |= (0xFFF000000000000L & timestamp) >>> 48;
        return msb |= 0x1000L;
    }

    public final long makeLsb(long clockSequence, long node) {
        long lsb = 0L;
        lsb |= (clockSequence & 0x3FFFL) << 48;
        lsb |= Long.MIN_VALUE;
        return lsb |= node;
    }
}

