/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=KXStringSerializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/kodein/memory/util/UUID;", "", "mostSignificantBits", "", "leastSignificantBits", "(JJ)V", "getLeastSignificantBits", "()J", "getMostSignificantBits", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "", "variant", "version", "Companion", "KXBinarySerializer", "KXStringSerializer", "klio"})
public final class UUID
implements Comparable<UUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    @NotNull
    private static final UUID NIL = new UUID(0L, 0L);
    @NotNull
    private static final char[] digits;

    public UUID(long mostSignificantBits, long leastSignificantBits) {
        this.mostSignificantBits = mostSignificantBits;
        this.leastSignificantBits = leastSignificantBits;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public final int version() {
        return (int)(this.mostSignificantBits >> 12 & 0xFL);
    }

    public final int variant() {
        int n;
        int n2 = (int)(this.leastSignificantBits >>> 61);
        boolean bl = 0 <= n2 ? n2 < 4 : false;
        if (bl) {
            n = 0;
        } else {
            boolean bl2 = 4 <= n2 ? n2 < 6 : false;
            if (bl2) {
                n = 1;
            } else if (n2 == 6) {
                n = 2;
            } else if (n2 == 7) {
                n = 3;
            } else {
                throw new IllegalStateException("Unknown variant".toString());
            }
        }
        return n;
    }

    @NotNull
    public String toString() {
        char[] buf = new char[36];
        UUID.Companion.formatUnsignedLong(this.leastSignificantBits, 4, buf, 24, 12);
        UUID.Companion.formatUnsignedLong(this.leastSignificantBits >>> 48, 4, buf, 19, 4);
        UUID.Companion.formatUnsignedLong(this.mostSignificantBits, 4, buf, 14, 4);
        UUID.Companion.formatUnsignedLong(this.mostSignificantBits >>> 16, 4, buf, 9, 4);
        UUID.Companion.formatUnsignedLong(this.mostSignificantBits >>> 32, 4, buf, 0, 8);
        buf[23] = 45;
        buf[18] = 45;
        buf[13] = 45;
        buf[8] = 45;
        return StringsKt.concatToString((char[])buf);
    }

    @Override
    public int compareTo(@NotNull UUID other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.mostSignificantBits < other.mostSignificantBits ? -1 : (this.mostSignificantBits > other.mostSignificantBits ? 1 : (this.leastSignificantBits < other.leastSignificantBits ? -1 : (this.leastSignificantBits > other.leastSignificantBits ? 1 : 0)));
    }

    public int hashCode() {
        long hilo = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        UUID cfr_ignored_0 = (UUID)other;
        if (this.mostSignificantBits != ((UUID)other).mostSignificantBits) {
            return false;
        }
        return this.leastSignificantBits == ((UUID)other).leastSignificantBits;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        digits = cArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kodein/memory/util/UUID$Companion;", "", "()V", "NIL", "Lorg/kodein/memory/util/UUID;", "getNIL", "()Lorg/kodein/memory/util/UUID;", "digits", "", "formatUnsignedLong", "", "value", "", "shift", "", "buf", "offset", "len", "fromString", "name", "", "serializer", "Lkotlinx/serialization/KSerializer;", "klio"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UUID getNIL() {
            return NIL;
        }

        private final void formatUnsignedLong(long value, int shift, char[] buf, int offset, int len) {
            long work = value;
            int charPos = offset + len;
            int radix = 1 << shift;
            int mask = radix - 1;
            do {
                buf[--charPos] = digits[(int)work & mask];
                work >>>= shift;
            } while (charPos > offset);
        }

        @NotNull
        public final UUID fromString(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int len = name.length();
            if (!(len <= 36)) {
                boolean $i$a$-require-UUID$Companion$fromString$22 = false;
                String $i$a$-require-UUID$Companion$fromString$22 = "UUID string too large";
                throw new IllegalArgumentException($i$a$-require-UUID$Companion$fromString$22.toString());
            }
            int dash1 = StringsKt.indexOf$default((CharSequence)name, (char)'-', (int)0, (boolean)false, (int)4, null);
            int dash2 = StringsKt.indexOf$default((CharSequence)name, (char)'-', (int)(dash1 + 1), (boolean)false, (int)4, null);
            int dash3 = StringsKt.indexOf$default((CharSequence)name, (char)'-', (int)(dash2 + 1), (boolean)false, (int)4, null);
            int dash4 = StringsKt.indexOf$default((CharSequence)name, (char)'-', (int)(dash3 + 1), (boolean)false, (int)4, null);
            int dash5 = StringsKt.indexOf$default((CharSequence)name, (char)'-', (int)(dash4 + 1), (boolean)false, (int)4, null);
            if (dash4 >= 0 && dash5 < 0) {
                String string = name.substring(0, dash1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                long msb = Long.parseLong(string, CharsKt.checkRadix((int)16)) & 0xFFFFFFFFL;
                msb <<= 16;
                String string2 = name.substring(dash1 + 1, dash2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                msb |= Long.parseLong(string2, CharsKt.checkRadix((int)16)) & 0xFFFFL;
                msb <<= 16;
                String string3 = name.substring(dash2 + 1, dash3);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                msb |= Long.parseLong(string3, CharsKt.checkRadix((int)16)) & 0xFFFFL;
                String string4 = name.substring(dash3 + 1, dash4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                long lsb = Long.parseLong(string4, CharsKt.checkRadix((int)16)) & 0xFFFFL;
                lsb <<= 48;
                String string5 = name.substring(dash4 + 1, len);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return new UUID(msb, lsb |= Long.parseLong(string5, CharsKt.checkRadix((int)16)) & 0xFFFFFFFFFFFFL);
            }
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }

        @NotNull
        public final KSerializer<UUID> serializer() {
            return KXStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/kodein/memory/util/UUID$KXStringSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/kodein/memory/util/UUID;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "klio"})
    public static final class KXStringSerializer
    implements KSerializer<UUID> {
        @NotNull
        public static final KXStringSerializer INSTANCE = new KXStringSerializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"UUID", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

        private KXStringSerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull UUID value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeString(value.toString());
        }

        @NotNull
        public UUID deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return Companion.fromString(decoder.decodeString());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/kodein/memory/util/UUID$KXBinarySerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/kodein/memory/util/UUID;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "klio"})
    public static final class KXBinarySerializer
    implements KSerializer<UUID> {
        @NotNull
        public static final KXBinarySerializer INSTANCE = new KXBinarySerializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.listSerialDescriptor((SerialDescriptor)SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"bits", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.LONG.INSTANCE)));

        private KXBinarySerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void serialize(@NotNull Encoder encoder, @NotNull UUID value) {
            void $this$encodeStructure$iv;
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Encoder encoder2 = encoder;
            SerialDescriptor descriptor$iv = this.getDescriptor();
            boolean $i$f$encodeStructure = false;
            CompositeEncoder composite$iv = $this$encodeStructure$iv.beginStructure(descriptor$iv);
            Throwable ex$iv = null;
            try {
                CompositeEncoder $this$serialize_u24lambda_u2d0 = composite$iv;
                boolean bl = false;
                $this$serialize_u24lambda_u2d0.encodeLongElement(INSTANCE.getDescriptor(), 0, value.getMostSignificantBits());
                $this$serialize_u24lambda_u2d0.encodeLongElement(INSTANCE.getDescriptor(), 1, value.getLeastSignificantBits());
            }
            catch (Throwable e$iv) {
                try {
                    ex$iv = e$iv;
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (ex$iv == null) {
                        composite$iv.endStructure(descriptor$iv);
                    }
                    throw throwable;
                }
            }
            composite$iv.endStructure(descriptor$iv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public UUID deserialize(@NotNull Decoder decoder) {
            UUID uUID;
            void $this$decodeStructure$iv;
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Decoder decoder2 = decoder;
            SerialDescriptor descriptor$iv = this.getDescriptor();
            boolean $i$f$decodeStructure = false;
            CompositeDecoder composite$iv = $this$decodeStructure$iv.beginStructure(descriptor$iv);
            Throwable ex$iv = null;
            try {
                CompositeDecoder $this$deserialize_u24lambda_u2d2 = composite$iv;
                boolean bl = false;
                long most = 0L;
                long least = 0L;
                int n = 2;
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl2 = false;
                    switch ($this$deserialize_u24lambda_u2d2.decodeElementIndex(INSTANCE.getDescriptor())) {
                        case 0: {
                            most = $this$deserialize_u24lambda_u2d2.decodeLongElement(INSTANCE.getDescriptor(), 0);
                            break;
                        }
                        case 1: {
                            least = $this$deserialize_u24lambda_u2d2.decodeLongElement(INSTANCE.getDescriptor(), 1);
                        }
                    }
                }
                uUID = new UUID(most, least);
            }
            catch (Throwable e$iv) {
                try {
                    ex$iv = e$iv;
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (ex$iv == null) {
                        composite$iv.endStructure(descriptor$iv);
                    }
                    throw throwable;
                }
            }
            composite$iv.endStructure(descriptor$iv);
            return uUID;
        }
    }
}

