/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.memory.util;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.kodein.memory.io.ByteArrayMemory;
import org.kodein.memory.io.CursorWriteable;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.MemoryWriteable;
import org.kodein.memory.io.MemoryWriteableKt;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Readable;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.util.RandomKt;
import org.kodein.memory.util.TimeUUIDs;
import org.kodein.memory.util.TimestampJvmKt;
import org.kodein.memory.util.UUID;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0007\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a9\u0010\f\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001aQ\u0010\u0012\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001aQ\u0010\u0012\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u0002*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0001\u001a\n\u0010!\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\"\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010#\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010$\u001a\u0012\u0010\u0017\u001a\u00020\u0016*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010$\u001a\u0012\u0010\u0018\u001a\u00020\u0016*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010$\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\u0012\u0010%\u001a\u00020'*\u00020\u00022\u0006\u0010(\u001a\u00020)\u001a\u0012\u0010*\u001a\u00020\u000e*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010+\u001a\u001a\u0010,\u001a\u00020'*\u00020\t2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0002\u001a\u0014\u0010.\u001a\u00020\u0002*\u00020\u00042\b\b\u0002\u0010/\u001a\u000200\u001a\n\u00101\u001a\u00020&*\u00020\u0002\u001a\u0012\u00101\u001a\u00020'*\u00020\u00022\u0006\u0010(\u001a\u00020)\u001a\u0012\u00102\u001a\u00020\u000e*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010+\u001a\u0012\u00103\u001a\u00020\u000e*\u00020\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010+\u001a\n\u00104\u001a\u00020\u0002*\u000205\u001a\u0012\u00106\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u00107\u001a\u00020\u0002*\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\"\u001a\u00020\u0006\u001a\n\u00108\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u00109\u001a\u00020'*\u00020)2\u0006\u0010-\u001a\u00020\u0002\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006:"}, d2={"clockSequence", "", "Lorg/kodein/memory/util/UUID;", "endOf", "Lorg/kodein/memory/util/UUID$Companion;", "unixTimestampMillis", "", "fromRawBytes", "input", "Lorg/kodein/memory/io/Memory;", "version", "variant", "fromRawLongs", "high", "Lkotlin/ULong;", "low", "fromRawLongs-AQyPONk", "(Lorg/kodein/memory/util/UUID$Companion;JJII)Lorg/kodein/memory/util/UUID;", "fromRawParts", "part1", "Lkotlin/UInt;", "part2", "Lkotlin/UShort;", "part3", "part4", "part5", "fromRawParts-eCnZzQw", "(Lorg/kodein/memory/util/UUID$Companion;ISSSJII)Lorg/kodein/memory/util/UUID;", "fromRawParts-_tqAewc", "(Lorg/kodein/memory/util/UUID$Companion;ISSSLorg/kodein/memory/io/Memory;II)Lorg/kodein/memory/util/UUID;", "getUUID", "Lorg/kodein/memory/io/ReadMemory;", "index", "gregorianTimestamp", "node", "(Lorg/kodein/memory/util/UUID;)I", "(Lorg/kodein/memory/util/UUID;)S", "part5Bytes", "", "", "output", "Lorg/kodein/memory/io/Writeable;", "part5Long", "(Lorg/kodein/memory/util/UUID;)J", "putUUID", "uuid", "randomUUID", "random", "Lkotlin/random/Random;", "rawBytes", "rawLongHigh", "rawLongLow", "readUUID", "Lorg/kodein/memory/io/Readable;", "startOf", "timeUUID", "unixTimestamp", "writeUUID", "klio"})
public final class UUIDKt {
    public static final void writeUUID(@NotNull Writeable $this$writeUUID, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $this$writeUUID.writeLong(uuid.getMostSignificantBits());
        $this$writeUUID.writeLong(uuid.getLeastSignificantBits());
    }

    public static final void putUUID(@NotNull Memory $this$putUUID, int index, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$putUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $this$putUUID.putLong(index, uuid.getMostSignificantBits());
        $this$putUUID.putLong(index + 8, uuid.getLeastSignificantBits());
    }

    @NotNull
    public static final UUID readUUID(@NotNull Readable $this$readUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$readUUID, (String)"<this>");
        long msb = $this$readUUID.readLong();
        long lsb = $this$readUUID.readLong();
        return new UUID(msb, lsb);
    }

    @NotNull
    public static final UUID getUUID(@NotNull ReadMemory $this$getUUID, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getUUID, (String)"<this>");
        long msb = $this$getUUID.getLong(index);
        long lsb = $this$getUUID.getLong(index + 8);
        return new UUID(msb, lsb);
    }

    @NotNull
    public static final UUID startOf(@NotNull UUID.Companion $this$startOf, long unixTimestampMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$startOf, (String)"<this>");
        long gregorianTimestamp = TimeUUIDs.INSTANCE.timestampUnixToGregorian(unixTimestampMillis);
        return new UUID(TimeUUIDs.INSTANCE.makeMsb(gregorianTimestamp), -9187201950435737472L);
    }

    @NotNull
    public static final UUID endOf(@NotNull UUID.Companion $this$endOf, long unixTimestampMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$endOf, (String)"<this>");
        long gregorianTimestamp = TimeUUIDs.INSTANCE.timestampUnixToGregorian(unixTimestampMillis + 1L) - 1L;
        return new UUID(TimeUUIDs.INSTANCE.makeMsb(gregorianTimestamp), 0x7F7F7F7F7F7F7F7FL);
    }

    public static final long gregorianTimestamp(@NotNull UUID $this$gregorianTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$gregorianTimestamp, (String)"<this>");
        if ($this$gregorianTimestamp.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return ($this$gregorianTimestamp.getMostSignificantBits() & 0xFFFL) << 48 | ($this$gregorianTimestamp.getMostSignificantBits() >> 16 & 0xFFFFL) << 32 | $this$gregorianTimestamp.getMostSignificantBits() >>> 32;
    }

    public static final long unixTimestamp(@NotNull UUID $this$unixTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$unixTimestamp, (String)"<this>");
        return TimeUUIDs.INSTANCE.timestampGregorianToUnix(UUIDKt.gregorianTimestamp($this$unixTimestamp));
    }

    public static final int clockSequence(@NotNull UUID $this$clockSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$clockSequence, (String)"<this>");
        if ($this$clockSequence.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return (int)(($this$clockSequence.getLeastSignificantBits() & 0x3FFF000000000000L) >>> 48);
    }

    public static final long node(@NotNull UUID $this$node) {
        Intrinsics.checkNotNullParameter((Object)$this$node, (String)"<this>");
        if ($this$node.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        return $this$node.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    @NotNull
    public static final UUID timeUUID(@NotNull UUID.Companion $this$timeUUID, long unixTimestampMillis, int clockSequence, long node) {
        long realNode;
        long realClockSeq;
        Intrinsics.checkNotNullParameter((Object)$this$timeUUID, (String)"<this>");
        long l = TimeUUIDs.INSTANCE.getMIN_UNIX_TIMESTAMP();
        if (!(unixTimestampMillis <= TimeUUIDs.INSTANCE.getMAX_UNIX_TIMESTAMP() ? l <= unixTimestampMillis : false)) {
            boolean bl = false;
            String string = "Bad timestamp (must be in " + TimeUUIDs.INSTANCE.getMIN_UNIX_TIMESTAMP() + ".." + TimeUUIDs.INSTANCE.getMAX_UNIX_TIMESTAMP() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        long l2 = realClockSeq = clockSequence == -1 ? Random.Default.nextLong(16384L) : (long)clockSequence;
        if (!(0L <= realClockSeq ? realClockSeq < 16384L : false)) {
            boolean bl = false;
            String string = "Bad clock sequence (must be in 0..0x3FFF)";
            throw new IllegalArgumentException(string.toString());
        }
        long l3 = realNode = node == -1L ? Random.Default.nextLong(0x1000000000000L) : node;
        if (!(0L <= realNode ? realNode < 0x1000000000000L : false)) {
            boolean bl = false;
            String string = "Bad node (must be in 0..0xFFFFFFFFFFFF)";
            throw new IllegalArgumentException(string.toString());
        }
        long gregorianTimestamp = TimeUUIDs.INSTANCE.timestampUnixToGregorian(unixTimestampMillis);
        return new UUID(TimeUUIDs.INSTANCE.makeMsb(gregorianTimestamp), TimeUUIDs.INSTANCE.makeLsb(realClockSeq, realNode));
    }

    public static /* synthetic */ UUID timeUUID$default(UUID.Companion companion, long l, int n, long l2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = TimestampJvmKt.currentTimestampMillis();
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            l2 = -1L;
        }
        return UUIDKt.timeUUID(companion, l, n, l2);
    }

    @NotNull
    public static final UUID randomUUID(@NotNull UUID.Companion $this$randomUUID, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)$this$randomUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        ByteArrayMemory data = MemoryKt.array(Memory.Companion, 16);
        RandomKt.nextBytes(random, data);
        data.set(6, (byte)(data.get(6) & 0xF));
        data.set(6, (byte)(data.get(6) | 0x40));
        data.set(8, (byte)(data.get(8) & 0x3F));
        data.set(8, (byte)(data.get(8) | 0x80));
        return new UUID(data.getLong(0), data.getLong(8));
    }

    public static /* synthetic */ UUID randomUUID$default(UUID.Companion companion, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = (Random)Random.Default;
        }
        return UUIDKt.randomUUID(companion, random);
    }

    @NotNull
    public static final UUID fromRawLongs-AQyPONk(@NotNull UUID.Companion $this$fromRawLongs_u2dAQyPONk, long high, long low, int version, int variant) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$fromRawLongs_u2dAQyPONk, (String)"$this$fromRawLongs");
        if (!(0 <= version ? version < 16 : false)) {
            boolean $i$a$-require-UUIDKt$fromRawLongs$42 = false;
            String $i$a$-require-UUIDKt$fromRawLongs$42 = "Version must be in 0..0xF";
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawLongs$42.toString());
        }
        if (!(0 <= UnsignedKt.ulongCompare((long)high, (long)0L) ? UnsignedKt.ulongCompare((long)high, (long)0xFFFFFFFFFFFFFFFL) <= 0 : false)) {
            boolean $i$a$-require-UUIDKt$fromRawLongs$52 = false;
            String $i$a$-require-UUIDKt$fromRawLongs$52 = "High must be in 0..0xFFFFFFFFFFFFFFF";
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawLongs$52.toString());
        }
        switch (variant) {
            case 0: {
                pair = TuplesKt.to((Object)1, (Object)0);
                break;
            }
            case 1: {
                pair = TuplesKt.to((Object)2, (Object)2);
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)3, (Object)6);
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)3, (Object)7);
                break;
            }
            default: {
                throw new IllegalArgumentException("Variant must be in 0..3");
            }
        }
        Pair pair2 = pair;
        int variantBitCount = ((Number)pair2.component1()).intValue();
        int variantCode = ((Number)pair2.component2()).intValue();
        long maxLow = ULong.constructor-impl((long)(1L << 64 - variantBitCount - 1));
        if (!(0 <= UnsignedKt.ulongCompare((long)low, (long)0L) ? UnsignedKt.ulongCompare((long)low, (long)maxLow) <= 0 : false)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Low with variant ").append(variant).append(" must be in 0..0x");
            String string = UStringsKt.toString-JSWoG40((long)maxLow, (int)16).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException(string2.toString());
        }
        UUID.Companion $this$fromRawLongs_AQyPONk_u24lambda_u2d6 = $this$fromRawLongs_u2dAQyPONk;
        boolean bl = false;
        long l = ULong.constructor-impl((long)(ULong.constructor-impl((long)(high << 4)) & 0xFFFFFFFFFFFF0000L));
        long r = ULong.constructor-impl((long)(high & 0xFFFL));
        long v = ULong.constructor-impl((long)(ULong.constructor-impl((long)version) << 12));
        long msb = ULong.constructor-impl((long)(ULong.constructor-impl((long)(l | r)) | v));
        UUID.Companion $this$fromRawLongs_AQyPONk_u24lambda_u2d7 = $this$fromRawLongs_u2dAQyPONk;
        boolean bl2 = false;
        long v2 = ULong.constructor-impl((long)(ULong.constructor-impl((long)variantCode) << 64 - variantBitCount));
        long lsb = ULong.constructor-impl((long)(low | v2));
        return new UUID(msb, lsb);
    }

    public static /* synthetic */ UUID fromRawLongs-AQyPONk$default(UUID.Companion companion, long l, long l2, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        return UUIDKt.fromRawLongs-AQyPONk(companion, l, l2, n, n2);
    }

    public static final long rawLongHigh(@NotNull UUID $this$rawLongHigh) {
        Intrinsics.checkNotNullParameter((Object)$this$rawLongHigh, (String)"<this>");
        long msb = ULong.constructor-impl((long)$this$rawLongHigh.getMostSignificantBits());
        long l = ULong.constructor-impl((long)(ULong.constructor-impl((long)(msb & 0xFFFFFFFFFFFF0000L)) >>> 4));
        long r = ULong.constructor-impl((long)(msb & 0xFFFL));
        return ULong.constructor-impl((long)(l | r));
    }

    public static final long rawLongLow(@NotNull UUID $this$rawLongLow) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$rawLongLow, (String)"<this>");
        long lsb = ULong.constructor-impl((long)$this$rawLongLow.getLeastSignificantBits());
        switch ($this$rawLongLow.variant()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: 
            case 3: {
                n = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown variant".toString());
            }
        }
        int bitCount = n;
        long mask = ULong.constructor-impl((long)(ULong.constructor-impl((long)(1L << 64 - bitCount)) - 1L));
        return ULong.constructor-impl((long)(lsb & mask));
    }

    @NotNull
    public static final UUID fromRawBytes(@NotNull UUID.Companion $this$fromRawBytes, @NotNull Memory input, int version, int variant) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$fromRawBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input.getSize() == 15)) {
            boolean $i$a$-require-UUIDKt$fromRawBytes$32 = false;
            String $i$a$-require-UUIDKt$fromRawBytes$32 = "Input must be exactly 15 bytes (not " + input.getSize() + ')';
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawBytes$32.toString());
        }
        if (!(0 <= version ? version < 16 : false)) {
            boolean $i$a$-require-UUIDKt$fromRawBytes$42 = false;
            String $i$a$-require-UUIDKt$fromRawBytes$42 = "Version must be in 0..0xF";
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawBytes$42.toString());
        }
        switch (variant) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 12;
                break;
            }
            case 3: {
                n = 14;
                break;
            }
            default: {
                throw new IllegalArgumentException("Variant must be in 0..3");
            }
        }
        int variantCode = n;
        Memory.Companion companion = Memory.Companion;
        int size$iv = 16;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$fromRawBytes_u24lambda_u2d10 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        $this$fromRawBytes_u24lambda_u2d10.writeBytes(input.slice(0, 6));
        $this$fromRawBytes_u24lambda_u2d10.writeByte((byte)(version << 4 & 0xF0 | input.get(6) >>> 4 & 0xF));
        $this$fromRawBytes_u24lambda_u2d10.writeByte((byte)(input.get(6) << 4 & 0xF0 | input.get(7) >>> 4 & 0xF));
        $this$fromRawBytes_u24lambda_u2d10.writeByte((byte)(variantCode << 4 & 0xF0 | input.get(7) & 0xF));
        $this$fromRawBytes_u24lambda_u2d10.writeBytes(input.slice(8, 7));
        int length$iv = w$iv$iv.getPosition();
        ByteArrayMemory buffer = size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv);
        return new UUID(buffer.getLong(0), buffer.getLong(8));
    }

    public static /* synthetic */ UUID fromRawBytes$default(UUID.Companion companion, Memory memory, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return UUIDKt.fromRawBytes(companion, memory, n, n2);
    }

    public static final void rawBytes(@NotNull UUID $this$rawBytes, @NotNull Writeable output) {
        Intrinsics.checkNotNullParameter((Object)$this$rawBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Memory.Companion companion = Memory.Companion;
        int size$iv = 16;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$rawBytes_u24lambda_u2d11 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        $this$rawBytes_u24lambda_u2d11.writeLong($this$rawBytes.getMostSignificantBits());
        $this$rawBytes_u24lambda_u2d11.writeLong($this$rawBytes.getLeastSignificantBits());
        int length$iv = w$iv$iv.getPosition();
        ByteArrayMemory buffer = size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv);
        output.writeBytes(buffer.slice(0, 6));
        output.writeByte((byte)(buffer.get(6) << 4 & 0xF0 | buffer.get(7) >>> 4 & 0xF));
        output.writeByte((byte)(buffer.get(7) << 4 & 0xF0 | buffer.get(8) & 0xF));
        output.writeBytes(buffer.slice(9, 7));
    }

    @NotNull
    public static final byte[] rawBytes(@NotNull UUID $this$rawBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$rawBytes, (String)"<this>");
        Memory.Companion companion = Memory.Companion;
        int size$iv = 15;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$rawBytes_u24lambda_u2d12 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        UUIDKt.rawBytes($this$rawBytes, $this$rawBytes_u24lambda_u2d12);
        int length$iv = w$iv$iv.getPosition();
        return (size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv)).getArray();
    }

    @NotNull
    public static final UUID fromRawParts-eCnZzQw(@NotNull UUID.Companion $this$fromRawParts_u2deCnZzQw, int part1, short part2, short part3, short part4, long part5, int version, int variant) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$fromRawParts_u2deCnZzQw, (String)"$this$fromRawParts");
        int n = UInt.constructor-impl((int)(part3 & 0xFFFF));
        if (!(0 <= UnsignedKt.uintCompare((int)n, (int)0) ? UnsignedKt.uintCompare((int)n, (int)4095) <= 0 : false)) {
            boolean $i$a$-require-UUIDKt$fromRawParts$42 = false;
            String $i$a$-require-UUIDKt$fromRawParts$42 = "Part3 must be in 0..0xFF";
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawParts$42.toString());
        }
        switch (variant) {
            case 0: {
                pair = TuplesKt.to((Object)1, (Object)0);
                break;
            }
            case 1: {
                pair = TuplesKt.to((Object)2, (Object)2);
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)3, (Object)6);
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)3, (Object)7);
                break;
            }
            default: {
                throw new IllegalArgumentException("Variant must be in 0..3");
            }
        }
        Pair pair2 = pair;
        int variantBitCount = ((Number)pair2.component1()).intValue();
        int variantCode = ((Number)pair2.component2()).intValue();
        int maxPart4 = UInt.constructor-impl((int)(UInt.constructor-impl((int)(1 << 16 - variantBitCount)) - 1));
        int n2 = UInt.constructor-impl((int)(part4 & 0xFFFF));
        if (!(0 <= UnsignedKt.uintCompare((int)n2, (int)0) ? UnsignedKt.uintCompare((int)n2, (int)maxPart4) <= 0 : false)) {
            boolean $i$a$-require-UUIDKt$fromRawParts$52 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Part4 with variant ").append(variant).append(" must be in 0..0x");
            String string = UStringsKt.toString-V7xB4Y4((int)maxPart4, (int)16).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String $i$a$-require-UUIDKt$fromRawParts$52 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException($i$a$-require-UUIDKt$fromRawParts$52.toString());
        }
        if (!(0 <= UnsignedKt.ulongCompare((long)part5, (long)0L) ? UnsignedKt.ulongCompare((long)part5, (long)0xFFFFFFFFFFFFL) <= 0 : false)) {
            boolean bl = false;
            String string = "part5 must be in 0..0xFFFFFFFFFFFF";
            throw new IllegalArgumentException(string.toString());
        }
        long msb = ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)part1 & 0xFFFFFFFFL)) << 32)) | ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)part2 & 0xFFFFL)) << 16)))) | ULong.constructor-impl((long)(ULong.constructor-impl((long)version) << 12)))) | ULong.constructor-impl((long)((long)part3 & 0xFFFFL))));
        long lsb = ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)variantCode) << 64 - variantBitCount)) | ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)part4 & 0xFFFFL)) << 48)))) | part5));
        return new UUID(msb, lsb);
    }

    public static /* synthetic */ UUID fromRawParts-eCnZzQw$default(UUID.Companion companion, int n, short s, short s2, short s3, long l, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            n3 = 1;
        }
        return UUIDKt.fromRawParts-eCnZzQw(companion, n, s, s2, s3, l, n2, n3);
    }

    @NotNull
    public static final UUID fromRawParts-_tqAewc(@NotNull UUID.Companion $this$fromRawParts_u2d_tqAewc, int part1, short part2, short part3, short part4, @NotNull Memory part5, int version, int variant) {
        Intrinsics.checkNotNullParameter((Object)$this$fromRawParts_u2d_tqAewc, (String)"$this$fromRawParts");
        Intrinsics.checkNotNullParameter((Object)part5, (String)"part5");
        if (!(part5.getSize() == 6)) {
            boolean bl = false;
            String string = "Part5 must be exactly 6 bytes (not " + part5.getSize() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        Memory.Companion companion = Memory.Companion;
        int size$iv = 8;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$fromRawParts__tqAewc_u24lambda_u2d17 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        $this$fromRawParts__tqAewc_u24lambda_u2d17.writeShort((short)0);
        $this$fromRawParts__tqAewc_u24lambda_u2d17.writeBytes(part5);
        int length$iv = w$iv$iv.getPosition();
        long part5Long = ReadMemoryKt.getULong(size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv), 0);
        return UUIDKt.fromRawParts-eCnZzQw($this$fromRawParts_u2d_tqAewc, part1, part2, part3, part4, part5Long, version, variant);
    }

    public static /* synthetic */ UUID fromRawParts-_tqAewc$default(UUID.Companion companion, int n, short s, short s2, short s3, Memory memory, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            n3 = 1;
        }
        return UUIDKt.fromRawParts-_tqAewc(companion, n, s, s2, s3, memory, n2, n3);
    }

    public static final int part1(@NotNull UUID $this$part1) {
        Intrinsics.checkNotNullParameter((Object)$this$part1, (String)"<this>");
        return UInt.constructor-impl((int)((int)($this$part1.getMostSignificantBits() >>> 32 & 0xFFFFFFFFL)));
    }

    public static final short part2(@NotNull UUID $this$part2) {
        Intrinsics.checkNotNullParameter((Object)$this$part2, (String)"<this>");
        return UShort.constructor-impl((short)((short)($this$part2.getMostSignificantBits() >>> 16 & 0xFFFFL)));
    }

    public static final short part3(@NotNull UUID $this$part3) {
        Intrinsics.checkNotNullParameter((Object)$this$part3, (String)"<this>");
        return UShort.constructor-impl((short)((short)($this$part3.getMostSignificantBits() & 0xFFFL)));
    }

    public static final short part4(@NotNull UUID $this$part4) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$part4, (String)"<this>");
        switch ($this$part4.variant()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: 
            case 3: {
                n = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown variant".toString());
            }
        }
        int bitCount = n;
        long mask = (1L << 16 - bitCount) - 1L;
        return UShort.constructor-impl((short)((short)($this$part4.getLeastSignificantBits() >>> 48 & mask)));
    }

    public static final long part5Long(@NotNull UUID $this$part5Long) {
        Intrinsics.checkNotNullParameter((Object)$this$part5Long, (String)"<this>");
        return ULong.constructor-impl((long)($this$part5Long.getLeastSignificantBits() & 0xFFFFFFFFFFFFL));
    }

    public static final void part5Bytes(@NotNull UUID $this$part5Bytes, @NotNull Writeable output) {
        Intrinsics.checkNotNullParameter((Object)$this$part5Bytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Memory.Companion companion = Memory.Companion;
        int size$iv = 8;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$part5Bytes_u24lambda_u2d18 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        $this$part5Bytes_u24lambda_u2d18.writeLong($this$part5Bytes.getLeastSignificantBits());
        int length$iv = w$iv$iv.getPosition();
        Memory bytes = MemoryKt.sliceAt(size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv), 2);
        output.writeBytes(bytes);
    }

    @NotNull
    public static final byte[] part5Bytes(@NotNull UUID $this$part5Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$part5Bytes, (String)"<this>");
        Memory.Companion companion = Memory.Companion;
        int size$iv = 6;
        boolean $i$f$array = false;
        ByteArrayMemory memory$iv = MemoryKt.array(Memory.Companion, size$iv);
        Memory $this$write$iv$iv = memory$iv;
        boolean $i$f$write = false;
        MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable($this$write$iv$iv);
        CursorWriteable $this$array_u24lambda_u2d3$iv = w$iv$iv;
        boolean bl = false;
        Writeable $this$part5Bytes_u24lambda_u2d19 = $this$array_u24lambda_u2d3$iv;
        boolean bl2 = false;
        UUIDKt.part5Bytes($this$part5Bytes, $this$part5Bytes_u24lambda_u2d19);
        int length$iv = w$iv$iv.getPosition();
        return (size$iv == length$iv ? memory$iv : (ByteArrayMemory)memory$iv.slice(0, length$iv)).getArray();
    }
}

