/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import gwt.jsonix.marshallers.xjc.plugin.dtos.ConstructorMapper;
import gwt.jsonix.marshallers.xjc.plugin.exceptions.ParseModelException;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import gwt.jsonix.marshallers.xjc.plugin.utils.ClassNameUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.JsArrayLike;
import org.apache.commons.lang3.StringUtils;
import org.hisrc.jsonix.settings.LogLevelSetting;
import org.jvnet.jaxb2_commons.plugin.inheritance.Customizations;
import org.jvnet.jaxb2_commons.plugin.inheritance.ExtendsClass;
import org.jvnet.jaxb2_commons.plugin.inheritance.ExtendsClassReader;
import org.jvnet.jaxb2_commons.plugin.inheritance.util.JavaTypeParser;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;

public class ModelBuilder {
    private ModelBuilder() {
    }

    public static void generateJSInteropModels(Map<String, JClass> definedClassesMap, Model model, JCodeModel jCodeModel, Map<String, String> packageModuleMap, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        definedClassesMap.clear();
        BuilderUtils.log(LogLevelSetting.DEBUG, "Generating JSInterop code...");
        for (CClassInfo cClassInfo : model.beans().values()) {
            ModelBuilder.populateJCodeModel(definedClassesMap, jCodeModel, cClassInfo, packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
        }
    }

    protected static void populateJCodeModel(Map<String, JClass> definedClassesMap, JCodeModel toPopulate, CClassInfo cClassInfo, Map<String, String> packageModuleMap, Model model, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws JClassAlreadyExistsException, ParseModelException {
        String parentClassName;
        String jsTypeName;
        JExpression nameSpaceExpression;
        String moduleName;
        JDefinedClass jDefinedClass;
        String shortClassName;
        BuilderUtils.log(LogLevelSetting.DEBUG, "Generating  JCode model...");
        if (definedClassesMap.containsKey(cClassInfo.fullName())) {
            return;
        }
        CClassInfoParent parent = cClassInfo.parent();
        CClassInfo basecClassInfo = cClassInfo.getBaseClass();
        JClass jDefinedBaseClass = null;
        String nameSpace = shortClassName = cClassInfo.shortName;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((CClassInfo)cClassInfo, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        if (Objects.nonNull(extendsClassCustomization)) {
            jDefinedBaseClass = ModelBuilder.getFromExtendsClassCustomization(definedClassesMap, toPopulate, extendsClassCustomization);
        }
        if (basecClassInfo != null) {
            jDefinedBaseClass = ModelBuilder.getFromBasecClassInfo(definedClassesMap, toPopulate, packageModuleMap, model, basecClassInfo, jsUtilsClass, jsiNameClass, mapToPopulate);
        }
        boolean hasClassParent = parent != null && !(parent instanceof CClassInfoParent.Package);
        String nameSpaceString = null;
        if (hasClassParent && definedClassesMap.containsKey(parent.fullName())) {
            JDefinedClass parentJSIClass = ModelBuilder.getParentJSIClass(definedClassesMap, parent.fullName());
            jDefinedClass = ModelBuilder.getFromParent(jDefinedBaseClass, parentJSIClass, nameSpace);
            moduleName = packageModuleMap.get(jDefinedClass._package().name());
            nameSpaceString = ClassNameUtils.getJsInteropTypeName(moduleName, parentJSIClass.fullName());
            nameSpaceExpression = JExpr.lit((String)nameSpaceString);
            jsTypeName = shortClassName;
            parentClassName = ((CClassInfo)cClassInfo.parent()).shortName;
        } else {
            String fullClassName = cClassInfo.getOwnerPackage().name() + ".JSI" + nameSpace;
            jDefinedClass = jDefinedBaseClass != null ? toPopulate._class(fullClassName)._extends(jDefinedBaseClass) : toPopulate._class(fullClassName);
            moduleName = packageModuleMap.get(jDefinedClass._package().name());
            nameSpaceExpression = toPopulate.ref(JsPackage.class).staticRef("GLOBAL");
            jsTypeName = ClassNameUtils.getJsInteropTypeName(moduleName, jDefinedClass.fullName());
            parentClassName = null;
        }
        definedClassesMap.put(cClassInfo.fullName(), (JClass)jDefinedClass);
        JDocComment comment = jDefinedClass.javadoc();
        String commentString = "JSInterop adapter for <code>" + nameSpace + "</code>";
        comment.append((Object)commentString);
        jDefinedClass.annotate(toPopulate.ref(JsType.class)).param("namespace", nameSpaceExpression).param("name", jsTypeName).param("isNative", true);
        String typeNameConstant = Stream.of(moduleName, parentClassName, nameSpace).filter(Objects::nonNull).collect(Collectors.joining("."));
        ConstructorMapper toAdd = new ConstructorMapper(typeNameConstant, jsTypeName, nameSpaceString);
        mapToPopulate.computeIfAbsent(moduleName, k -> new ArrayList());
        mapToPopulate.get(moduleName).add(toAdd);
        JFieldVar typeNameField = ModelBuilder.addTypeName(jDefinedClass, toPopulate, typeNameConstant);
        ModelBuilder.addInstanceOf(jDefinedClass, jsUtilsClass, typeNameField);
        if (cClassInfo.getTypeName() != null) {
            ModelBuilder.addGetJSINameMethod(jDefinedClass, cClassInfo.getTypeName(), jsiNameClass);
        }
        ModelBuilder.addGetTypeNameProperty(toPopulate, jDefinedClass);
        for (CPropertyInfo cPropertyInfo : cClassInfo.getProperties()) {
            ModelBuilder.addProperty(toPopulate, jDefinedClass, cPropertyInfo, definedClassesMap, packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
        }
        if (cClassInfo.declaresAttributeWildcard()) {
            ModelBuilder.addOtherAttributesProperty(toPopulate, jDefinedClass, jsUtilsClass, nameSpace);
        }
    }

    protected static void populateJCodeModel(Map<String, JClass> definedClassesMap, JCodeModel toPopulate, CEnumLeafInfo cEnumLeafInfo) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Generating  JCode model...");
        String fullClassName = cEnumLeafInfo.parent.getOwnerPackage().name() + ".JSI" + cEnumLeafInfo.shortName;
        JDefinedClass jDefinedClass = toPopulate._class(fullClassName, ClassType.ENUM);
        jDefinedClass.annotate(toPopulate.ref(JsType.class)).param("name", cEnumLeafInfo.shortName);
        definedClassesMap.put(cEnumLeafInfo.fullName(), (JClass)jDefinedClass);
        JDocComment comment = jDefinedClass.javadoc();
        String commentString = "JSInterop adapter for <code>" + cEnumLeafInfo.shortName + "</code>";
        comment.append((Object)commentString);
        cEnumLeafInfo.getConstants().forEach(cEnumConstant -> {
            JEnumConstant jEnumConstant = jDefinedClass.enumConstant(cEnumConstant.getName());
            if (cEnumLeafInfo.needsValueField()) {
                jEnumConstant.arg(JExpr.lit((String)cEnumConstant.getLexicalValue()));
            }
        });
        if (cEnumLeafInfo.needsValueField()) {
            ModelBuilder.addEnumValueField(toPopulate, jDefinedClass);
        }
    }

    protected static JClass getFromExtendsClassCustomization(Map<String, JClass> definedClassesMap, JCodeModel toPopulate, CPluginCustomization extendsClassCustomization) {
        ExtendsClass extendsClass = (ExtendsClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)extendsClassCustomization);
        String extendsClassName = ExtendsClassReader.getValue(extendsClass);
        return ModelBuilder.parseClass(extendsClassName, toPopulate, definedClassesMap);
    }

    protected static JClass getFromBasecClassInfo(Map<String, JClass> definedClassesMap, JCodeModel toPopulate, Map<String, String> packageModuleMap, Model model, CClassInfo basecClassInfo, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        if (!definedClassesMap.containsKey(basecClassInfo.fullName())) {
            ModelBuilder.populateJCodeModel(definedClassesMap, toPopulate, basecClassInfo, packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
        }
        return definedClassesMap.get(basecClassInfo.fullName());
    }

    protected static JDefinedClass getParentJSIClass(Map<String, JClass> definedClassesMap, String parentFullName) {
        return (JDefinedClass)definedClassesMap.get(parentFullName);
    }

    protected static JDefinedClass getFromParent(JClass jDefinedBaseClass, JDefinedClass parentJSIClass, String nameSpace) throws JClassAlreadyExistsException {
        int mod = 17;
        return jDefinedBaseClass != null ? parentJSIClass._class(mod, "JSI" + nameSpace)._extends(jDefinedBaseClass) : parentJSIClass._class(mod, "JSI" + nameSpace);
    }

    protected static void addEnumValueField(JCodeModel toPopulate, JDefinedClass jDefinedClass) {
        JClass propertyRef = toPopulate.ref(String.class);
        String privatePropertyName = "value";
        int mod = 12;
        JFieldVar field = jDefinedClass.field(mod, (JType)propertyRef, privatePropertyName);
        mod = 0;
        JMethod constructor = jDefinedClass.constructor(mod);
        JVar param = constructor.param((JType)propertyRef, privatePropertyName);
        constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        mod = 1;
        JMethod getterMethod = jDefinedClass.method(mod, (JType)propertyRef, privatePropertyName);
        getterMethod.body()._return((JExpression)field);
    }

    protected static void addInstanceOf(JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JFieldVar typeNameField) {
        int mods = 17;
        String methodName = "instanceOf";
        JMethod instanceOfMethod = jDefinedClass.method(17, Boolean.TYPE, "instanceOf");
        JBlock block = instanceOfMethod.body();
        JVar typeParam = instanceOfMethod.param(8, Object.class, "instance");
        JInvocation getTypeName = jsUtilsClass.staticInvoke("getTypeName").arg((JExpression)typeParam);
        instanceOfMethod.annotate(JsOverlay.class);
        block._return((JExpression)typeNameField.invoke("equals").arg((JExpression)getTypeName));
    }

    protected static JFieldVar addTypeName(JDefinedClass jDefinedClass, JCodeModel jCodeModel, String typeName) {
        JClass propertyRef = jCodeModel.ref(String.class);
        int mods = 25;
        JFieldVar typeNameField = jDefinedClass.field(25, (JType)propertyRef, "TYPE");
        typeNameField.annotate(JsOverlay.class);
        typeNameField.init(JExpr.lit((String)typeName));
        return typeNameField;
    }

    protected static void addGetJSINameMethod(JDefinedClass jDefinedClass, QName typeName, JDefinedClass jsiNameClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add getJSIName method to object %1$s.%2$s ...", jDefinedClass._package().name(), jDefinedClass.name()));
        String getterMethodName = "getJSIName";
        int mod = 17;
        JMethod getterMethod = jDefinedClass.method(mod, (JType)jsiNameClass, getterMethodName);
        getterMethod.annotate(JsOverlay.class);
        JDocComment getterComment = getterMethod.javadoc();
        String commentString = "Getter for specific <code>JSIName</code>";
        getterComment.append((Object)commentString);
        JCommentPart getterCommentReturnPart = getterComment.addReturn();
        getterCommentReturnPart.add((Object)commentString);
        JBlock body = getterMethod.body();
        JVar toReturn = body.decl((JType)jsiNameClass, "toReturn", (JExpression)JExpr._new((JClass)jsiNameClass));
        body.add((JStatement)toReturn.invoke("setNamespaceURI").arg(typeName.getNamespaceURI()));
        body.add((JStatement)toReturn.invoke("setLocalPart").arg(typeName.getLocalPart()));
        body.add((JStatement)toReturn.invoke("setPrefix").arg(typeName.getPrefix()));
        body.add((JStatement)toReturn.invoke("setKey").arg("{" + typeName.getNamespaceURI() + "}"));
        if (!StringUtils.isEmpty((CharSequence)typeName.getPrefix())) {
            body.add((JStatement)toReturn.invoke("setString").arg("{" + typeName.getNamespaceURI() + "}" + typeName.getPrefix() + ":" + typeName.getLocalPart()));
        } else {
            body.add((JStatement)toReturn.invoke("setString").arg("{" + typeName.getNamespaceURI() + "}" + typeName.getLocalPart()));
        }
        body._return((JExpression)toReturn);
    }

    protected static void addGetTypeNameProperty(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add getTYPENAME property to object %1$s.%2$s ...", jDefinedClass._package().name(), jDefinedClass.name()));
        JClass parameterRef = jCodeModel.ref(String.class);
        BuilderUtils.addNativeGetter(jCodeModel, jDefinedClass, parameterRef, "TYPE_NAME", "TYPE_NAME");
    }

    protected static void addProperty(JCodeModel jCodeModel, JDefinedClass jDefinedClass, CPropertyInfo cPropertyInfo, Map<String, JClass> definedClassesMap, Map<String, String> packageModuleMap, Model model, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        JClass propertyRef = ModelBuilder.getPropertyRef(jCodeModel, cPropertyInfo, jDefinedClass.fullName(), definedClassesMap, packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
        String publicPropertyName = cPropertyInfo.getName(true);
        String privatePropertyName = cPropertyInfo.getName(false);
        ModelBuilder.addGetter(jCodeModel, jDefinedClass, jsUtilsClass, propertyRef, publicPropertyName, privatePropertyName);
        ModelBuilder.addSetter(jCodeModel, jDefinedClass, propertyRef, publicPropertyName, privatePropertyName, jsUtilsClass);
    }

    protected static void addOtherAttributesProperty(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, String nameSpace) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add getOtherAttributes property to object %1$s.%2$s ...", jDefinedClass._package().name(), jDefinedClass.name()));
        JClass parameterRef = jCodeModel.ref(Map.class).narrow(new Class[]{QName.class, String.class});
        JMethod otherAttributesGetter = BuilderUtils.addNativeGetter(jCodeModel, jDefinedClass, parameterRef, "OtherAttributes", "otherAttributes");
        ModelBuilder.addSetter(jCodeModel, jDefinedClass, parameterRef, "OtherAttributes", "otherAttributes", jsUtilsClass);
        ModelBuilder.addStaticOtherAttributesGetter(jCodeModel, jDefinedClass, otherAttributesGetter, jsUtilsClass);
    }

    protected static void addStaticOtherAttributesGetter(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JMethod otherAttributesGetter, JDefinedClass jsUtilsClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add getOtherAttributesMap method to object %1$s.%2$s ...", jDefinedClass._package().name(), jDefinedClass.name()));
        int mods = 17;
        JClass parameterRef = jCodeModel.ref(Map.class).narrow(new Class[]{QName.class, String.class});
        JMethod jMethod = jDefinedClass.method(17, (JType)parameterRef, "getOtherAttributesMap");
        JVar instanceParam = jMethod.param(8, (JType)jDefinedClass, "instance");
        JBlock block = jMethod.body();
        JInvocation instanceOtherAttributes = instanceParam.invoke(otherAttributesGetter);
        jMethod.annotate(JsOverlay.class);
        block._return((JExpression)jsUtilsClass.staticInvoke("toAttributesMap").arg((JExpression)instanceOtherAttributes));
    }

    protected static JClass getPropertyRef(JCodeModel jCodeModel, CPropertyInfo cPropertyInfo, String outerClass, Map<String, JClass> definedClassesMap, Map<String, String> packageModuleMap, Model model, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        JClass typeRef = ModelBuilder.getOrCreatePropertyRef(cPropertyInfo, outerClass, definedClassesMap, jCodeModel, packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
        if (typeRef == null) {
            BuilderUtils.log(LogLevelSetting.WARN, "Failed to retrieve JClass for " + cPropertyInfo.getName(false) + " inside the JCodeModel");
            return null;
        }
        BuilderUtils.log(LogLevelSetting.DEBUG, typeRef.toString());
        if (cPropertyInfo.isCollection()) {
            if (typeRef.unboxify().isPrimitive()) {
                return typeRef.unboxify().array();
            }
            JClass rawArrayListClass = jCodeModel.ref(JsArrayLike.class);
            return rawArrayListClass.narrow(typeRef);
        }
        if (!typeRef.isPrimitive()) {
            typeRef = jCodeModel.ref(typeRef.unboxify().fullName());
        }
        return typeRef;
    }

    protected static JClass getOrCreatePropertyRef(CPropertyInfo cPropertyInfo, String outerClass, Map<String, JClass> definedClassesMap, JCodeModel jCodeModel, Map<String, String> packageModuleMap, Model model, JDefinedClass jsUtilsClass, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        String originalClassName = ModelBuilder.getOriginalClassName(cPropertyInfo, outerClass);
        return ModelBuilder.getOrCreatePropertyRef(originalClassName, definedClassesMap, jCodeModel, packageModuleMap, model, jsUtilsClass, !cPropertyInfo.isCollection(), jsiNameClass, mapToPopulate);
    }

    protected static JClass getOrCreatePropertyRef(String originalClassName, Map<String, JClass> definedClassesMap, JCodeModel jCodeModel, Map<String, String> packageModuleMap, Model model, JDefinedClass jsUtilsClass, boolean toUnbox, JDefinedClass jsiNameClass, Map<String, List<ConstructorMapper>> mapToPopulate) throws ParseModelException, JClassAlreadyExistsException {
        JClass toReturn;
        Optional<JClass> javaRef = BuilderUtils.getJavaRef(originalClassName, jCodeModel, toUnbox);
        if (javaRef.isPresent()) {
            toReturn = javaRef.get();
        } else {
            if (!definedClassesMap.containsKey(originalClassName)) {
                Optional<NClass> nClassKey = model.beans().keySet().stream().filter(nClass -> nClass.fullName().equals(originalClassName)).findFirst();
                Optional<NClass> nEnumKey = model.enums().keySet().stream().filter(nClass -> nClass.fullName().equals(originalClassName)).findFirst();
                if (nClassKey.isPresent()) {
                    ModelBuilder.populateJCodeModel(definedClassesMap, jCodeModel, (CClassInfo)model.beans().get(nClassKey.get()), packageModuleMap, model, jsUtilsClass, jsiNameClass, mapToPopulate);
                } else if (nEnumKey.isPresent()) {
                    ModelBuilder.populateJCodeModel(definedClassesMap, jCodeModel, (CEnumLeafInfo)model.enums().get(nEnumKey.get()));
                } else {
                    throw new ParseModelException("Failed to retrieve " + originalClassName + " inside the Model");
                }
            }
            toReturn = definedClassesMap.get(originalClassName);
        }
        return toReturn;
    }

    protected static String getOriginalClassName(CPropertyInfo cPropertyInfo, String outerClass) {
        String fullClassName = null;
        BuilderUtils.log(LogLevelSetting.DEBUG, "getClassName...");
        if (cPropertyInfo instanceof CReferencePropertyInfo) {
            CReferencePropertyInfo cReferencePropertyInfo = (CReferencePropertyInfo)cPropertyInfo;
            Set elements = cReferencePropertyInfo.getElements();
            if (!elements.isEmpty()) {
                CElementInfo cElement = (CElementInfo)elements.toArray()[0];
                CElementPropertyInfo property = cElement.getProperty();
                fullClassName = ModelBuilder.getPropertyClassName((CPropertyInfo)property);
            } else if (cReferencePropertyInfo.baseType != null) {
                fullClassName = cReferencePropertyInfo.baseType.fullName();
            }
        } else {
            fullClassName = ModelBuilder.getPropertyClassName(cPropertyInfo);
        }
        if (fullClassName == null) {
            BuilderUtils.log(LogLevelSetting.WARN, "Failed to log ref for " + cPropertyInfo.getName(false) + " that is a " + cPropertyInfo.getClass().getCanonicalName() + " defined inside " + outerClass, null);
            fullClassName = "java.lang.Object";
        }
        if (fullClassName.equals("javax.xml.datatype.XMLGregorianCalendar")) {
            fullClassName = "java.util.Date";
        }
        return fullClassName;
    }

    protected static String getPropertyClassName(CPropertyInfo toLog) {
        String toReturn = null;
        if (!toLog.ref().isEmpty()) {
            toReturn = ((NType)((CTypeInfo)toLog.ref().iterator().next()).getType()).fullName();
            BuilderUtils.log(LogLevelSetting.DEBUG, "cPropertyInfo.ref().iterator().next().getType(): " + toReturn);
        }
        return toReturn;
    }

    protected static void addGetter(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        boolean isArray;
        boolean isJsArrayLike = propertyRef != null && Objects.equals(propertyRef.erasure().name(), "JsArrayLike");
        boolean bl = isArray = propertyRef != null && propertyRef.isArray();
        if (isJsArrayLike || isArray) {
            String nativePropertyName = "Native" + publicPropertyName;
            if (isArray) {
                BuilderUtils.addListGetterForArray(jCodeModel, jDefinedClass, propertyRef.elementType(), publicPropertyName, privatePropertyName);
                BuilderUtils.addAddMethodForArray(jCodeModel, jDefinedClass, propertyRef.elementType(), publicPropertyName, privatePropertyName);
                BuilderUtils.addAddAllMethodForArray(jCodeModel, jDefinedClass, propertyRef.elementType(), publicPropertyName, privatePropertyName);
                BuilderUtils.addRemoveMethodForArray(jCodeModel, jDefinedClass, propertyRef.elementType(), publicPropertyName, privatePropertyName);
            } else {
                JClass propertyRefTypeParam = (JClass)propertyRef.getTypeParameters().get(0);
                BuilderUtils.addListGetterForJsArrayLike(jCodeModel, jDefinedClass, jsUtilsClass, propertyRefTypeParam, publicPropertyName, privatePropertyName);
                BuilderUtils.addAddMethodForJsArrayLike(jCodeModel, jDefinedClass, jsUtilsClass, propertyRefTypeParam, publicPropertyName, privatePropertyName);
                BuilderUtils.addAddAllMethodForJsArrayLike(jCodeModel, jDefinedClass, jsUtilsClass, propertyRefTypeParam, publicPropertyName, privatePropertyName);
                BuilderUtils.addRemoveMethodForJsArrayLike(jCodeModel, jDefinedClass, jsUtilsClass, publicPropertyName, privatePropertyName);
            }
            BuilderUtils.addNativeGetter(jCodeModel, jDefinedClass, propertyRef, nativePropertyName, privatePropertyName);
        } else {
            BuilderUtils.addNativeGetter(jCodeModel, jDefinedClass, propertyRef, publicPropertyName, privatePropertyName);
        }
    }

    protected static void addSetter(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JClass propertyRef, String publicPropertyName, String privatePropertyName, JDefinedClass jsUtilsClass) {
        boolean isArray;
        boolean isJsArrayLike = propertyRef != null && Objects.equals(propertyRef.erasure().name(), "JsArrayLike");
        boolean bl = isArray = propertyRef != null && propertyRef.isArray();
        if (isJsArrayLike || isArray) {
            String nativePropertyName = "Native" + publicPropertyName;
            if (isArray) {
                BuilderUtils.addListSetterForArray(jCodeModel, jDefinedClass, propertyRef.elementType(), publicPropertyName, privatePropertyName);
            } else {
                JClass propertyRefTypeParam = (JClass)propertyRef.getTypeParameters().get(0);
                BuilderUtils.addListSetterForJsArrayLike(jCodeModel, jDefinedClass, jsUtilsClass, propertyRefTypeParam, publicPropertyName, privatePropertyName);
            }
            BuilderUtils.addNativeSetter(jCodeModel, jDefinedClass, propertyRef, nativePropertyName, privatePropertyName);
        } else {
            BuilderUtils.addNativeSetter(jCodeModel, jDefinedClass, propertyRef, publicPropertyName, privatePropertyName);
        }
    }

    protected static JClass parseClass(String className, JCodeModel codeModel, Map<String, JClass> definedClassesMap) {
        return new JavaTypeParser(definedClassesMap).parseClass(className, codeModel);
    }

    protected static String getJNIRepresentation(JDefinedClass toConvert) {
        String className = toConvert.name();
        if (toConvert.outer() != null) {
            className = toConvert.outer().name() + "$" + className;
        }
        String toReturn = "L" + toConvert._package().name().replace('.', '/') + "/" + className;
        return toReturn;
    }
}

